//! @file object.cpp
//! @brief objectNX̒`

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2015, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the@names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#include "object.h"

//! @brief RXgN^
object::object(class ParameterInfo *in_Param, float x, float y, float z, float rx, float size, bool flag)
{
	Param = in_Param;
	pos_x = x;
	pos_y = y;
	pos_z = z;
	rotation_x = rx;
	RenderFlag = flag;
	model_size = size;

	id_parameter = 0;
	id_model = -1;
	id_texture = -1;
}

//! @brief fBXgN^
object::~object()
{}

//! @brief ݒlǗNXo^
//! @attention e֐gpOɎs邱ƁB
void object::SetParameterInfoClass(class ParameterInfo *in_Param)
{
	Param = in_Param;
}

//! @brief WƊpxݒ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param rx ]
void object::SetPosData(float x, float y, float z, float rx)
{
	pos_x = x;
	pos_y = y;
	pos_z = z;
	rotation_x = rx;
}

//! @brief WƊpx擾
//! @param x XW󂯎|C^iNULLj
//! @param y YW󂯎|C^iNULLj
//! @param z ZW󂯎|C^iNULLj
//! @param rx ]󂯎|C^iNULLj
void object::GetPosData(float *x, float *y, float *z, float *rx)
{
	if( x != NULL ){ *x = pos_x; }
	if( y != NULL ){ *y = pos_y; }
	if( z != NULL ){ *z = pos_z; }
	if( rx != NULL ){ *rx = rotation_x; }
}

//! @brief `tOݒ
//! @param flag ݒ肷tO
void object::SetDrawFlag(bool flag)
{
	RenderFlag = flag;
}

//! @brief `tO擾
//! @return ݐݒ肳ĂtO
bool object::GetDrawFlag()
{
	return RenderFlag;
}

//! @brief ff[^ݒ
//! @param id fFԍ
//! @param size \{
void object::SetModel(int id, float size)
{
	id_model = id;
	model_size = size;
}

//! @brief eNX`ݒ
//! @param id eNX`Fԍ
void object::SetTexture(int id)
{
	id_texture = id;
}

//! @brief vZsiRȂǁj
int object::RunFrame()
{
	return 0;
}

//! @brief `
//! @param d3dg D3DGraphics̃|C^
void object::Render(D3DGraphics *d3dg)
{
	if( d3dg == NULL ){ return; }
	if( RenderFlag == false ){ return; }

	d3dg->SetWorldTransform(pos_x, pos_y, pos_z, rotation_x, 0.0f, model_size);
	d3dg->RenderModel(id_model, id_texture);
}

//! @brief RXgN^
human::human(class ParameterInfo *in_Param, float x, float y, float z, float rx, int id_param, int dataid, signed char p4, int team, bool flag)
{
	//HumanParameter data;

	Param = in_Param;
	pos_x = x;
	pos_y = y;
	pos_z = z;
	move_x = 0.0f;
	move_y = 0.0f;
	move_z = 0.0f;
	move_y_flag = false;
	rotation_x = rx;
	id_parameter = id_param;
	upmodel_size = 9.4f;
	armmodel_size = 9.0f;
	legmodel_size = 9.0f;
	RenderFlag = flag;
	rotation_y = 0.0f;
	armrotation_y = 0.0f;
	reaction_y = 0.0f;
	legrotation_x = 0.0f;
	point_dataid = dataid;
	point_p4 = p4;
	teamid = team;

	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		weapon[i] = NULL;
	}
	selectweapon = 1;
	//if( Param->GetHuman(id_param, &data) == 0 ){
	//	hp = data.hp;
	//}
	//else{
		hp = 0;
	//}
#ifdef HUMAN_DEADBODY_COLLISION
	deadstate = 0;
#endif
	id_texture = -1;
	id_upmodel = -1;
	for(int i=0; i<TOTAL_ARMMODE; i++){
		id_armmodel[i] = -1;
	}
	id_legmodel = -1;
	for(int i=0; i<TOTAL_WALKMODE; i++){
		id_walkmodel[i] = -1;
	}
	for(int i=0; i<TOTAL_RUNMODE; i++){
		id_runmodel[i] = -1;
	}

	move_rx = 0.0f;
	MoveFlag = 0x00;
	MoveFlag_lt = MoveFlag;
	scopemode = 0;
	HitFlag = false;
	walkcnt = 0;
	runcnt = 0;
	totalmove = 0.0f;
	StateGunsightErrorRange = 0;
	ReactionGunsightErrorRange = 0;
}

//! @brief fBXgN^
human::~human()
{}

//! @brief ݒlݒ
//! @param id_param l̎ޔԍ
//! @param dataid |Cg̃f[^ԍ
//! @param p4 4p[^
//! @param team `[ԍ
//! @param init IuWFNg
void human::SetParamData(int id_param, int dataid, signed char p4, int team, bool init)
{
	id_parameter = id_param;
	point_dataid = dataid;
	point_p4 = p4;
	teamid = team;

	if( init == true ){
		HumanParameter data;

		move_x = 0.0f;
		move_y = 0.0f;
		move_z = 0.0f;
		move_y_flag = false;
		rotation_y = 0.0f;
		armrotation_y = (float)M_PI/18 * -3;
		reaction_y = 0.0f;
		legrotation_x = 0.0f;

		for(int i=0; i<TOTAL_HAVEWEAPON; i++){
			weapon[i] = NULL;
		}
		selectweapon = 1;
		if( Param->GetHuman(id_param, &data) == 0 ){
			hp = data.hp;
		}
		else{
			hp = 0;
		}
#ifdef HUMAN_DEADBODY_COLLISION
		deadstate = 0;
#endif
		MoveFlag = 0x00;
		MoveFlag_lt = MoveFlag;
		scopemode = 0;
		HitFlag = false;
		totalmove = 0.0f;
		Invincible = false;
	}
}

//! @brief ݒl擾
//! @param id_param l̎ޔԍ󂯎|C^iNULLj
//! @param dataid |Cg̃f[^ԍ󂯎|C^iNULLj
//! @param p4 4p[^󂯎|C^iNULLj
//! @param team `[ԍ󂯎|C^iNULLj
void human::GetParamData(int *id_param, int *dataid, signed char *p4, int *team)
{
	if( id_param != NULL ){ *id_param = id_parameter; }
	if( dataid != NULL ){ *dataid = point_dataid; }
	if( p4 != NULL ){ *p4 = point_p4; }
	if( team != NULL ){ *team = teamid; }
}

//! @brief HP擾
//! @return HP
int human::GetHP()
{
	return hp;
}

//! @brief HPݒ
//! @param in_hp Vɐݒ肷HP
//! @return Ftrue@sFfalse
//! @attention HP1ȏ̐lɑ΂ĎsȂƎs܂B
bool human::SetHP(int in_hp)
{
	if( hp > 0 ){
		hp = in_hp;
		return true;
	}
	return false;
}


//! @brief ̂ǂ
//! @return ́Ftrue@̂łȂFfalse
//! @warning SɐÎ~ԂúvƔ肵܂B|ĂŒ̐l͑ΏۂɊ܂܂Ȃ߁Ahp <= 0 SĎ̂Ɣ肳Ƃ͌܂B
bool human::GetDeadFlag()
{
#ifdef HUMAN_DEADBODY_COLLISION
	if( deadstate == 4 ){ return true; }
	return false;
#else
	if( hp <= 0 ){ return true; }
	return false;
#endif
}

//! @brief `[ԍݒi㏑j
//! @param id V`[ԍ
void human::SetTeamID(int id)
{
	teamid = id;
}

//! @brief GtO擾
//! @return trueFG@falseFʏ
//! @attention GԂ̏ꍇAeeE֒e̔E@ɂ_[W؎󂯂܂B
bool human::GetInvincibleFlag()
{
	return Invincible;
}

//! @brief GtOݒ
//! @param flag trueFG@falseFʏ
//! @attention GԂ̏ꍇAeeE֒e̔E@ɂ_[W؎󂯂܂B
void human::SetInvincibleFlag(bool flag)
{
	Invincible = flag;
}

//! @brief Öړʂ擾
//! @param *x Xړʂ擾|C^iNULLj
//! @param *y Yړʂ擾|C^iNULLj
//! @param *z Zړʂ擾|C^iNULLj
void human::GetMovePos(float *x, float *y, float *z)
{
	if( x != NULL ){ *x = move_x; }
	if( y != NULL ){ *y = move_y; }
	if( z != NULL ){ *z = move_z; }
}

//! @brief ff[^ݒ
//! @param upmodel 㔼g̃f
//! @param armmodel[] r̃f̔ziz񐔁FTOTAL_ARMMODEj
//! @param legmodel iÎ~ԁj̃f
//! @param walkmodel[] r̃f̔ziz񐔁FTOTAL_WALKMODEj
//! @param runmodel[] r̃f̔ziz񐔁FTOTAL_RUNMODEj
void human::SetModel(int upmodel, int armmodel[], int legmodel, int walkmodel[], int runmodel[])
{
	id_upmodel = upmodel;
	for(int i=0; i<TOTAL_ARMMODE; i++){
		id_armmodel[i] = armmodel[i];
	}
	id_legmodel = legmodel;
	for(int i=0; i<TOTAL_WALKMODE; i++){
		id_walkmodel[i] = walkmodel[i];
	}
	for(int i=0; i<TOTAL_RUNMODE; i++){
		id_runmodel[i] = runmodel[i];
	}
}

//! @brief ݒ
//! @param in_weapon[] ݒ肷weaponNX̃|C^z
//! @warning ʏ PickupWeapon()֐ gp邱
void human::SetWeapon(class weapon *in_weapon[])
{
	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		if( in_weapon[i] == NULL ){
			weapon[i] = NULL;
		}
		else{
			//𐳂E΁AƂēo^
			if( in_weapon[i]->Pickup() == 0 ){
				weapon[i] = in_weapon[i];
			}
		}
	}
}

//! @brief E
//! @param in_weapon[] ݒ肷weaponNX̃|C^
//! @return F1@sF0
//! @attention l̎ނ ]r ̏ꍇÅ֐͎s܂B
int human::PickupWeapon(class weapon *in_weapon)
{
	if( in_weapon == NULL ){
		return 0;
	}

	//l̎ނ ]r Ȃ΁As
	HumanParameter Paraminfo;
	Param->GetHuman(id_parameter, &Paraminfo);
	if( Paraminfo.type == 2 ){
		return 0;
	}

	if( weapon[selectweapon] == NULL ){
		//𐳂E΁AƂēo^
		if( in_weapon->Pickup() == 0 ){
			weapon[selectweapon] = in_weapon;

			//؂ւ̃JEg
			selectweaponcnt = 10;

			return 1;
		}
	}
	return 0;
}

//! @brief ؂ւiւj
//! @param id ւ镐@i-1 Ŏ̕j
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
void human::ChangeWeapon(int id)
{
	//̗͂ȂΎs
	if( hp <= 0 ){ return; }

	//[hȂ玸s
	if( weapon[selectweapon] != NULL ){
		if( weapon[selectweapon]->GetReloadCnt() > 0 ){ return; }
	}

	//ɐ؂ւ悤ƂĂȂAs
	if( selectweapon == id ){ return; }

	//؂ւȂ玸s
	if( selectweaponcnt > 0 ){ return; }

	if( id == -1 ){
		//̕ԍI
		selectweapon += 1;
		if( selectweapon == TOTAL_HAVEWEAPON ){
			selectweapon = 0;
		}
	}
	else{
		//ԍ͈͓mF
		if( (id < 0)||((TOTAL_HAVEWEAPON -1) < id ) ){ return; }
		selectweapon = id;
	}

	//XR[v\
	SetDisableScope();

	//r̊pxijݒ
	reaction_y = (float)M_PI/18*2 * -1;

	//؂ւ̃JEg
	selectweaponcnt = 10;
}

//! @brief ̐؂ւJEg擾
//! @return JEg@i1ȏŐ؂ւj
int human::GetChangeWeaponCnt()
{
	return selectweaponcnt;
}

//! @brief 擾
//! @param out_selectweapon IĂ镐@i0 ` [TOTAL_HAVEWEAPON]-1j
//! @param out_weapon 󂯎weaponNX̃|C^z@iz񐔁FTOTAL_HAVEWEAPONj
void human::GetWeapon(int *out_selectweapon, class weapon *out_weapon[])
{
	*out_selectweapon = selectweapon;
	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		out_weapon[i] = weapon[i];
	}
}

//! @brief ݑĂ镐̎ޔԍ擾
//! @return ̎ޔԍi0 ` TOTAL_PARAMETERINFO_WEAPON -1j
//! @attention ݎɎĂ镐̎ޔԍłB@GetWeapon()֐ pĒׂ̂ƓłB
int human::GetMainWeaponTypeNO()
{
	if( weapon[selectweapon] == NULL ){
		return ID_WEAPON_NONE;
	}

	int id_param;
	weapon[selectweapon]->GetParamData(&id_param, NULL, NULL);
	return id_param;
}

//! @brief Aːݒ擾
//! @return Aˉ\Ftrue@A˕sFfalse
bool human::GetWeaponBlazingmode()
{
	int param_id;
	WeaponParameter data;

	//𑕔ĂȂ΁As
	if( weapon[selectweapon] == NULL ){ return false; }

	//Ă镐̎ޔԍ擾
	weapon[selectweapon]->GetParamData(&param_id, NULL, NULL);

	//AːݒԂ
	Param->GetWeapon(param_id, &data);
	return data.blazingmode;
}

//! @brief C
//! @param weapon_paramid C̔ԍ󂯎|C^
//! @param GunsightErrorRange Cۂ̏Ə덷󂯎|C^
//! @return F1@sF0
//! @attention eIuWFNg̏AC̍Đ͕ʓrsKv܂B
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
bool human::ShotWeapon(int *weapon_paramid, int *GunsightErrorRange)
{
	int param_id;

	//؂ւȂ玸s
	if( selectweaponcnt > 0 ){ return false; }

	//𑕔ĂȂ΁As
	if( weapon[selectweapon] == NULL ){ return false; }

	//e̔ˏs
	if( weapon[selectweapon]->Shot() != 0 ){ return false; }

	//̎ޔԍ擾
	weapon[selectweapon]->GetParamData(&param_id, NULL, NULL);


	//̐ݒl擾
	WeaponParameter ParamData;
	if( Param->GetWeapon(param_id, &ParamData) != 0 ){ return false; }

	//XR[v̕ŃXR[v`ĂȂ΁A덷 20B
	if( (scopemode == 0)&&(ParamData.scopemode == 2) ){
		ReactionGunsightErrorRange = 20;
	}


	//̎ޔԍƌ덷Ԃ
	*weapon_paramid = param_id;
	*GunsightErrorRange = StateGunsightErrorRange + ReactionGunsightErrorRange;


	//XR[vȊO̕AXR[vg킸ɎgĂAݒ肳ꂽ덷ZB
	if( (ParamData.scopemode != 2)&&(scopemode == 0) ){
		ReactionGunsightErrorRange += ParamData.reaction;
	}

	//XR[vgpĂԂ̔Z
	if( (ParamData.scopemode == 1)&&(scopemode != 0) ){
		armrotation_y += (float)M_PI/180 * (WEAPONERRORRANGE_SCALE * ParamData.reaction);
	}
	if( ParamData.scopemode == 2 ){
		armrotation_y += (float)M_PI/180 * (WEAPONERRORRANGE_SCALE * ParamData.reaction);
	}

	//rɔ`
	if( param_id == ID_WEAPON_GRENADE ){
		reaction_y = (float)M_PI/18*2;
	}
	else{
		reaction_y = (float)M_PI/360 * ParamData.reaction;
	}

	//킪ȂĂ΁AOɁB@i֒epj
	if( weapon[selectweapon]->GetDrawFlag() == false ){
		weapon[selectweapon] = NULL;
	}
	return true;
}

//! @brief [h
//! @return Ftrue@sFfalse
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
bool human::ReloadWeapon()
{
	//؂ւȂ玸s
	if( selectweaponcnt > 0 ){ return false; }

	//̕𑕔Ă΁`
	if( weapon[selectweapon] != NULL ){
		//[hȂ玸s
		if( weapon[selectweapon]->GetReloadCnt() > 0 ){ return false; }

		//[hJn
		if( weapon[selectweapon]->StartReload() != 0 ){ return false; }

		//XR[v[h
		SetDisableScope();
		return true;
	}
	return false;
}

//! @brief ̂Ă
//! @return Ftrue@sFfalse
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
bool human::DumpWeapon()
{
	//؂ւȂ玸s
	if( selectweaponcnt > 0 ){ return false; }

	//̕𑕔Ă΁`
	if( weapon[selectweapon] != NULL ){
		//[hȂ玸s
		if( weapon[selectweapon]->GetReloadCnt() > 0 ){ return false; }

		//̂āA
		weapon[selectweapon]->Dropoff(pos_x, pos_y, pos_z, rotation_x, 1.63f);
		weapon[selectweapon] = NULL;

		//XR[v[h
		SetDisableScope();

		return true;
	}

	return false;
}

//! @brief ̃Vbg[h؂ւ
//! @return F0@sF1
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
int human::ChangeShotMode()
{
	//𑕔ĂȂΎs
	if( weapon[selectweapon] == NULL ){ return 1; }

	//Ă镐̏擾
	int param_id, lnbs, nbs;
	weapon[selectweapon]->GetParamData(&param_id, &lnbs, &nbs);

	//̃Vbg[h؂ւiVԍj𒲂ׂ
	WeaponParameter ParamData;
	int ChangeWeapon;
	if( Param->GetWeapon(param_id, &ParamData) != 0 ){ return 1; }
	ChangeWeapon = ParamData.ChangeWeapon;

	//VԍmF
	if( ChangeWeapon == param_id ){ return 1; }
	if( (ChangeWeapon < 0)||(TOTAL_PARAMETERINFO_WEAPON-1 < ChangeWeapon) ){ return 1; }

	//ݒKp
	weapon[selectweapon]->SetParamData(ChangeWeapon, lnbs, nbs, false);
	return 0;
}

//! @brief Oiijݒ
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
void human::SetMoveForward()
{
	SetFlag(MoveFlag, MOVEFLAG_FORWARD);
}

//! @brief ނݒ
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
void human::SetMoveBack()
{
	SetFlag(MoveFlag, MOVEFLAG_BACK);
}

//! @brief ݒ
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
void human::SetMoveLeft()
{
	SetFlag(MoveFlag, MOVEFLAG_LEFT);
}

//! @brief Eݒ
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
void human::SetMoveRight()
{
	SetFlag(MoveFlag, MOVEFLAG_RIGHT);
}

//! @brief ݒ
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
void human::SetMoveWalk()
{
	SetFlag(MoveFlag, MOVEFLAG_WALK);
}

//! @brief l̈ړ[h擾
//! @param nowdata ݂̒l擾Ftrue@Ot[̒lgpFfalse
//! @return F1@F2@ړĂȂF0
int human::GetMovemode(bool nowdata)
{
	//gpĂȂAĂȂΏI
	if( RenderFlag == false ){ return 0; }
	if( hp <= 0 ){ return 0; }

	if( nowdata == false ){	//Õf[^
		//Ȃ 1
		if( GetFlag(MoveFlag_lt, MOVEFLAG_WALK) ){
			return 1;
		}
		//Ȃ 2
		if( GetFlag(MoveFlag_lt, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) ){
			return 2;
		}
	}
	else{					//݂̃f[^
		//Ȃ 1
		if( GetFlag(MoveFlag, MOVEFLAG_WALK) ){
			return 1;
		}
		//Ȃ 2
		if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) ){
			return 2;
		}
	}

	//ړĂȂ
	return 0;
}

//! @brief XR[vݒ
//! @return Ftrue@sFfalse
bool human::SetEnableScope()
{
	int param_id;
	WeaponParameter data;

	//𑕔ĂȂΎs
	if( weapon[selectweapon] == NULL ){ return false; }

	//̎ޔԍ擾
	weapon[selectweapon]->GetParamData(&param_id, NULL, NULL);

	//̐ݒl擾
	Param->GetWeapon(param_id, &data);

	//XR[vݒ
	scopemode = data.scopemode;
	return true;
}

//! @brief XR[v
void human::SetDisableScope()
{
	scopemode = 0;
}

//! @brief XR[vݒ擾
int human::GetScopeMode()
{
	return scopemode;
}

//! @brief Əč擾
//! @param rx 擾|C^
//! @param ry c擾|C^
void human::GetRxRy(float *rx, float *ry)
{
	*rx = rotation_x;
	*ry = armrotation_y;
}

//! @brief Əčݒ
//! @param rx ݒ肷鉡
//! @param ry ݒ肷c
void human::SetRxRy(float rx, float ry)
{
	rotation_x = rx;
	armrotation_y = ry;
}

//! @brief Wv
//! @return F0@sF1
//! @attention Q[ォ璼ڌĂяoƂ͔AObjectManagerNXĂяoĂB
int human::Jump()
{
	//nʂɐGĂAx0.0Ȃ
	if( move_y_flag == false ){
		if( move_y == 0.0f ){
			move_y = HUMAN_JUMP_SPEED;
			return 0;
		}
	}
	return 1;
}

//! @brief E͂
//! @param rx 
//! @param ry c
//! @param speed x
void human::AddPosOrder(float rx, float ry, float speed)
{
	move_x += cos(rx) * cos(ry) * speed;
	move_y += sin(ry) * speed;
	move_z += sin(rx) * cos(ry) * speed;
}

//! @brief e  Ƀqbg
//! @param attacks e̍U
void human::HitBulletHead(int attacks)
{
	if( Invincible == false ){
		hp -= (int)((float)attacks * HUMAN_DAMAGE_HEAD);
	}
	HitFlag = true;
}

//! @brief e 㔼g Ƀqbg
//! @param attacks e̍U
void human::HitBulletUp(int attacks)
{
	if( Invincible == false ){
		hp -= (int)((float)attacks * HUMAN_DAMAGE_UP);
	}
	HitFlag = true;
}

//! @brief e g Ƀqbg
//! @param attacks e̍U
void human::HitBulletLeg(int attacks)
{
	if( Invincible == false ){
		hp -= (int)((float)attacks * HUMAN_DAMAGE_LEG);
	}
	HitFlag = true;
}

//! @brief ]r̍Uqbg
void human::HitZombieAttack()
{
	if( Invincible == false ){
		hp -= HUMAN_DAMAGE_ZOMBIEU + GetRand(HUMAN_DAMAGE_ZOMBIEA);
	}
	HitFlag = true;
}

//! @brief ֒e̔qbg
//! @param attacks ̍U
//! @attention ɂvZOɍς܂ĂB
void human::HitGrenadeExplosion(int attacks)
{
	if( Invincible == false ){
		hp -= attacks;
	}
	HitFlag = true;
}

//! @brief e`FbN
//! @return eFtrue@eĂȂFfalse
//! @attention sƁAtO false ɏ܂B
bool human::CheckHit()
{
	bool returnflag = HitFlag;
	HitFlag = false;
	return returnflag;
}

//! @brief vړʂ擾
//! @return vړ
float human::GetTotalMove()
{
	return totalmove;
}

//! @brief Ə̏Ԍ덷̏
//!	@attention ControlProcess()Oŏ邱
void human::GunsightErrorRange()
{
	//
	StateGunsightErrorRange = 0;

	//eɂ덷ݒ
	if( GetFlag(MoveFlag, MOVEFLAG_WALK) ){
		StateGunsightErrorRange = 4;
	}
	if( GetFlag(MoveFlag, MOVEFLAG_FORWARD) ){
		StateGunsightErrorRange = 8;
	}
	if( GetFlag(MoveFlag, MOVEFLAG_BACK) ){
		StateGunsightErrorRange = 6;
	}
	if( GetFlag(MoveFlag, (MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) ){
		StateGunsightErrorRange = 7;
	}
	if( move_y_flag == true ){
		StateGunsightErrorRange = 22;
	}
	if( hp < 40 ){
		StateGunsightErrorRange += 3;
	}

	//𑕔Ă
	if( weapon[selectweapon] != NULL ){
		//̐ݒf[^擾
		int param;
		WeaponParameter data;
		weapon[selectweapon]->GetParamData(&param, NULL, NULL);
		Param->GetWeapon(param, &data);

		//덷 1 炷
		ReactionGunsightErrorRange -= 1;

		//덷͈̔͂␳
		if( ReactionGunsightErrorRange < 0 ){ ReactionGunsightErrorRange = 0; }
		if( ReactionGunsightErrorRange > data.ErrorRangeMAX ){ ReactionGunsightErrorRange = data.ErrorRangeMAX; }
	}
	else{
		ReactionGunsightErrorRange = 0;
	}
}

//! @brief SƓ|鏈
//! @return |IF3@|ĂŒF2@|n߂F1@ȂF0
int human::CheckAndProcessDead(class Collision *CollD)
{
#ifdef HUMAN_DEADBODY_COLLISION
	float add_ry = 0.0f;
	float check_posx, check_posy, check_posz;

	if( deadstate == 0 ){
		if( hp <= 0 ){		//HP 0 ȉɂȂiSjuԂȂA|n߂
			//̂̊pxEr̊px
			switch( GetRand(4) ){
				case 0:
					add_ry = (float)M_PI/180*6;
					armrotation_y = (float)M_PI/2;
					break;
				case 1:
					add_ry = (float)M_PI/180*6 * -1;
					armrotation_y = (float)M_PI/2;
					break;
				case 2:
					add_ry = (float)M_PI/180*6;
					armrotation_y = (float)M_PI/2 * -1;
					break;
				case 3:
					add_ry = (float)M_PI/180*6 * -1;
					armrotation_y = (float)M_PI/2 * -1;
					break;
			}

			//̂܂ʂ悤A +1.0 
			pos_y += 1.0f;

			//Ă镐SĎ̂Ă
			for(int i=0; i<TOTAL_HAVEWEAPON; i++){
				if( weapon[i] != NULL ){
					weapon[i]->Dropoff(pos_x, pos_y, pos_z, (float)M_PI/18*GetRand(36), 1.5f);
					weapon[i] = NULL;
				}
			}

			//XR[v[h
			SetDisableScope();

			//̃t[̓̍W擾
			check_posx = pos_x + cos(rotation_x*-1 - (float)M_PI/2) * sin(add_ry) * HUMAN_HEIGTH;
			check_posy = pos_y + cos(add_ry) * HUMAN_HEIGTH;
			check_posz = pos_z + sin(rotation_x*-1 - (float)M_PI/2) * sin(add_ry) * HUMAN_HEIGTH;

			if( CollD->CheckALLBlockInside(check_posx, check_posy, check_posz) == true ){
				deadstate = 2;
			}
			else{
				rotation_y += add_ry;
				deadstate = 1;
			}
			return 1;
		}
		return 0;
	}

	if( deadstate == 1 ){
		//135xȏ|Ă
		if( abs(rotation_y) >= (float)M_PI/4*3 ){
			deadstate = 2;
			return 2;
		}

		if( pos_y <= (HUMAN_DEADLINE + 10.0f) ){
			//90xȏ|Ă
			if( abs(rotation_y) >= (float)M_PI/2 ){
				deadstate = 4;
				return 2;
			}
		}

		//Oɓ|
		if( rotation_y > 0.0f ){		//rotation_y < (float)M_PI/4*3
			add_ry = (float)M_PI/180*6;
		}
		else if( rotation_y < 0.0f ){	//rotation_y > (float)M_PI/4*3 * -1
			add_ry = (float)M_PI/180*6 * -1;
		}

		if( pos_y <= HUMAN_DEADLINE ){
			rotation_y += add_ry;
		}
		else{
			//̃t[̓̍W擾
			check_posx = pos_x + cos(rotation_x*-1 - (float)M_PI/2) * sin(rotation_y + add_ry) * HUMAN_HEIGTH;
			check_posy = pos_y + cos(rotation_y + add_ry) * HUMAN_HEIGTH;
			check_posz = pos_z + sin(rotation_x*-1 - (float)M_PI/2) * sin(rotation_y + add_ry) * HUMAN_HEIGTH;

			if( CollD->CheckALLBlockInside(check_posx, check_posy, check_posz) == true ){
				deadstate = 3;
			}
			else{
				rotation_y += add_ry;
			}
		}

		return 2;
	}

	if( deadstate == 2 ){
		if( pos_y <= HUMAN_DEADLINE ){
			deadstate = 4;
			return 2;
		}

		//̃t[̑̍W
		check_posx = pos_x;
		check_posy = pos_y - 0.5f;
		check_posz = pos_z;

		if( CollD->CheckALLBlockInside(check_posx, check_posy, check_posz) == true ){
			deadstate = 4;
		}
		else{
			pos_y -= 0.5f;
		}

		return 2;
	}

	if( deadstate == 3 ){
		//deadstate = 4;

		//90xȏ|Ă
		if( abs(rotation_y) >= (float)M_PI/2 ){
			deadstate = 4;
			return 2;
		}

		//Oɓ|
		if( rotation_y > 0.0f ){		//rotation_y < (float)M_PI/2
			add_ry = (float)M_PI/180*6;
		}
		else if( rotation_y < 0.0f ){	//rotation_y > (float)M_PI/2 * -1
			add_ry = (float)M_PI/180*6 * -1;
		}

		//̃t[̑̍W擾
		check_posx = pos_x - cos(rotation_x*-1 - (float)M_PI/2) * sin(rotation_y + add_ry) * HUMAN_HEIGTH;
		check_posy = pos_y + 0.1f;
		check_posz = pos_z - sin(rotation_x*-1 - (float)M_PI/2) * sin(rotation_y + add_ry) * HUMAN_HEIGTH;

		if( CollD->CheckALLBlockInside(check_posx, check_posy, check_posz) == true ){
			deadstate = 4;
			return 2;
		}

		//̃t[̓̍W擾
		check_posx = pos_x - cos(rotation_x*-1 - (float)M_PI/2) * sin(rotation_y + add_ry) * HUMAN_HEIGTH;
		check_posy = pos_y + cos(rotation_y + add_ry) * HUMAN_HEIGTH;
		check_posz = pos_z - sin(rotation_x*-1 - (float)M_PI/2) * sin(rotation_y + add_ry) * HUMAN_HEIGTH;

		if( CollD->CheckALLBlockInside(check_posx, check_posy, check_posz) == true ){
			deadstate = 4;
			return 2;
		}

		//̍Wړ
		pos_x -= cos(rotation_x*-1 - (float)M_PI/2) * sin(add_ry) * HUMAN_HEIGTH;
		pos_z -= sin(rotation_x*-1 - (float)M_PI/2) * sin(add_ry) * HUMAN_HEIGTH;

		rotation_y += add_ry;
		return 2;
	}

	if( deadstate == 4 ){
		//ȂiŒj
		return 3;
	}

	return 0;
#else
	if( rotation_y > 0.0f ){		//|n߂Ă΁Â܂ܓ|B
		if( rotation_y < (float)M_PI/2 ){
			rotation_y += (float)M_PI/180*6;
		}
		return 2;
	}
	else if( rotation_y < 0.0f ){	//|n߂Ă΁Â܂ܓ|B
		if( rotation_y > (float)M_PI/2 * -1 ){
			rotation_y -= (float)M_PI/180*6;
		}
		return 2;
	}
	else if( hp <= 0 ){		//HP 0 ȉɂȂiSjuԂȂA|n߂
		//̂̊pxEr̊px
		switch( GetRand(4) ){
			case 0:
				rotation_y = (float)M_PI/180*6;
				armrotation_y = (float)M_PI/2;
				break;
			case 1:
				rotation_y = (float)M_PI/180*6 * -1;
				armrotation_y = (float)M_PI/2;
				break;
			case 2:
				rotation_y = (float)M_PI/180*6;
				armrotation_y = (float)M_PI/2 * -1;
				break;
			case 3:
				rotation_y = (float)M_PI/180*6 * -1;
				armrotation_y = (float)M_PI/2 * -1;
				break;
		}

		//̂܂ʂ悤A +1.0 
		pos_y += 1.0f;

		//Ă镐SĎ̂Ă
		for(int i=0; i<TOTAL_HAVEWEAPON; i++){
			if( weapon[i] != NULL ){
				weapon[i]->Dropoff(pos_x, pos_y, pos_z, (float)M_PI/18*GetRand(36), 1.5f);
				weapon[i] = NULL;
			}
		}

		//XR[v[h
		SetDisableScope();

		return 1;
	}

	return 0;
#endif
}

//! @brief ɂړvZ
//! @attention sƁAeL[tO false ɏ܂B
void human::ControlProcess()
{
	//isƑx
	if( GetFlag(MoveFlag, MOVEFLAG_WALK) ){
		move_rx = 0.0f;
		AddPosOrder(rotation_x*-1 + move_rx + (float)M_PI/2, 0.0f, HUMAN_PROGRESSWALK_ACCELERATION);
		walkcnt += 1;
		runcnt = 0;
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == MOVEFLAG_FORWARD ){
		move_rx = 0.0f;
		AddPosOrder(rotation_x*-1 + move_rx + (float)M_PI/2, 0.0f, HUMAN_PROGRESSRUN_ACCELERATION);
		walkcnt = 0;
		runcnt += 1;
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == MOVEFLAG_BACK ){
		move_rx = (float)M_PI;
		AddPosOrder(rotation_x*-1 + move_rx + (float)M_PI/2, 0.0f, HUMAN_REGRESSRUN_ACCELERATION);
		walkcnt = 0;
		runcnt += 1;
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == MOVEFLAG_LEFT ){
		move_rx = (float)M_PI/2;
		AddPosOrder(rotation_x*-1 + move_rx + (float)M_PI/2, 0.0f, HUMAN_SIDEWAYSRUN_ACCELERATION);
		walkcnt = 0;
		runcnt += 1;
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == MOVEFLAG_RIGHT ){
		move_rx = (float)M_PI/2 * -1;
		AddPosOrder(rotation_x*-1 + move_rx + (float)M_PI/2, 0.0f, HUMAN_SIDEWAYSRUN_ACCELERATION);
		walkcnt = 0;
		runcnt += 1;
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == (MOVEFLAG_FORWARD | MOVEFLAG_LEFT) ){
		move_rx = (float)M_PI/4;
		AddPosOrder(rotation_x*-1 + move_rx + (float)M_PI/2, 0.0f, HUMAN_PROGRESSRUN_SIDEWAYSRUN_ACCELERATION);
		walkcnt = 0;
		runcnt += 1;
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == (MOVEFLAG_BACK | MOVEFLAG_LEFT) ){
		move_rx = (float)M_PI/4*3;
		AddPosOrder(rotation_x*-1 + move_rx + (float)M_PI/2, 0.0f, HUMAN_REGRESSRUN_SIDEWAYSRUN_ACCELERATION);
		walkcnt = 0;
		runcnt += 1;
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == (MOVEFLAG_BACK | MOVEFLAG_RIGHT) ){
		move_rx = (float)M_PI/4*3 * -1;
		AddPosOrder(rotation_x*-1 + move_rx + (float)M_PI/2, 0.0f, HUMAN_REGRESSRUN_SIDEWAYSRUN_ACCELERATION);
		walkcnt = 0;
		runcnt += 1;
	}
	else if( GetFlag(MoveFlag, (MOVEFLAG_FORWARD | MOVEFLAG_BACK | MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) == (MOVEFLAG_FORWARD | MOVEFLAG_RIGHT) ){
		move_rx = (float)M_PI/4 * -1;
		AddPosOrder(rotation_x*-1 + move_rx + (float)M_PI/2, 0.0f, HUMAN_PROGRESSRUN_SIDEWAYSRUN_ACCELERATION);
		walkcnt = 0;
		runcnt += 1;
	}
	else{
		move_rx = 0.0f;
		walkcnt = 0;
		runcnt = 0;
	}

	//tOobNAbv
	MoveFlag_lt = MoveFlag;

	//L[tOɖ߂
	MoveFlag = 0x00;
}

//! @brief ̕ixNgjɑ΂āAubN̖ʂ\ʂʂׂ
//! @param inblockdata BlockDataInterfaceNX̃|C^
//! @param bid 肷ubNԍ
//! @param fid 肷ʔԍ
//! @param vx XxNg̃|C^
//! @param vz ZxNg̃|C^
//! @return \Ftrue@Ffalse
bool human::CheckBlockAngle(class BlockDataInterface *inblockdata, int bid, int fid, float vx, float vz)
{
	if( inblockdata == NULL ){ return false; }
	if( (bid < 0)||(inblockdata->GetTotaldatas() <= bid) ){ return false; }

	float costheta;
	struct blockdata bdata;

	inblockdata->Getdata(&bdata, bid);
	costheta = (vx * bdata.material[fid].vx + vz * bdata.material[fid].vz) / (sqrt(vx * vx + vz * vz) * sqrt(bdata.material[fid].vx * bdata.material[fid].vx + bdata.material[fid].vz * bdata.material[fid].vz));
	if( acos(costheta) > (float)M_PI/2 ){
		return true;
	}
	return false;
}

//! @brief }bvƂ̓蔻
//! @param CollD CollisionNX̃|C^
//! @param inblockdata BlockDataInterfaceNX̃|C^
//! @param FallDist Ÿړʂ擾|C^
//! @return ubNɖ܂ĂFtrue@܂ĂȂFfalse
bool human::MapCollisionDetection(class Collision *CollD, class BlockDataInterface *inblockdata, float *FallDist)
{
	bool inside = false;
	int id;
	int face;
	float vx, vz;
	float vy = 0.1f;
	float speed;
	float Dist;
	float FallDistance;
	float offset;

	//MM͓蔻肩珜O
	offset = 0.1f;

	//@㉺̂蔻iWvERj
	//--------------------------------------------------

	//ubNɖ܂ĂȂ
	if( CollD->CheckALLBlockInside(pos_x, pos_y + offset, pos_z) == false ){
		//xvZ
		move_y -= HUMAN_DAMAGE_SPEED;
		if( move_y < HUMAN_DAMAGE_MAXSPEED ){ move_y = HUMAN_DAMAGE_MAXSPEED; }

		if( move_y > 0.0f ){
			//֓蔻
			if( CollD->CheckALLBlockIntersectDummyRay(pos_x, pos_y + HUMAN_HEIGTH, pos_z, 0, 1, 0, NULL, NULL, &Dist, move_y) == true ){
				CollD->CheckALLBlockIntersectRay(pos_x, pos_y + HUMAN_HEIGTH, pos_z, 0, 1, 0, NULL, NULL, &Dist, move_y);

				FallDistance = Dist;
				move_y = 0.0f;
			}
			else{
				FallDistance = move_y;
			}
			FallDistance = move_y;
			move_y_flag = true;
		}
		else{
			 int id, face;
			 struct blockdata bdata;

			//֓蔻
			if( CollD->CheckALLBlockIntersectDummyRay(pos_x, pos_y + offset, pos_z, 0, -1, 0, NULL, NULL, &Dist, move_y*-1 + offset) == true ){
				CollD->CheckALLBlockIntersectRay(pos_x, pos_y + offset, pos_z, 0, -1, 0, &id, &face, &Dist, move_y + offset);

				if( Invincible == false ){
					//_[WvZ
					if( move_y > HUMAN_DAMAGE_MINSPEED ){ hp -= 0; }
					else{ hp -= (int)((float)HUMAN_DAMAGE_MAXFALL / abs(HUMAN_DAMAGE_MAXSPEED - (HUMAN_DAMAGE_MINSPEED)) * abs(move_y - (HUMAN_DAMAGE_MINSPEED))); }
				}

				FallDistance = (Dist - offset) * -1;
				move_y = 0.0f;
				
				inblockdata->Getdata(&bdata, id);

				//ΖʂɗĂȂ
				if( acos(bdata.material[face].vy) > HUMAN_MAPCOLLISION_SLOPEANGLE ){
					//nʂƔF߂Ȃ@iWv΍j
					move_y_flag = true;

					//o
					move_x += bdata.material[face].vx * HUMAN_MAPCOLLISION_SLOPEFORCE;
					move_z += bdata.material[face].vz * HUMAN_MAPCOLLISION_SLOPEFORCE;
				}
				else{
					move_y_flag = false;
				}
			}
			else{
				FallDistance = move_y;
				move_y_flag = true;
			}
		}
	}
	else{	//܂Ă
		FallDistance = move_y;
		move_y = 0.0f;
		move_y_flag = false;
	}


	//@̂蔻iړj
	//--------------------------------------------------

	if( (move_x*move_x + move_z*move_z) ){
		int surface;
		float ang = atan2(move_z, move_x);
		float newpos_x, newpos_y, newpos_z;

		//t߂𓖂蔻
		for(int i=0; i<MAX_BLOCKS; i++){
			surface = -1;
			CollD->CheckBlockInside(i, pos_x, pos_y + HUMAN_MAPCOLLISION_HEIGTH, pos_z, false, &surface);

			if( surface != -1 ){
				//HUMAN_MAPCOLLISION_R ̐𒲂ׂ
				if( CollD->CheckBlockInside(i, pos_x + cos(ang)*HUMAN_MAPCOLLISION_R, pos_y + HUMAN_MAPCOLLISION_HEIGTH, pos_z + sin(ang)*HUMAN_MAPCOLLISION_R, true, NULL) == true ){
					CollD->ScratchVector(inblockdata, i, surface, move_x, vy, move_z, &move_x, &vy, &move_z);
				}

				//E90xÂ𒲂ׂ
				if( CollD->CheckBlockInside(i, pos_x + cos(ang + (float)M_PI/2)*HUMAN_MAPCOLLISION_R, pos_y + HUMAN_MAPCOLLISION_HEIGTH, pos_z + sin(ang + (float)M_PI/2)*HUMAN_MAPCOLLISION_R, true, NULL) == true ){
					if( CheckBlockAngle(inblockdata, i, surface, cos(ang), sin(ang)) == true ){		//isɑ΂ĕ\Ȃ`
						CollD->ScratchVector(inblockdata, i, surface, move_x, vy, move_z, &move_x, &vy, &move_z);
					}
				}
				if( CollD->CheckBlockInside(i, pos_x + cos(ang - (float)M_PI/2)*HUMAN_MAPCOLLISION_R, pos_y + HUMAN_MAPCOLLISION_HEIGTH, pos_z + sin(ang - (float)M_PI/2)*HUMAN_MAPCOLLISION_R, true, NULL) == true ){
					if( CheckBlockAngle(inblockdata, i, surface, cos(ang), sin(ang)) == true ){		//isɑ΂ĕ\Ȃ`
						CollD->ScratchVector(inblockdata, i, surface, move_x, vy, move_z, &move_x, &vy, &move_z);
					}
				}
			}
		}

		//isxNgZo
		vx = move_x;
		vz = move_z;
		speed = sqrt(vx*vx + vz*vz);
		if( speed > 0.0f ){
			vx = vx / speed;
			vz = vz / speed;
		}

		//𓖂蔻
		if( CollD->CheckALLBlockIntersectDummyRay(pos_x, pos_y + HUMAN_HEIGTH, pos_z, vx, 0, vz, NULL, NULL, &Dist, speed) == true ){
			CollD->CheckALLBlockIntersectRay(pos_x, pos_y + FallDistance + HUMAN_HEIGTH, pos_z, vx, 0, vz, &id, &face, &Dist, speed);
			CollD->ScratchVector(inblockdata, id, face, move_x, vy, move_z, &move_x, &vy, &move_z);
		}

		//ubNɖ܂ĂȂ
		if( CollD->CheckALLBlockInside(pos_x, pos_y + offset, pos_z) == false ){

			//isxNgZo
			vx = move_x;
			vz = move_z;
			speed = sqrt(vx*vx + vz*vz);
			if( speed > 0.0f ){
				vx = vx / speed;
				vz = vz / speed;
			}

			//𓖂蔻
			if( CollD->CheckALLBlockIntersectDummyRay(pos_x, pos_y + offset, pos_z, vx, 0, vz, NULL, NULL, &Dist, speed) == true ){
				CollD->CheckALLBlockIntersectRay(pos_x, pos_y + offset, pos_z, vx, 0, vz, &id, &face, &Dist, speed);

				//nʂƔF߂Ȃ@iWv΍j
				move_y_flag = true;

				struct blockdata bdata;
				inblockdata->Getdata(&bdata, id);

				if( acos(bdata.material[face].vy) > HUMAN_MAPCOLLISION_SLOPEANGLE ){	//Ζʁ`ǂȂ
					//z鍂ׂ
					if( CollD->CheckALLBlockIntersectDummyRay(pos_x, pos_y + 3.5f + offset, pos_z, vx, 0, vz, NULL, NULL, &Dist, speed) == false ){
						//lɎグ
						FallDistance = 0.4f;
						move_y = 0.0f;
					}

					//𓖂蔻
					CollD->ScratchVector(inblockdata, id, face, move_x, vy, move_z, &move_x, &vy, &move_z);
				}
				else{																	//`ΖʂȂ
					//ړ̈ʒuvZ
					newpos_x = pos_x + move_x;
					newpos_y = pos_y + FallDistance;
					newpos_z = pos_z + move_z;

					//ړ̍𒲂ׂ
					if( CollD->CheckALLBlockInside(newpos_x, newpos_y + HUMAN_HEIGTH, newpos_z) == false ){
						if( CollD->CheckALLBlockIntersectRay(newpos_x, newpos_y + HUMAN_HEIGTH, newpos_z, 0, -1, 0, NULL, NULL, &Dist, HUMAN_HEIGTH) == true ){
							float height = HUMAN_HEIGTH - Dist;

							if( height > 0.6f * speed ){
								//lɎグ
								FallDistance = 0.4f;
								move_y = 0.0f;
							}
							else{
								FallDistance = height;
								move_y = 0.0f;
							}
						}
					}
				}
			}
		}

		//ړ̈ʒuvZ
		newpos_x = pos_x + move_x;
		newpos_y = pos_y + FallDistance;
		newpos_z = pos_z + move_z;

		//Sg߂ĊmF
		if(
			(CollD->CheckALLBlockInside(newpos_x, newpos_y + offset, newpos_z) == true)||
			(CollD->CheckALLBlockIntersectRay(newpos_x, newpos_y + offset, newpos_z, 0, 1, 0, NULL, NULL, &Dist, HUMAN_HEIGTH - offset - 1.0f) == true)
		){
			//߂荞ނȂړȂ
			move_x = 0.0f;
			move_z = 0.0f;
			inside = true;
		}
	}

	*FallDist = FallDistance;
	return inside;
}

//! @brief vZsi蔻j
//! @param CollD Collisioñ|C^
//! @param inblockdata BlockDataInterfacẽ|C^
//! @param F5mode ㏸@\iF5Zj̃tO@iLFtrue@Ffalsej
int human::RunFrame(class Collision *CollD, class BlockDataInterface *inblockdata, bool F5mode)
{
	if( CollD == NULL ){ return 0; }
	if( RenderFlag == false ){ return 0; }

#ifdef HUMAN_DEADBODY_COLLISION
	if( deadstate == 4 ){ return 0; }
#else
	if( hp <= 0 ){ return 0; }
#endif

	float FallDistance;

	//؂ւJEg
	if( selectweaponcnt > 0 ){
		selectweaponcnt -= 1;
	}

	//Cɂ锽
	if( reaction_y > 0.0f ){
		if( reaction_y > (float)M_PI/180*2 ){ reaction_y -= (float)M_PI/180*2; }
		else{ reaction_y = 0.0f; }
	}
	if( reaction_y < 0.0f ){
		if( reaction_y < (float)M_PI/180*2 ){ reaction_y += (float)M_PI/180*2; }
		else{ reaction_y = 0.0f; }
	}

	//[hȂr̊pxĐݒ
	if( weapon[selectweapon] != NULL ){
		if( weapon[selectweapon]->GetReloadCnt() > 0 ){
			reaction_y = ARMRAD_RELOADWEAPON;
		}
	}

	//̊pxA-90x`90x͈̔͂ɐݒ
	if( hp <= 0 ){
		legrotation_x = 0.0f;
	}
	else{
		float add_legrx;

		//ڕWlݒ
		if( fabs(move_rx) > (float)M_PI/2 ){
			add_legrx = move_rx + (float)M_PI - legrotation_x;
		}
		else{
			add_legrx = move_rx - legrotation_x;
		}
		for(; add_legrx > (float)M_PI; add_legrx -= (float)M_PI*2){}
		for(; add_legrx < (float)M_PI*-1; add_legrx += (float)M_PI*2){}

		//␳Ă
		if( add_legrx > (float)M_PI/18 ){ legrotation_x += (float)M_PI/18; }
		else if( add_legrx < (float)M_PI/18*-1 ){ legrotation_x -= (float)M_PI/18; }
		else{ legrotation_x += add_legrx; }
	}

	//Ə̏Ԍ덷̏
	GunsightErrorRange();

	//SƓ|鏈
	if( CheckAndProcessDead(CollD) != 0 ){ return 0; }

	//isƑx
	ControlProcess();

	//}bvƂ̓蔻
	MapCollisionDetection(CollD, inblockdata, &FallDistance);

	//ړȂ
	if( (move_x*move_x + move_z*move_z) > 0.0f * 0.0f ){
		totalmove += sqrt(move_x*move_x + move_z*move_z);
	}

	//Wړ
	pos_x += move_x;
	pos_z += move_z;

	//ړʂ
	move_x *= HUMAN_ATTENUATION;
	move_z *= HUMAN_ATTENUATION;

	//F5gpĂȂ΁AvZʂ𔽉f
	if( F5mode == false ){
		pos_y += FallDistance;
	}
	else{
		move_y = 0.0f;
		pos_y += 5.0f;	//gpĂ΁AIɏ㏸
	}


	//-100.0艺ɗAS
	if( pos_y < HUMAN_DEADLINE ){
		pos_y = HUMAN_DEADLINE;
		hp = 0;
	}

	return 0;
}

//! @brief W덷擾
int human::GetGunsightErrorRange()
{
	return StateGunsightErrorRange + ReactionGunsightErrorRange;
}

//! @brief `
//! @param d3dg D3DGraphics̃|C^
//! @param Resource ResourceManager̃|C^
//! @param DrawArm rƕ̂ݕ`悷
//! @param player Ώۂ̐lvC[ǂ
//! @todo r̈ʒusŋ߂
//! @todo ̂̕ʂ̍iYj
void human::Render(class D3DGraphics *d3dg, class ResourceManager *Resource, bool DrawArm, bool player)
{
	//ĂȂ΁AȂ
	if( d3dg == NULL ){ return; }
	if( RenderFlag == false ){ return; }

	//ݑ镐̃NX擾
	class weapon *nowweapon;
	nowweapon = weapon[selectweapon];

	if( DrawArm == false ){
		int legmodelid;

		//㔼g`
		d3dg->SetWorldTransform(pos_x, pos_y - 1.0f, pos_z, rotation_x + (float)M_PI, rotation_y, upmodel_size);
		d3dg->RenderModel(id_upmodel, id_texture);

		//̃fݒ
		legmodelid = id_legmodel;	//~܂
		if( GetFlag(MoveFlag_lt, MOVEFLAG_WALK) ){
			legmodelid = id_walkmodel[ (walkcnt/3 % TOTAL_WALKMODE) ];	//
		}
		if( GetFlag(MoveFlag_lt, (MOVEFLAG_LEFT | MOVEFLAG_RIGHT)) ){
			legmodelid = id_runmodel[ (runcnt/3 % TOTAL_RUNMODE) ];		//E
		}
		if( GetFlag(MoveFlag_lt, MOVEFLAG_FORWARD) ){
			legmodelid = id_runmodel[ (runcnt/2 % TOTAL_RUNMODE) ];		//O
		}
		if( GetFlag(MoveFlag_lt, MOVEFLAG_BACK) ){
			legmodelid = id_runmodel[ (runcnt/4 % TOTAL_RUNMODE) ];		//둖
		}

		//`
		d3dg->SetWorldTransform(pos_x, pos_y, pos_z, rotation_x + (float)M_PI + legrotation_x*-1, rotation_y, legmodel_size);
		d3dg->RenderModel(legmodelid, id_texture);
	}

	//r`
	if( rotation_y != 0.0f ){		//Sē|Ă or |n߂
		float x = pos_x + cos(rotation_x*-1 - (float)M_PI/2)*sin(rotation_y)*16.0f;
		float y = pos_y + cos(rotation_y)*16.0f;
		float z = pos_z + sin(rotation_x*-1 - (float)M_PI/2)*sin(rotation_y)*16.0f;
		d3dg->SetWorldTransform(x, y, z, rotation_x + (float)M_PI, armrotation_y + rotation_y, armmodel_size);
		d3dg->RenderModel(id_armmodel[0], id_texture);
	}
	else if( nowweapon == NULL ){	//Ԃ
		float ry;
		if( player == true ){
			ry = ARMRAD_NOWEAPON;
		}
		else{
			ry = armrotation_y;
		}
		d3dg->SetWorldTransform(pos_x, pos_y + 16.0f, pos_z, rotation_x + (float)M_PI, ry, armmodel_size);
		d3dg->RenderModel(id_armmodel[0], id_texture);
	}
	else{							//Ă
		//̃fƃeNX`擾
		int id_param;
		int armmodelid = 0;
		WeaponParameter paramdata;
		int model, texture;
		float ry = 0.0f;
		nowweapon->GetParamData(&id_param, NULL, NULL);
		Param->GetWeapon(id_param, &paramdata);
		Resource->GetWeaponModelTexture(id_param, &model, &texture);

		//ř`Ɗpx
		if( paramdata.WeaponP == 0 ){
			armmodelid = 1;
			ry = armrotation_y + reaction_y;
		}
		if( paramdata.WeaponP == 1 ){
			armmodelid = 2;
			ry = armrotation_y + reaction_y;
		}
		if( paramdata.WeaponP == 2 ){
			armmodelid = 0;
			ry = ARMRAD_NOWEAPON;
		}

		//r`
		d3dg->SetWorldTransform(pos_x, pos_y + 16.0f, pos_z, rotation_x + (float)M_PI, ry, armmodel_size);
		d3dg->RenderModel(id_armmodel[armmodelid], id_texture);

		//`
		d3dg->SetWorldTransformHumanWeapon(pos_x, pos_y + 16.0f, pos_z, paramdata.mx/10*-1, paramdata.my/10, paramdata.mz/10*-1, rotation_x + (float)M_PI, ry, paramdata.size);
		d3dg->RenderModel(model, texture);
	}
}

//! @brief RXgN^
weapon::weapon(class ParameterInfo *in_Param, float x, float y, float z, float rx, int id_param, int nbs, bool flag)
{
	Param = in_Param;
	pos_x = x;
	pos_y = y;
	pos_z = z;
	move_x = 0.0f;
	move_y = 0.0f;
	move_z = 0.0f;
	rotation_x = rx;
	RenderFlag = flag;

	id_parameter = id_param;
	usingflag = false;
	bullets = nbs;
	Loadbullets = 0;
	shotcnt = 0;
	motionflag = true;

	if( Param != NULL ){
		WeaponParameter ParamData;
		if( Param->GetWeapon(id_param, &ParamData) == 0 ){
			model_size = ParamData.size;
			//id_model = ParamData.id_model;
			//id_texture = ParamData.id_texture;
		}
	}
	id_model = -1;
	id_texture = -1;
}

//! @brief fBXgN^
weapon::~weapon()
{}

//! @brief WƊpxݒ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param rx ]
void weapon::SetPosData(float x, float y, float z, float rx)
{
	pos_x = x;
	pos_y = y;
	pos_z = z;
	move_x = 0.0f;
	move_y = 0.0f;
	move_z = 0.0f;
	rotation_x = rx;
}

//! @brief ݒlݒ
//! @param id_param ̎ޔԍ
//! @param lnbs e
//! @param nbs ve
//! @param init IuWFNg
void weapon::SetParamData(int id_param, int lnbs, int nbs, bool init)
{
	id_parameter = id_param;
	usingflag = false;
	bullets = nbs;
	Loadbullets = lnbs;

	if( init == true ){
		shotcnt = 0;
		reloadcnt = 0;
		motionflag = true;
	}
}

//! @brief ݒl擾
//! @param id_param ̎ޔԍ󂯎|C^iNULLj
//! @param lnbs e󂯎|C^iNULLj
//! @param nbs ve󂯎|C^iNULLj
void weapon::GetParamData(int *id_param, int *lnbs, int *nbs)
{
	if( id_param != NULL ){ *id_param = id_parameter; }
	if( lnbs != NULL ){ *lnbs = Loadbullets; }
	if( nbs != NULL ){ *nbs = bullets; }
}

//! @brief ̎gp󋵂̎擾
//! @return gpFtrue@gpFfalse
bool weapon::GetUsingFlag()
{
	return usingflag;
}

//! @brief E
//! @return F0@sF1
int weapon::Pickup()
{
	if( usingflag == true ){ return 1; }
	usingflag = true;
	return 0;
}

//! @brief ̂Ă
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param rx ]
//! @param speed ̂Ă鏉
void weapon::Dropoff(float x, float y, float z, float rx, float speed)
{
	//\WƊpxݒ
	move_x = cos(rx*-1 + (float)M_PI/2) * speed;
	move_y = 0.0f;
	move_z = sin(rx*-1 + (float)M_PI/2) * speed;
	pos_x = x + cos(rx*-1 + (float)M_PI/2) * 5.0f;
	pos_y = y + 16.0f + move_y;
	pos_z = z + sin(rx*-1 + (float)M_PI/2) * 5.0f;
	rotation_x = rx + (float)M_PI;

	//gpijɐݒ肵AWړL
	usingflag = false;
	motionflag = true;
}

//! @brief C
//! @return F0@sF1
//! @attention AˊԊul܂B
//! @attention ֐ŝ́Aꂩ̏łB@uAˊԊuɖȂvu[hsvueȂvuȕ̎ނݒ肳Ăv
int weapon::Shot()
{
	//NXݒ肳ĂȂΎs
	if( Param == NULL ){ return 1; }

	//ˊԊuɖȂA[hAeΎs
	if( shotcnt > 0 ){ return 1; }
	if( reloadcnt > 0 ){ return 1; }
	if( Loadbullets == 0 ){ return 1; }

	//ݒl擾
	WeaponParameter ParamData;
	if( Param->GetWeapon(id_parameter, &ParamData) == 1 ){ return 1; }

	//킪֒eȂ΁`
	if( id_parameter == ID_WEAPON_GRENADE ){
		//e炵AA˃JEgݒ
		bullets -= 1;
		shotcnt = ParamData.blazings;

		//[h
		if( bullets > 0 ){
			Loadbullets = 1;
		}
		else{
			Loadbullets = 0;
		}

		//eȂ΁A킲ƏłB
		if( bullets <= 0 ){
			RenderFlag = false;
			usingflag = false;
		}
		return 0;
	}

	//e炵AA˃JEgݒ
	Loadbullets -= 1;
	bullets -= 1;
	shotcnt = ParamData.blazings;
	return 0;
}

//! @brief [hJn
//! @return F0@sF1
//! @attention [hԂl܂B
//! @attention ֐ŝ́Aꂩ̏łB@u[hsvueȂvuȕ̎ނݒ肳Ăv
int weapon::StartReload()
{
	//NXݒ肳ĂȂΎs
	if( Param == NULL ){ return 1; }

	//[hAeΎs
	if( reloadcnt > 0 ){ return 1; }
	if( (bullets - Loadbullets) == 0 ){ return 1; }

	//̐\l擾
	WeaponParameter ParamData;
	if( Param->GetWeapon(id_parameter, &ParamData) != 0 ){ return 1; }

	//[hJEgݒ
	reloadcnt = ParamData.reloads + 1;
	return 0;
}

//! @brief [hs
//! @attention StartReload()֐ƈقȂAuɒe[܂B[hԂ͍l܂B
//! @attention [hԂlꍇAStartReload()֐ĂяoĂB̊֐͎IɎs܂B
int weapon::RunReload()
{
	//NXݒ肳ĂȂΎs
	if( Param == NULL ){ return 1; }

	//eΎs
	if( (bullets - Loadbullets) == 0 ){ return 1; }

	//̐\lAUe擾
	WeaponParameter ParamData;
	int nbsmax = 0;
	if( Param->GetWeapon(id_parameter, &ParamData) == 0 ){
		nbsmax = ParamData.nbsmax;
	}

	if( (bullets - Loadbullets) < nbsmax ){	//c̒e葕Ue
		bullets = (bullets - Loadbullets);
		Loadbullets = bullets;
	}
	else{									//c̒e̕
		bullets -= Loadbullets;
		Loadbullets = nbsmax;
	}

	return 0;
}

//! @brief [hJEg擾
//! @return JEg@i[hF1ȏj
int weapon::GetReloadCnt()
{
	return reloadcnt;
}

//! @brief ̎ށEe̕ύX
//! @param Resource ResourceManager̃|C^
//! @param id_param ޔԍ
//! @param lnbs e
//! @param nbs ve
//! @return F1@sF0
//! @attention vC[ɂ闠ZiF6EF7jpɗpӂꂽ֐łB֒eIꂽꍇAIɒe[܂B
//! @attention gpĂȂIuWFNgɑ΂ĎsƁÅ֐͎s܂B
bool weapon::ResetWeaponParam(class ResourceManager *Resource, int id_param, int lnbs, int nbs)
{
	//ĂȂ΁As
	if( RenderFlag == false ){ return 0; }

	//w肳ꂽݒl֏㏑
	id_parameter = id_param;
	bullets = nbs;
	Loadbullets = lnbs;

	//֒eȂ΁A[h
	if( id_param == ID_WEAPON_GRENADE ){
		if( (bullets > 0)&&(Loadbullets == 0) ){
			Loadbullets = 1;
		}
	}

	//fƃeNX`ݒ
	Resource->GetWeaponModelTexture(id_param, &id_model, &id_texture);
	WeaponParameter param;
	if( Param->GetWeapon(id_param, &param) == 0 ){
		model_size = param.size;
	}

	return 1;
}

//! @brief vZsiRj
//! @param CollD Collisioñ|C^
int weapon::RunFrame(class Collision *CollD)
{
	//NXݒ肳ĂȂΎs
	if( CollD == NULL ){ return 0; }

	//ĂȂ΁As
	if( RenderFlag == false ){ return 0; }

	//A˃JEgcĂ΁A1 炷
	if( shotcnt > 0 ){
		shotcnt -= 1;
	}
	else if( reloadcnt > 0 ){
		//[hJEgcĂ 1 炵AJEg 0 Ȃ΃[hs
		reloadcnt -= 1;
		if( reloadcnt == 0 ){
			RunReload();
		}
	}

	//NɂgĂ炸AړtOLȂ΁`
	if( (usingflag == false)&&(motionflag == true) ){
		float Dist;
		float maxDist;

		//ړxXV
		move_x *= 0.96f;
		move_z *= 0.96f;
		if( move_y > -1.8f ){
			move_y -= 0.3f;
		}

		//ubNɖ܂ĂΏȂ
		if( CollD->CheckALLBlockInside(pos_x, pos_y, pos_z) == true ){
			motionflag = false;
			return 0;
		}

		//̈ړx߂
		maxDist = sqrt(move_x*move_x + move_z*move_z);
		if( maxDist < 0.1f ){
			maxDist = 0.0f;
			move_x = 0.0f;
			move_z = 0.0f;
		}

		//ubNɐڂĂ΁Aȏ͐ړȂB
		if( maxDist > 0.0f ){
			if( CollD->CheckALLBlockIntersectDummyRay(pos_x, pos_y, pos_z, move_x/maxDist, 0, move_z/maxDist, NULL, NULL, &Dist, maxDist) == true ){
				//ubNɖ܂Ȃ悤ɎO
				Dist -= 0.1f;

				//ڂĂW܂ňړ
				pos_x += move_x/maxDist * Dist;
				pos_z += move_z/maxDist * Dist;

				//ړʂ 0 
				move_x = 0.0f;
				move_z = 0.0f;
			}
		}

		//ubNɐڂĂ΁A܂ŗ
		if( CollD->CheckALLBlockIntersectDummyRay(pos_x, pos_y, pos_z, 0, -1, 0, NULL, NULL, &Dist, abs(move_y)) == true ){
			CollD->CheckALLBlockIntersectRay(pos_x, pos_y, pos_z, 0, -1, 0, NULL, NULL, &Dist, abs(move_y));
			pos_y -= Dist - 0.2f;
			motionflag = false;
			return 0;
		}

		//W𔽉f
		pos_x += move_x;
		pos_y += move_y;
		pos_z += move_z;
	}

	return 0;
}

//! @brief `
//! @param d3dg D3DGraphics̃|C^
void weapon::Render(class D3DGraphics *d3dg)
{
	//NXݒ肳ĂȂΎs
	if( d3dg == NULL ){ return; }

	//ĂȂANɎgĂΏȂ
	if( RenderFlag == false ){ return; }
	if( usingflag == true ){ return; }

	//`
	d3dg->SetWorldTransform(pos_x, pos_y, pos_z, rotation_x, 0.0f, (float)M_PI/2, model_size);
	d3dg->RenderModel(id_model, id_texture);
}

//! @brief RXgN^
smallobject::smallobject(class ParameterInfo *in_Param, class MIFInterface *in_MIFdata, float x, float y, float z, float rx, int id_param, signed char p4, bool flag)
{
	Param = in_Param;
	MIFdata = in_MIFdata;
	pos_x = x;
	pos_y = y;
	pos_z = z;
	rotation_x = rx;
	rotation_y = 0.0f;
	RenderFlag = flag;
	model_size = 5.0f;

	id_parameter = id_param;
	point_p4 = p4;

	hp = 0;		//b
	jump_rx = 0.0f;
	move_rx = 0.0f;
	add_rx = 0.0f;
	add_ry = 0.0f;
	jump_cnt = 0;

	if( Param != NULL ){
		SmallObjectParameter ParamData;
		if( Param->GetSmallObject(id_param, &ParamData) == 0 ){
			hp = ParamData.hp;
		}
	}
	id_model = -1;
	id_texture = -1;
}

//! @brief fBXgN^
smallobject::~smallobject()
{}

//! @brief MIFf[^ǗNXݒ
//! @param in_MIFdata MIFInterfaceNX̃|C^
void smallobject::SetMIFInterfaceClass(class MIFInterface *in_MIFdata)
{
	MIFdata = in_MIFdata;
}

//! @brief ݒlݒ
//! @param id_param ̎ޔԍ
//! @param p4 4p[^
//! @param init IuWFNg
void smallobject::SetParamData(int id_param, signed char p4, bool init)
{
	rotation_y = 0.0f;
	id_parameter = id_param;
	point_p4 = p4;

	if( init == true ){
		hp = 0;		//b
		jump_rx = 0.0f;
		move_rx = 0.0f;
		add_rx = 0.0f;
		add_ry = 0.0f;
		jump_cnt = 0;

		if( id_param == TOTAL_PARAMETERINFO_SMALLOBJECT+1 -1 ){
			if( MIFdata != NULL ){
				hp = MIFdata->GetAddSmallobjectHP();
			}
		}
		else{
			if( Param != NULL ){
				SmallObjectParameter ParamData;
				if( Param->GetSmallObject(id_param, &ParamData) == 0 ){
					hp = ParamData.hp;
				}
			}
		}
	}
}

//! @brief ݒl擾
//! @param id_param ̎ޔԍ󂯎|C^iNULLj
//! @param p4 4p[^󂯎|C^iNULLj
void smallobject::GetParamData(int *id_param, signed char *p4)
{
	if( id_param != NULL ){ *id_param = id_parameter; }
	if( p4 != NULL ){ *p4 = point_p4; }
}

//! @brief ̗͂擾
//! @return ̗͒l
int smallobject::GetHP()
{
	return hp;
}

//! @brief ubN̏Ɉړ
//! @param CollD Collisioñ|C^
//! @return ̍Ẅړʁi0ňړȂj
float smallobject::CollisionMap(class Collision *CollD)
{
	//NXݒ肳ĂȂΎs
	if( CollD == NULL ){ return 0.0f; }

	float Dist;
	SmallObjectParameter ParamData;

	//ubNɖ܂Ă΁Â܂
	if( CollD->CheckALLBlockInside(pos_x, pos_y, pos_z) == true ){ return 0.0f; }

	//ɓ蔻
	if( CollD->CheckALLBlockIntersectRay(pos_x, pos_y, pos_z, 0, -1, 0, NULL, NULL, &Dist, 1000.0f) == true ){
		//蔻̑傫擾
		if( id_parameter == TOTAL_PARAMETERINFO_SMALLOBJECT+1 -1 ){
			Dist -= (float)MIFdata->GetAddSmallobjectDecide()/10.0f;
		}
		else{
			if( Param->GetSmallObject(id_parameter, &ParamData) == 0 ){
				Dist -= (float)ParamData.decide/10.0f;
			}
		}

		//Wړ
		pos_y -= Dist;
		return Dist;
	}

	return 0.0f;
}

//! @brief eqbg
//! @param attacks e̍U
void smallobject::HitBullet(int attacks)
{
	hp -= attacks;
	if( hp <= 0 ){
		Destruction();
	}
}

//! @brief ֒e̔qbg
//! @param attacks ̍U
//! @attention ɂvZOɍς܂ĂB
void smallobject::HitGrenadeExplosion(int attacks)
{
	hp -= attacks;
	if( hp <= 0 ){
		Destruction();
	}
}

//! @brief j󂷂
//! @attention ʏ HitBullet()֐  GrenadeExplosion()֐ 玩IɎs邽߁AڌĂяoKv͂܂B
void smallobject::Destruction()
{
	//RenderFlag = false;
	//return;

	//̐ݒl擾
	SmallObjectParameter paramdata;
	Param->GetSmallObject(id_parameter, &paramdata);

	//΂
	hp = 0;
	jump_cnt = paramdata.jump;

	//pݒ
	jump_rx = (float)M_PI/18 * GetRand(36);
	move_rx = (float)paramdata.jump * 0.04243f;
	add_rx = (float)M_PI/180 * GetRand(20);
	add_ry = (float)M_PI/180 * GetRand(20);
}

//! @brief vZsij󎞂̈ړȂǁj
int smallobject::RunFrame()
{
	//`悳ĂȂA̗͂cĂȂΏȂB
	if( RenderFlag == false ){ return 0; }
	if( hp > 0 ){ return 0; }

	int cnt;
	SmallObjectParameter paramdata;
	
	//łJEgvZ
	cnt = Param->GetSmallObject(id_parameter, &paramdata) - jump_cnt;

	//pWEpxvZ
	pos_x += cos(jump_rx) * move_rx;
	pos_y += jump_cnt * 0.1f;
	pos_z += sin(jump_rx) * move_rx;
	rotation_x += add_rx;
	rotation_y += add_ry;

	jump_cnt -= 1;

	//1bł`I
	if( cnt > (int)GAMEFPS ){
		RenderFlag = false;
		return 2;
	}

	return 1;
}

//! @brief `
//! @param d3dg D3DGraphics̃|C^
void smallobject::Render(D3DGraphics *d3dg)
{
	//NXݒ肳ĂȂΎs
	if( d3dg == NULL ){ return; }

	//ĂȂΏȂB
	if( RenderFlag == false ){ return; }

	//`
	d3dg->SetWorldTransform(pos_x, pos_y, pos_z, rotation_x, rotation_y, model_size);
	d3dg->RenderModel(id_model, id_texture);
}

//! @brief RXgN^
bullet::bullet(int modelid, int textureid)
{
	model_size = 1.0f;
	id_model = modelid;
	id_texture = textureid;
	RenderFlag = false;
}

//! @brief fBXgN^
bullet::~bullet()
{}

//! @brief WƊpxݒ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param rx ]
//! @param ry c]
void bullet::SetPosData(float x, float y, float z, float rx, float ry)
{
	pos_x = x;
	pos_y = y;
	pos_z = z;
	rotation_x = rx;
	rotation_y = ry;
}

//! @brief ݒlݒ
//! @param _attacks U
//! @param _penetration ђʗ
//! @param _speed e
//! @param _teamid `[ԍ
//! @param _humanid l̃f[^ԍ
//! @param init IuWFNg
void bullet::SetParamData(int _attacks, int _penetration, int _speed, int _teamid, int _humanid, bool init)
{
	attacks = _attacks;
	penetration = _penetration;
	speed = _speed;
	teamid = _teamid;
	humanid = _humanid;

	if( init == true ){
		cnt = 0;
	}
}

//! @brief WƊpx擾
//! @param x XW󂯎|C^iNULLj
//! @param y YW󂯎|C^iNULLj
//! @param z ZW󂯎|C^iNULLj
//! @param rx ]󂯎|C^iNULLj
//! @param ry c]󂯎|C^iNULLj
void bullet::GetPosData(float *x, float *y, float *z, float *rx, float *ry)
{
	if( x != NULL ){ *x = pos_x; }
	if( y != NULL ){ *y = pos_y; }
	if( z != NULL ){ *z = pos_z; }
	if( rx != NULL ){ *rx = rotation_x; }
	if( ry != NULL ){ *ry = rotation_y; }
}

//! @brief ݒl擾
//! @param _attacks U͂󂯎|C^iNULLj
//! @param _penetration ђʗ͂󂯎|C^iNULLj
//! @param _speed e󂯎|C^iNULLj
//! @param _teamid `[ԍ󂯎|C^iNULLj
//! @param _humanid l̃f[^ԍ󂯎|C^iNULLj
void bullet::GetParamData(int *_attacks, int *_penetration, int *_speed, int *_teamid, int *_humanid)
{
	if( _attacks != NULL ){ *_attacks = attacks; }
	if( _penetration != NULL ){ *_penetration = penetration; }
	if( _speed != NULL ){ *_speed = speed; }
	if( _teamid != NULL ){ *_teamid = teamid; }
	if( _humanid != NULL ){ *_humanid = humanid; }
}

//! @brief vZsie̐isEԏŁj
int bullet::RunFrame()
{
	//ĂȂΏȂ
	if( RenderFlag == false ){ return 0; }

	//ŎԂ߂Ă΁AIuWFNg𖳌
	if( cnt > BULLET_DESTROYFRAME ){
		RenderFlag = false;
		return 0;
	}

	//ړ
	pos_x += cos(rotation_x)*cos(rotation_y)*speed;
	pos_y += sin(rotation_y)*speed;
	pos_z += sin(rotation_x)*cos(rotation_y)*speed;
	cnt += 1;

	return 0;
}

//! @brief `
//! @param d3dg D3DGraphics̃|C^
void bullet::Render(class D3DGraphics *d3dg)
{
	//NXݒ肳ĂȂΎs
	if( d3dg == NULL ){ return; }

	//ĂȂΏȂB
	if( RenderFlag == false ){ return; }

	//eړO`悵Ȃ
	//@e˂Č΍
	if( cnt == 0 ){ return; }

	//`
	d3dg->SetWorldTransform(pos_x, pos_y, pos_z, (rotation_x * -1 - (float)M_PI/2), rotation_y, model_size);
	d3dg->RenderModel(id_model, id_texture);
}

//! @brief RXgN^
grenade::grenade(int modelid, int textureid) : bullet(modelid, textureid)
{
	if( Param != NULL ){
		WeaponParameter ParamData;
		if( Param->GetWeapon(ID_WEAPON_GRENADE, &ParamData) == 0 ){
			model_size = ParamData.size;
		}
	}
}

//! @brief fBXgN^
grenade::~grenade()
{}

//! @brief WƏݒ
//! @param speed 
//! @param _humanid l̃f[^ԍ
//! @param init IuWFNg
//! @attention  SetPosData() sĂB
void grenade::SetParamData(float speed, int _humanid, bool init)
{
	move_x = cos(rotation_x) * cos(rotation_y) * speed;
	move_y = sin(rotation_y) * speed;
	move_z = sin(rotation_x) * cos(rotation_y) * speed;
	humanid = _humanid;

	if( init == true ){
		cnt = 0;
	}
}

//! @brief x擾
//! @return x
float grenade::GetSpeed()
{
	return sqrt(move_x*move_x + move_y*move_y + move_z*move_z);
}

//! @brief vZsi֒e̐isEj
//! @return F2@oEhE˕ԂF1@ȊOF0
int grenade::RunFrame(class Collision *CollD, class BlockDataInterface *inblockdata)
{
	//ĂȂΏȂ
	if( RenderFlag == false ){ return 0; }

	//Ԃ߂Ă΁AIuWFNg𖳌AuvƂĕԂB
	if( cnt > GRENADE_DESTROYFRAME ){
		RenderFlag = false;
		return 2;
	}

	//Î~ĂΏȂ
	if( (move_x == 0.0f)&&(move_y == 0.0f)&&(move_z == 0.0f) ){
		cnt += 1;
		return 0;
	}

	/*
	//Î~ɋ߂ԂȂ΁AړȂB
	if( (move_x*move_x + move_y*move_y + move_z*move_z) < 0.1f*0.1f ){
		cnt += 1;
		return 0;
	}
	*/

	//ړxvZ
	move_x *= 0.98f;
	move_y = (move_y - 0.17f) * 0.98f;
	move_z *= 0.98f;

	int id, face;
	float Dist;
	float maxDist = sqrt(move_x*move_x + move_y*move_y + move_z*move_z);

	//}bvɑ΂ē蔻s
	if( CollD->CheckALLBlockIntersectRay(pos_x, pos_y, pos_z, move_x/maxDist, move_y/maxDist, move_z/maxDist, &id, &face, &Dist, maxDist) == true ){
		float vx, vy, vz;

		//}bvƏՓ˂W܂ňړ
		pos_x += move_x/maxDist * (Dist - 0.1f);
		pos_y += move_y/maxDist * (Dist - 0.1f);
		pos_z += move_z/maxDist * (Dist - 0.1f);

		//˂xNg߂
		CollD->ReflectVector(inblockdata, id, face, move_x, move_y, move_z, &vx, &vy, &vz);

		//
		move_x = vx * GRENADE_BOUND_ACCELERATION;
		move_y = vy * GRENADE_BOUND_ACCELERATION;
		move_z = vz * GRENADE_BOUND_ACCELERATION;

		cnt += 1;
		return 1;
	}

	//Wړ
	pos_x += move_x;
	pos_y += move_y;
	pos_z += move_z;

	cnt += 1;
	return 0;
}

//! @brief `
//! @param d3dg D3DGraphics̃|C^
void grenade::Render(class D3DGraphics *d3dg)
{
	//NXݒ肳ĂȂΎs
	if( d3dg == NULL ){ return; }

	//ĂȂΏȂB
	if( RenderFlag == false ){ return; }

	//`
	d3dg->SetWorldTransform(pos_x, pos_y, pos_z, (rotation_x * -1 - (float)M_PI/2), 0.0f, (float)M_PI/2, model_size);
	d3dg->RenderModel(id_model, id_texture);
}

//! @brief RXgN^
effect::effect(float x, float y, float z, float size, float rotation, int count, int texture, int settype)
{
	pos_x = x;
	pos_y = y;
	pos_z = z;
	model_size = size;
	camera_rx = 0.0f;
	camera_ry = 0.0f;
	rotation_x = rotation;
	cnt = count;
	setcnt = count;
	id_texture = texture;
	type = settype;
	if( cnt > 0 ){
		RenderFlag = true;
	}
	else{
		RenderFlag = false;
	}
	alpha = 1.0f;
}

//! @brief fBXgN^
effect::~effect()
{}

//! @brief ݒlݒ
//! @param size \{
//! @param rotation ]px
//! @param count \t[
//! @param texture eNX`̔Fԍ
//! @param settype GtFNg̎ށ@iEffect_Type gݍj
//! @param init IuWFNg
void effect::SetParamData(float size, float rotation, int count, int texture, int settype, bool init)
{
	model_size = size;
	rotation_texture = rotation;
	cnt = count;
	setcnt = count;
	id_texture = texture;
	type = settype;
	alpha = 1.0f;

	if( init == true ){
		camera_rx = 0.0f;
		camera_ry = 0.0f;
	}
}

//! @brief vZsir{[hj
//! @param in_camera_rx J̉px
//! @param in_camera_ry J̏cpx
//! @return sF1@`ŏIt[F2@ȂF0
int effect::RunFrame(float in_camera_rx, float in_camera_ry)
{
	//ĂȂΏȂ
	if( RenderFlag == false ){ return 0; }

	//JEgIAȂ悤ɐݒ
	if( cnt <= 0 ){
		RenderFlag = false;
		return 2;
	}

	//JWKp
	camera_rx = in_camera_rx;
	camera_ry = in_camera_ry;

	//ꏈs
	if( type & EFFECT_DISAPPEAR ){	//
		alpha -= 1.0f/setcnt;
	}
	if( type & EFFECT_MAGNIFY ){	//g
		model_size += model_size/50;
	}
	if( type & EFFECT_ROTATION ){	//]
		if( rotation_texture > 0.0f ){
			rotation_texture += (float)M_PI/180*1;
		}
		else{
			rotation_texture -= (float)M_PI/180*1;
		}
	}
	if( type & EFFECT_FALL ){		//
		pos_y -= 1.0f;
	}
	else{
		pos_y += 0.05f;
	}

	//JEg 1 
	cnt -= 1;
	return 1;
}

//! @brief `
//! @param d3dg D3DGraphics̃|C^
void effect::Render(class D3DGraphics *d3dg)
{
	//NXݒ肳ĂȂΎs
	if( d3dg == NULL ){ return; }

	//ĂȂΏȂB
	if( RenderFlag == false ){ return; }

	//`
	d3dg->SetWorldTransformEffect(pos_x, pos_y, pos_z, camera_rx*-1, camera_ry, rotation_texture, model_size);
	d3dg->RenderBoard(id_texture, alpha);
}