using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Diagnostics;

using System.Collections;

namespace Eyes
{
    public partial class Manager : Form
    {
        public class ListViewItemComparer : IComparer
        {
            //xy菬Ƃ̓}CiX̐A傫Ƃ̓vX̐A
            //Ƃ0Ԃ
            public int Compare(object x, object y)
            {
                //ListViewItem̎擾
                ListViewItem X = (ListViewItem)x;
                ListViewItem Y = (ListViewItem)y;

                if (X.Index < Y.Index)
                    return -1;

                if (X.Index > Y.Index)
                    return 1;

                return 0;
            }
        }

        private class History
        {
            private DateTime time;
            public DateTime Time
            {
                get { return time; }
                set { time = value; }
            }

            private string message;
            public string Message
            {
                get { return message; }
                set { message = value; }
            }
        }

        private void InitializeListView()
        {
            // ListViewRg[̃vpeBݒ
            listView.ListViewItemSorter = new ListViewItemComparer();

            // iRjwb_̍쐬
            ColumnHeader NickName = new ColumnHeader();
            ColumnHeader Memo = new ColumnHeader();

            NickName.Text = "o[";
            NickName.Width = 128;
            Memo.Text = "";
            Memo.Width = 256;

            updateListView();
        }

        private ListViewItem setListViewItem(ContactMember contact)
        {
            string[] info = { contact.NickName, contact.Memo };
            ListViewItem item = new ListViewItem(info, (int)contact.Status);
            item.ToolTipText = contact.Name + "@" + contact.Machine
                + " [" + contact.Address + "]\n" + contact.Memo;
            item.Tag = contact;
            item.Checked = contact.Notify;
            return item;
        }

        private void updateListView()
        {
            listView.Items.Clear();

            List<ListViewItem> items = new List<ListViewItem>();
            items.Add(setListViewItem(user));

            foreach (ContactMember contact in group.Members)
                items.Add(setListViewItem(contact));

            listView.Items.AddRange(items.ToArray());
        }

        private void UpdateListView(Group group)
        {
            this.group = group;
            updateListView();
        }

        private void listView_ItemChecked(object sender, ItemCheckedEventArgs e)
        {
            ListViewItem item = e.Item;
            ContactMember contact = (ContactMember)e.Item.Tag;

            contact.Notify = item.Checked;
        }

        private void listView_MouseUp(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                // Ԗڂ܂͓ԖڂIĂ鎞͏ɈړłȂ
                if ((listView.Items[0].Selected == true) ||
                    (listView.Items[1].Selected == true))
                    listMenuStrip.Items["listMenuUp"].Enabled = false;
                else
                    listMenuStrip.Items["listMenuUp"].Enabled = true;

                // Ԗڂ܂͍ŌオIĂ鎞͉ɈړłȂ
                int lastIndex = (listView.Items.Count - 1);

                if ((listView.Items[0].Selected == true) ||
                    (listView.Items[lastIndex].Selected == true))
                    listMenuStrip.Items["listMenuDown"].Enabled = false;
                else
                    listMenuStrip.Items["listMenuDown"].Enabled = true;

                // IĂ폜łȂ
                listMenuStrip.Items["deleteList"].Enabled = true;

                foreach (ListViewItem item in listView.SelectedItems)
                {
                    ContactMember contact = (ContactMember)item.Tag;

                    if ((contact.Name == user.Name)
                        && (contact.Address == user.Address))
                        listMenuStrip.Items["deleteList"].Enabled = false;
                }

                if (listView.Items[0].Selected == true)
                    listMenuStrip.Items["createGroup"].Enabled = false;
                else
                    listMenuStrip.Items["createGroup"].Enabled = true;

                if (listView.SelectedItems.Count > 0)
                    listMenuStrip.Show(Cursor.Position.X, Cursor.Position.Y);
                else
                    managerMenuStrip.Show(Cursor.Position.X, Cursor.Position.Y);
            }
        }

        private void deleteListToolStripMenuItem_Click(object sender, EventArgs e)
        {
            foreach (ListViewItem item in listView.SelectedItems)
            {   //  memberList ̒ɂȂ̂ŏȂ
                ContactMember contact = (ContactMember)item.Tag;

                if (group.Members.Contains(contact))
                {
                    int index = groupList.IndexOf(group);
                    delMemberFromTree(index, contact);
                    group.Members.Remove(contact);

                    if (group.Members.Count == 0)
                    {
                        delGroupFromTree(group);
                        groupList.Remove(group);
                        this.group = groupList[GROUP_ALL];
                    }
                }
            }

            updateTreeView();
        }

        private void createGroup_Click(object sender, EventArgs e)
        {
            FormGroupName dialog = new FormGroupName(groupList);
            dialog.Text = "VKO[v̍쐬";
            dialog.Label = "VKO[v";
            dialog.Button = "쐬";
            DialogResult result = dialog.ShowDialog();

            if (result == DialogResult.OK)
            {
                Group group = new Group();
                group.Name = dialog.GroupName;
                group.IsExpanded = true;

                foreach (ListViewItem item in listView.Items)
                    if (item.Selected)
                    {
                        ContactMember contact = (ContactMember)item.Tag;
                        if (contact != user)
                            group.Members.Add((ContactMember)item.Tag);
                    }

                groupList.Add(group);
                addGroupToTree(group);
            }
        }
    }
}