﻿using UnityEngine;
using System.Collections;

public class Player : MonoBehaviour {

	const int TIMER_DAMAGE = 30;
	const float DAMAGE_VELOCITY = 5.0f;
	const float DAMAGE_DECAY = 0.95f;
	const float SPEED_MAX = 30f;
	const float SPEED_ADJ = 0.3f;

	enum eState {
		Standby,
		Damage,
	}

	enum eSprite {
		Normal0 = 0,
		Normal1,
		Damage,
	}

	private eState _state;
	private int _timer;
	private Vector3 _prev = new Vector3();
	private bool _bMoving = false;

	/// <summary>
	/// Moving speed.
	/// </summary>
	public float speed = 5;

	private const float SCALE = 0.5f;
	private const float MARGIN = 0.5f;


	/// <summary>
	/// Shot Object.
	/// </summary>
	public GameObject shot;

	/// <summary>
	/// Shot Interval Timer.
	/// </summary>
	private int _tShot = 0;
	private int _tAnim = 0;

	private Vector2 _vDamage = new Vector2();

	/// <summary>
	/// Start create.
	/// </summary>
	void Start () {
		_tShot = 0;
		_tAnim = 0;
		_state = eState.Standby;
		_timer = 0;

		Layer2D l = TMXLoader.Load(1);
		const float x = -7.5f;
		const float y = -4.5f;
		const float dx = 0.75f;
		const float dy = 0.6f;
		Vector3 p = new Vector3(x, y, 0);
		for(int j = 0; j < l.height; j++) {
			for(int i = 0; i < l.width; i++) {
				int val = l.Get (i, j);
				if(val > 0) {
					Enemy.eType type = (Enemy.eType)(val - 2);
					Enemy.Add(type, p, 0f, 0f);
				}
				p.x += dx;
			}
			p.x = x;
			p.y += dy;
		}
	}

	private void SetSprite(eSprite id) {
		string name = "player_" + (int)id;
		SpriteRenderer sr = GetComponent<SpriteRenderer>();
		Sprite sp = Util.GetSprite("Sprites/all", name);
		sr.sprite = sp;
	}

	/// <summary>
	/// Add Shot
	/// </summary>
	/// <param name="direction">Direction.</param>
	/// <param name="speed">Speed.</param>
	private void DoShot(float direction, float speed) {
		Shot.Add (transform.position, direction, speed);
	}

	/// <summary>
	/// Step per frame.
	/// </summary>
	void Update () {
		_tAnim++;
		Move ();

		switch(_state) {
		case eState.Standby:
			UpdateStandby();
			break;
		case eState.Damage:
			UpdateDamage();
			break;
		}

		UpdateSprite();
	}

	private void UpdateStandby() {
		if(_bMoving == false) {
			_tShot++;
			if(_tShot%30 == 0) {
				DoShot (0, 10);
			}
		}
	}

	private void UpdateDamage() {
		_timer--;
		if(_timer < 0) {
			_timer = 0;
			_state = eState.Standby;
		}
	}

	private void UpdateSprite() {
		switch(_state) {
		case eState.Standby:
			if(_tAnim%40 < 20) {
				SetSprite (eSprite.Normal0);
			}
			else {
				SetSprite (eSprite.Normal1);
			}
			break;
		case eState.Damage:
			SetSprite(eSprite.Damage);
			break;
		}
	}

	private void Move() {
		// Calc direction.
		// Keyboard.
		float x = Input.GetAxisRaw("Horizontal");
		float y = Input.GetAxisRaw("Vertical");
		Vector2 direction = new Vector2(x, y).normalized;
		Vector2 vel = direction * speed;
		// Damage.
		_vDamage *= DAMAGE_DECAY;
		// Mouse.
		Vector2 vMouse = new Vector2();
		if(Input.GetMouseButtonDown(0)) {
			_prev = Input.mousePosition;
		}
		_bMoving = false;
		if(Input.GetMouseButton(0)) {
			Vector3 now = Input.mousePosition;
			Vector3 vec = now - _prev;
			float spd = vec.magnitude;
			if(spd > SPEED_MAX) {
				spd = SPEED_MAX;
			}
			vec.Normalize();
			vec.x *= spd * SPEED_ADJ;
			vec.y *= spd * SPEED_ADJ;
			vMouse = vec;
			_prev += vec * 0.5f;
			_bMoving = true;
		}

		// Assign
		rigidbody2D.velocity = vel + _vDamage + vMouse;

		// Clamp.
		Rect rect = Util.GetScreenRect(Util.eMargin.In);
		Vector2 pos = transform.position;
		pos.x = Mathf.Clamp (pos.x, rect.xMin, rect.xMax);
		pos.y = Mathf.Clamp (pos.y, rect.yMin, rect.yMax);
		transform.position = pos;

		if(x != 0 || y != 0) {
			Vector3 scale = transform.localScale;
			if(x > 0) {
				scale.x = SCALE;
				transform.localScale = scale;
			}
			else if(x < 0) {
				scale.x = -SCALE;
				transform.localScale = scale;
			}
		}
	
	}

	private void Damage(Vector2 vel) {
		_vDamage.Set (vel.x, vel.y);
		_vDamage.Normalize();
		_vDamage *= DAMAGE_VELOCITY;
		_state = eState.Damage;
		_timer = TIMER_DAMAGE;
	}

	void OnTriggerEnter2D(Collider2D c) {
		string name = LayerMask.LayerToName(c.gameObject.layer);
		if(name == "Bullet") {
			Damage (c.gameObject.rigidbody2D.velocity);
			Destroy (c.gameObject);
		}
		if(name == "Enemy") {
			//Vector2 v = c.gameObject.transform.position - transform.position;
			Vector2 v = transform.position - c.gameObject.transform.position;
			Damage (v);
		}
	}
}
