﻿using UnityEngine;
using System.Collections;

public class Bullet : MonoBehaviour {

	public static Bullet Add(Vector3 position, float direction, float speed) {
		GameObject prefab = (GameObject)Resources.Load ("Prefabs/Bullet");
		GameObject bullet = Instantiate (prefab, position, Quaternion.identity) as GameObject;
		Bullet b = bullet.GetComponent<Bullet>();
		b.Create(direction, speed);

		return b;
	}

	public void Create(float direction, float speed) {
		// Setting velocity.
		Vector2 v;
		v.x = Mathf.Cos (Mathf.Deg2Rad * direction) * speed;
		v.y = Mathf.Sin (Mathf.Deg2Rad * direction) * speed;
		rigidbody2D.velocity = v;
	}

	// Use this for initialization
	void Start () {
	
	}
	
	// Update is called once per frame
	void Update () {
	
		Vector2 pos = transform.position;
		bool bOut = Util.IsOut(pos, 0.2f);
		if(bOut) {
			// Out of Screen.
			Destroy(gameObject);
		}

	}
}
