#!/usr/bin/env python
# -*- coding: utf-8 -*-

import math
import random

# 2次元ベクトル
class Vec2D:
	def __init__(self, x=0, y=0):
		self.set(x, y)

	def set(self, x, y):
		self.x = x
		self.y = y

	def add(self, x, y):
		self.x += x
		self.y += y

	def mul(self, a):
		self.x *= a
		self.y *= a

	# 正規化
	def normalize(self):
		len = self.length()
		if(len == 0): return

		self.x /= len
		self.y /= len
	# 長さを求める
	def length(self):
		return math.sqrt(self.lengthSq())
	# 長さの２乗を求める
	def lengthSq(self):
		return (self.x ** 2) + (self.y ** 2)

class Util:
	# 平方根を求める
	@staticmethod
	def sqrt(a):
		if a == 0: return 0
		return math.sqrt(a)
	# 距離を求める
	@staticmethod
	def length(x, y): return math.sqrt(x ** 2 + y ** 2)
	# min <= a <= max に丸めた値を返す
	@staticmethod
	def round2(min, a, max):
		if a < min: return min
		if a > max: return max
		return a
	@staticmethod
	def abs(a):          return a if a < 0 else -a
	@staticmethod
	def sin(rad):        return math.sin(rad)
	@staticmethod
	def cos(rad):        return math.cos(rad)
	@staticmethod
	def atan2(dy, dx):   return math.atan2(dy, dx)
	@staticmethod
	def rad2deg(rad):    return math.degrees(rad)
	@staticmethod
	def deg2rad(deg):    return math.radians(deg)
	@staticmethod
	def sinEx(deg):      return math.sin(Util.deg2rad(deg))
	@staticmethod
	def cosEx(deg):      return math.cos(Util.deg2rad(deg))
	@staticmethod
	def atan2Ex(dy, dx): return Util.rad2deg(math.atan2(dy, dx))

	# 乱数関連
	@staticmethod
	def rand(a):       return random.randint(0, a)
	@staticmethod
	def randint(a, b): return random.randint(a, b)
	@staticmethod
	def randf(a):      return random.random() * a
	@staticmethod
	def randf2(a, b): return Util.randf(b - a) + a

