#!/usr/bin/env python
# -*- coding: utf-8 -*-

from xml.dom import minidom

class Layer2D:
	OUT     = -1 # Out of range.
	DEFAULT = 0
	def __init__(self, w, h):
		self._width = w
		self._height = h
		self._data = {}
		self._default = self.DEFAULT
		self._out = self.OUT
	def setDefault(self, v):
		self._default = v
	def setOut(self, v):
		self._out = v
	def toIdx(self, x, y):
		return y * self._width + x
	def toCoordinate(self, idx):
		x = idx % width
		y = idx / width
		return (x, y)
	def get(self, x, y):
		if(0 <= x < self._width and 0 <= y < self._height):
			idx = self.toIdx(x, y)
			if idx in self._data:
				return self._data[idx]
			else:
				return self._default
		return self._out
	def set(self, x, y, v):
		if(0 <= x < self._width and 0 <= y < self._height):
			idx = self.toIdx(x, y)
			self._data[idx] = v
		else:
			print("Warning: Layer2D.set(%d,%d) Out of range."%(x, y))
	def dump(self):
		print("[Layer2D] (w,h)=(%d,%d)"%(self._width, self._height))
		for j in range(self._height):
			s = ""
			for i in range(self._width):
				s += "%2d "%self.get(i, j)
			print(s)

class TmxLoader:
	def __init__(self):
		self.layer = None
		self.params = {}
	def load(self, filename):
		xdoc = minidom.parse(filename)
		e = xdoc.getElementsByTagName("property")
		for c in e:
			name = c.getAttribute("name")
			value = c.getAttribute("value")
			self.params[name] = value
		e = xdoc.getElementsByTagName("layer")[0]
		w = int(e.getAttribute("width"))
		h = int(e.getAttribute("height"))
		self.layer = Layer2D(w, h)
		e = xdoc.getElementsByTagName("data")[0]
		data = e.childNodes[0].data
		y = 0
		for line in data.split("\n"):
			if line == "": continue
			x = 0
			for v in line.split(","):
				if v == "": continue
				self.layer.set(x, y, int(v))
				x += 1
			y += 1

	def dump(self):
		print("[TmxLoader]")
		for k, v in self.params.items():
			print("- %s:%s"%(k, v))
		self.layer.dump()
def main():
	tmx = TmxLoader()
	tmx.load("test.tmx")
	tmx.dump()

if __name__ == "__main__":
	main()
