#!/usr/bin/env python
# -*- coding: utf-8 -*-

from itoken import *

# シーンの基底クラス
class Scene(IToken):
	def update(self):
		pass
	def draw(self):
		pass

# シーン官吏クラス
class SceneManager:
	current = None # 現在実行中のシーン
	pool    = {}   # シーンのプール
	@classmethod
	def add(cls, key, scene): cls.pool[key] = scene
	@classmethod
	def get(cls): return cls.current
	@classmethod
	def change(cls, key): cls.current = cls.pool[key]
	@classmethod
	def update(cls): cls.get().update()
	@classmethod
	def draw(cls): cls.get().draw()


