#!/usr/bin/env python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
import sys

class RpMusic:
	def __init__(self, graphics, font):
		self.ses  = {}
		self.channels = {}
		self.graphics = graphics
		self.font     = font

	def playBgm(self, path, loops=-1):
		pygame.mixer.music.load(path)
		pygame.mixer.music.play(loops)

	def stopBgm(self, msec=0):
		if(msec == 0):
			pygame.mixer.music.stop()
		else:
			pygame.mixer.music.fadeout(msec)

	def loadSe(self, key, path):
		if(key in self.ses):
			print("Warning: Already loaded %s -> %s"%(key, path))
			return

		se = pygame.mixer.Sound(path)
		self.ses[key] = se

	def playSe(self, key, oneShot=True, loops=0):
		if(key not in self.ses):
			print("Warning: Not found key: %s"%(key))
			return

		if(oneShot):
			# ワンショット再生
			if(key in self.channels):
				ch = self.channels[key]
				ch.stop()
		se = self.ses[key]
		self.channels[key] = se.play()
