#!/usr/bin/env python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
import sys

from joystick     import Joystick
from joysticknull import JoystickNull

	# 入力管理
class RpInput:
	_AXIS_BASE     = 32768 * 8 / 10
	_REPLAY_NONE   = 0
	_REPLAY_RECORD = 1
	_REPLAY_PLAY   = 2

	J_U = 2048 # ジョイスティック上
	J_L = 2049 # ジョイスティック左
	J_D = 2050 # ジョイスティック下
	J_R = 2051 # ジョイスティック右
	J_1 = 2052 # ジョイスティックボタン１
	J_2 = 2053 # ジョイスティックボタン２
	J_3 = 2054 # ジョイスティックボタン３
	J_4 = 2055 # ジョイスティックボタン４
	J_5 = 2056 # ジョイスティックボタン５
	J_6 = 2057 # ジョイスティックボタン６
	J_7 = 2058 # ジョイスティックボタン７
	J_8 = 2059 # ジョイスティックボタン８

	def __init__(self):
		self.press  = {}  # 押しているかどうか
		self.prev   = {}  # １フレーム前の入力
		self.push   = {}  # そのフレームでの入力

		self.init()

	def init(self):
		if pygame.joystick.get_count() > 0:
			self.joystick = Joystick()
		else:
			self.joystick = JoystickNull()

	# 入力更新
	def updateNormal(self):
		lbutton, mbutton, rbutton = pygame.mouse.get_pressed()
		tbl = {
			"LBUTTON" : lbutton != 0,
			"MBUTTON" : mbutton != 0,
			"RBUTTON" : rbutton != 0,
		}
		for i, press in enumerate(self.joystick.getButtonList()):
			tbl[RpInput.J_1+i] = press
		for i, press in enumerate(pygame.key.get_pressed()):
			tbl[i] = press

		self.updateFromTable(tbl)

	def updateFromTable(self, tbl):
		for key, value in tbl.items():
			self.push[key] = False
			if key not in self.press: self.press[key] = False
			self.prev[key] = self.press[key]
			self.press[key] = value
			if self.press[key] == True and self.prev[key] == False:
				self.push[key] = True

	def x(self):
		x, y = pygame.mouse.get_pos()
		return x

	def y(self):
		x, y = pygame.mouse.get_pos()
		return y

	def isPush(self, keycode):
		return self.push[keycode]

	def isPress(self, keycode):
		return self.press[keycode]

	def isPushEnter(self):
		if self.isPush(K_z): return True
		if self.isPush(K_RETURN): return True
		if self.isPush("LBUTTON"): return True

		return False

	def isPushCancel(self):
		if self.isPush(K_x): return True
		if self.isPush("RBUTTON"): return True

		return False

	def isPushMenu(self):
		if self.isPush(K_c): return True
		if self.isPush("MBUTTON"): return True

		return False

	def isPressEnter(self):
		if self.isPress(K_z): return True
		if self.isPress(K_RETURN): return  True
		if self.isPress("LBUTTON"): return True

		return False

	def isPressCancel(self):
		if self.isPress(K_x): return True
		if self.isPress("RBUTTON"): return True

		return False

	def isPressMenu(self):
		if self.isPress(K_c): return True
		if self.isPress("MBUTTON"): return True

		return False

	def isPushLeft(self):
		if self.isPush(K_LEFT): return True
		return False

	def isPushUp(self):
		if self.isPush(K_UP): return True
		return False

	def isPushRight(self):
		if self.isPush(K_RIGHT): return True
		return False

	def isPushDown(self):
		if self.isPush(K_DOWN): return True
		return False

	def isPressLeft(self):
		if self.isPress(K_LEFT): return True
		return False

	def isPressUp(self):
		if self.isPress(K_UP): return True
		return False

	def isPressRight(self):
		if self.isPress(K_RIGHT): return True
		return False

	def isPressDown(self):
		if self.isPress(K_DOWN): return True
		return False

