#!/usr/bin/env python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
import sys
import pygame.gfxdraw
from util import *
from csvloader import *

# スプライト情報
class SpriteInfo:
	def __init__(self, tex, x, y, w, h):
		self.tex = tex
		self.x = x
		self.y = y
		self.w = w
		self.h = h

# 描画管理
class RpGraphics:
	_DIR_RES = "resources/image/"
	_USE_GFX    = True # pygame.gfxdrawを使って描画する
	def __init__(self, screen):
		self.screen = screen
		self.images = {}
		self.setColor(255, 255, 255)
		self.setBlend()
		self.sprites = {}

	def loadSprite(self, tex, filename):
		csv = CsvLoader(filename)
		for i in range(csv.size()):
			idx = csv.indexToIdx(i)
			name = csv.getValue(idx, "name")
			x    = csv.getValue(idx, "x")
			y    = csv.getValue(idx, "y")
			w    = csv.getValue(idx, "w")
			h    = csv.getValue(idx, "h")
			sprite = SpriteInfo(tex, x, y, w, h)
			self.setSprite(name, sprite)
	def setSprite(self, name, sprite):
		self.sprites[name] = sprite
	def getSprite(self, name):
		return self.sprites[name]
	def drawSprite(self, name, x, y):
		sprite = self.getSprite(name)
		self.draw(sprite.tex, x, y, sprite.x, sprite.y, sprite.w, sprite.h)
	def drawSpriteEx(self, name, cx, cy):
		sprite = self.getSprite(name)
		self.drawEx(sprite.tex, cx, cy, sprite.x, sprite.y, sprite.w, sprite.h)

	def setColor(self, r, g, b, a=255):
		r = Util.round2(0, r, 255)
		g = Util.round2(0, g, 255)
		b = Util.round2(0, b, 255)
		a = Util.round2(0, a, 255)
		self.color = (r, g, b, a)
	def setColor2(self, color): self.color = color
	def setColorAlpha(self, alpha):
		self.setColor(self.color[0], self.color[1], self.color[2], int(alpha))
	def setAlpha(self, key, alpha=255):
		surface = self.get(key)
		if surface is None: return

		surface.set_alpha(alpha, RLEACCEL)
	def getAlpha(self): return self.color[3]
	def setBlend(self, mode="none"): self.blend = mode
	def getBlendMode(self):
		dict = {
			"none" : 0,
			"add"  : pygame.BLEND_RGBA_ADD,
			"sub"  : pygame.BLEND_RGBA_SUB,
			"mul"  : pygame.BLEND_RGBA_MULT,
		}

		return dict[self.blend]

	def update(self):
		# 画面塗りつぶし
		self.screen.fill((0, 0, 0))

	def flip(self):
		# 画面の更新
		pygame.display.update()

	def get(self, key):
		if(key not in self.images):
			print("Warning: Not found image %s"%(key))
			return None

		return self.images[key]

	def load(self, key, path, color=None, bFullPath=False):
		# 画像の読み込み
		if(key in self.images):
			print("Warning: Already loaded %s -> %s"%(key, path))
			return

		# 読み込み
		if(bFullPath == False):
			# リソースフォルダを見る
			path = self._DIR_RES + path

		img = pygame.image.load(path).convert()

		# 透過色の設定
		if color is not None:
			if color is -1:
				# -1 の場合は左上色
				color = img.get_at((0, 0))
			img.set_colorkey(color, RLEACCEL)

		# 格納
		self.images[key] = img

	def draw(self, key, x, y, ox=0, oy=0, ow=0, oh=0):
		# 画像の描画
		if(key not in self.images):
			print("Warning: Not found image %s"%(key))
			return

		img = self.get(key)
		if(ow == 0 or oh == 0):
			# サイズ指定がなければそのまま描画
			ow, oh = img.get_size()

		blend = self.getBlendMode()
		self.screen.blit(img, (x, y), (ox, oy, ow, oh), blend)

	def drawEx(self, key, cx, cy, ox=0, oy=0, ow=0, oh=0):
		if(key not in self.images):
			print("Warning: Not found image %s"%(key))
			return

		img = self.get(key)
		if(ow == 0 or oh == 0):
			# サイズ指定がなければそのまま描画
			ow, oh = img.get_size()

		x, y = cx - ow/2, cy - oh/2
		self.draw(key, x, y, ox, oy, ow, oh)


	# 矩形の描画（塗りつぶし）
	def fillRect(self, x, y, w, h):

		blend = self.getBlendMode()
		surface = self.screen
		if RpGraphics._USE_GFX:
			pygame.gfxdraw.box(surface, Rect(int(x), int(y), int(w), int(h)), self.color)
		else:
			self.screen.fill(self.color, Rect(x, y, w, h), blend)

	# 矩形の描画（塗りつぶし）
	def fillRectEx(self, cx, cy, w, h):
		x = cx - w
		y = cy - h
		w = w * 2
		h = h * 2
		self.fillRect(x, y, w, h)

	# 円の描画
	def fillCircle(self, cx, cy, radius):
		surface = self.screen
		if RpGraphics._USE_GFX:
			pygame.gfxdraw.filled_circle(surface, int(cx), int(cy), int(radius), self.color)
		else:
			self.drawCircle(int(cx), int(cy), int(radius), 0)

	def drawCircle(self, cx, cy, radius, width=1):
		surface = self.screen

		if radius < 1: return
		if width < 0: return
		if radius < width: return

		if RpGraphics._USE_GFX:
		#if RpGraphics._USE_GFX and width <= 1:
			pygame.gfxdraw.circle(surface, int(cx), int(cy), int(radius), self.color)
		else:
			pygame.draw.circle(surface, self.color, (int(cx), int(cy)), int(radius), int(width))

	# 線分の描画
	def drawLine(self, x1, y1, x2, y2):
		color = self.color
		p1    = (x1, y1)
		p2    = (x2, y2)
		pygame.draw.line(self.screen, color, p1, p2)
