package framework.util;

import openfl.Assets;

class CsvLoader {

    private var _header: Array<String>;
    private var _types: Array<String>;
    private var _datas: Map<Int, Map<String, String>>;

    public function new() {
    }

    public function load(filepath:String):Void {
        _datas = new Map<Int, Map<String, String>>();
        var text:String = Assets.getText(filepath);
        var row = 0;
        for(line in text.split("\n")) {
            if(line == "") { continue; }

            var arr:Array<String> = line.split(",");
            switch(row) {
            case 0:
                _header = line.split(",");
            case 1:
                _types = line.split(",");
            default:
                var nId = 0;
                var col = 0;
                var data:Map<String, String> = new Map<String, String>();
                for(k in _header) {
                    var v:String = arr[col];
                    if(k == "id") {
                        nId = Std.parseInt(v);
                    }
                    data.set(k, v);
                    col++;
                }
                _datas.set(nId, data);
            }
            row++;
        }
    }

    public function size():Int {
        var cnt:Int = 0;
        for(k in _datas.keys()) {
            cnt++;
        }
        return cnt;
    }

    public function keys():Iterator<Int> {
        return _datas.keys();
    }

    public function getString(id:Int, key:String):String {
        var data:Map<String, String> = _datas.get(id);
        return data.get(key);
    }
    public function getInt(id:Int, key:String):Int {
        return Std.parseInt(getString(id, key));
    }
    public function dump():Void {
        var str = "";
        for(s in _header) {
            str += s + ",";
        }
        trace(str);

        str = "";
        for(s in _types) {
            str += s + ",";
        }
        trace(str);
        for(k in _datas.keys()) {
            var data = _datas.get(k);
            str = "";
            for(d in data) {
                str += d + ",";
            }
            trace(str);
        }
    }
}
