package ;

import framework.util.HitRect;
import framework.util.Vec2D;
import framework.util.Layer2D;
import framework.TokenManager;
import framework.IScene;
import framework.Token;
import framework.util.TmxLoader;

class Shot extends Token {
    public static var parent:ShotManager;
    public override function update():Void {
        move();
        if(isOut()) {
            vanish();
        }
    }
    public override function draw():Void {
        _g.setColor(0xFFFFFF);
        _g.drawRect(x-2, y-2, 4, 4);
    }
}

class ShotManager extends TokenManager {
    public function create(x:Float, y:Float, deg:Float, speed:Float):Void {
        add(x, y, deg, speed);
    }
}

class Wall extends Token {
    public static var parent:WallManager;
    public function new() {
        super();
        hitRects = [new HitRect(0, 0, 32, 32)];
    }
    public override function update():Void {
    }
    public override function draw():Void {
        _g.drawSpriteEx("block2", x, y);
    }
}
class WallManager extends TokenManager {
    public function create(x:Float, y:Float):Void {
        add(x, y);
    }
}

class Player extends Token {
    public function new() {
        super();
        hitRects = [new HitRect(0, 0, 32, 32)];
        x = 400;
        y = 500;
    }
    public override function update():Void {
        if(_i.isPressEnter()) {
            Shot.parent.create(x, y, 90, 5);
        }
        x+=_i.getX() * 5;
        y+=_i.getY() * 5;
    }
    public override function draw():Void {
        _g.drawSpriteEx("mikuR1", x, y);
        drawHit();
    }
}

class SceneMain extends IScene {
    private var player:Player;
    public function new() {
        super();
        _m.load("bomb", "damage3.wav");
        //_m.loop("001.ogg");

        player = new Player();
        Shot.parent = new ShotManager(Shot, 32);
        Wall.parent = new WallManager(Wall, 128);

        _g.load("char", "charset.png");
        _g.loadSpriteFromCsv("char", "assets/charset.csv");

        var tmx:TmxLoader = new TmxLoader();
        tmx.load("assets/001.tmx");
        var layer:Layer2D = tmx.getLayer(0);
        var v:Vec2D = layer.search(Tile.Player);
        player.x = v.x * tmx.tileWidth + tmx.tileWidth/2;
        player.y = v.y * tmx.tileHeight + tmx.tileHeight/2;
        for(j in 0...layer.height) {
            for(i in 0...layer.width) {
                var x = i * tmx.tileWidth + tmx.tileWidth/2;
                var y = j * tmx.tileHeight + tmx.tileHeight/2;
                var val = layer.get(i, j);
                switch(val) {
                case Tile.Wall:
                   Wall.parent.add(x, y);
                }
            }
        }
    }

    public override function initialize():Void {
    }

    public override function update():Void {

        Wall.parent.update();
        player.update();
        Shot.parent.update();
    }

    public override function draw():Void {

        _f.drawAscii(0, 0, "wall:"+Wall.parent.count());
        Wall.parent.draw();
        player.draw();
        Shot.parent.draw();
    }
}
