/*
 *  The MIT License
 *
 *  Copyright 2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.dropbox_uploader;

import android.content.Context;
import com.dropbox.client2.DropboxAPI;
import com.dropbox.client2.android.AndroidAuthSession;
import com.dropbox.client2.session.AccessTokenPair;
import com.dropbox.client2.session.AppKeyPair;
import com.dropbox.client2.session.Session.AccessType;
import org.routine_work.util.Log;

public final class DropboxAppConfig
{

	private static final String LOG_TAG = "simple-battery-logger-dropbox";
	private static final String APP_KEY = "dsq51heqaqhf2ci";
	private static final String APP_SECRET = "ga64qr6va6q6sv6";
	private static final AccessType ACCESS_TYPE = AccessType.APP_FOLDER;
	private static DropboxAPI<AndroidAuthSession> dropboxAPI;

	private DropboxAppConfig()
	{
	}

	public static synchronized DropboxAPI<AndroidAuthSession> getDropboxAPI(Context context)
	{
		if (dropboxAPI == null)
		{

			AppKeyPair appKeys = new AppKeyPair(APP_KEY, APP_SECRET);
			AndroidAuthSession session;

			AccessTokenPair tokenPair = PreferenceUtils.getAccessTokenPair(context);
			Log.d(LOG_TAG, "tokenPair => " + tokenPair);
			if (tokenPair != null)
			{
				session = new AndroidAuthSession(appKeys, ACCESS_TYPE, tokenPair);
			}
			else
			{
				session = new AndroidAuthSession(appKeys, ACCESS_TYPE);
			}

			dropboxAPI = new DropboxAPI<AndroidAuthSession>(session);
		}

		return dropboxAPI;
	}
}
