/*
 *  The MIT License
 * 
 *  Copyright 2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 * 
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 * 
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 * 
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.dropbox_uploader.db;

public interface DBConstants
{

	String DATABASE_NAME = "csv-upload-status.sqlite";
	int DATABASE_VERSION = 2;
	String SORT_ASCENDING = "ASC";
	String SORT_DESCENDING = "DESC";

	interface CsvUploadStatus
	{

		String TABLE_NAME = "CSVUploadStatus";

		interface Columns
		{

			String ID = "_id";
			String FILEPATH = "filepath";
			String MODIFIED = "modified";
		}
		String CREATE_TABLE_SQL = "CREATE TABLE " + TABLE_NAME + "("
			+ "  " + Columns.ID + " INTEGER PRIMARY KEY AUTOINCREMENT"
			+ ", " + Columns.FILEPATH + " TEXT NOT NULL UNIQUE"
			+ ", " + Columns.MODIFIED + " INTEGER NOT NULL"
			+ ");";
		String CREATE_FILEPATH_INDEX_SQL = "CREATE INDEX " + Columns.FILEPATH + "_index "
			+ "ON " + TABLE_NAME + "(" + Columns.FILEPATH + ");";
		String DROP_TABLE_SQL = "DROP TABLE " + TABLE_NAME + ";";
		String REINDEX_SQL = "REINDEX;";
		String VACCUM_SQL = "VACUUM;";
	}
}
