/*
 *  The MIT License
 * 
 *  Copyright 2011 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 * 
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 * 
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 * 
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.db;

/**
 *
 * @author Masahiko, SAWAI <masahiko.sawai@gmail.com>
 */
public interface DBConstants
{

	String DATABASE_NAME = "battery-history.sqlite";
	int DATABASE_VERSION = 2;
	String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
	String DATE_FORMAT = "yyyy-MM-dd";
	String SORT_ASCENDING = "ASC";
	String SORT_DESCENDING = "DESC";

	interface BatteryHistory
	{

		String TABLE_NAME = "BatteryHistory";

		interface Columns
		{

			String ID = "_id";
			String DATETIME = "datetime";
			String STATUS = "status";
			String HEALTH = "health";
			String LEVEL = "level";
			String SCALE = "scale";
			String PLUGGED = "plugged";
			String VOLTAGE = "voltage";
			String TEMPERATURE = "temperature";
		}
		String CREATE_TABLE_SQL = "CREATE TABLE " + TABLE_NAME + "("
			+ "  " + Columns.ID + " INTEGER PRIMARY KEY AUTOINCREMENT"
			+ ", " + Columns.DATETIME + " DATETIME"
			+ ", " + Columns.STATUS + " INTEGER"
			+ ", " + Columns.HEALTH + " INTEGER"
			+ ", " + Columns.LEVEL + " INTEGER"
			+ ", " + Columns.SCALE + " INTEGER"
			+ ", " + Columns.PLUGGED + " INTEGER"
			+ ", " + Columns.VOLTAGE + " INTEGER"
			+ ", " + Columns.TEMPERATURE + " INTEGER"
			+ ");";
		String CREATE_DATETIME_INDEX_SQL = "CREATE INDEX " + Columns.DATETIME + "_index "
			+ "ON " + TABLE_NAME + "(" + Columns.DATETIME + ");";
		String DROP_TABLE_SQL = "DROP TABLE " + TABLE_NAME + ";";
		String REINDEX_SQL = "REINDEX;";
		String VACCUM_SQL = "VACUUM;";
	}

	interface BatteryHistoryDate
	{

		String TABLE_NAME = "BatteryHistoryDate";

		interface Columns
		{

			String ID = "_id";
			String DATE = "date";
		}
		String CREATE_VIEW_SQL = "CREATE VIEW " + TABLE_NAME + " "
			+ "AS "
			+ "SELECT "
			+ "  max(b." + BatteryHistory.Columns.ID + ") AS " + Columns.ID + " "
			+ ", date(b." + BatteryHistory.Columns.DATETIME + ") AS " + Columns.DATE + " "
			+ "FROM "
			+ "  " + BatteryHistory.TABLE_NAME + " AS b "
			+ "GROUP BY "
			+ "  date(b." + BatteryHistory.Columns.DATETIME + ") "
			+ ";";
		String DROP_VIEW_SQL = "DROP VIEW " + TABLE_NAME + ";";
	}
}
