/*
 *  The MIT License
 * 
 *  Copyright 2011 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 * 
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 * 
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 * 
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger;

import android.content.Context;
import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author Masahiko, SAWAI <masahiko.sawai@gmail.com>
 */
public class BatteryUtils
{

	private static final Map<Integer, Integer> STATUS_CODE_AND_RESOURCE_MAP = new HashMap<Integer, Integer>();
	private static final Map<Integer, Integer> HEALTH_CODE_AND_RESOURCE_MAP = new HashMap<Integer, Integer>();
	private static final Map<Integer, Integer> PLUGGED_CODE_AND_RESOURCE_MAP = new HashMap<Integer, Integer>();

	static
	{
		// STATUS_CODE_AND_RESOURCE_MAP
		STATUS_CODE_AND_RESOURCE_MAP.put(BatteryConstants.BATTERY_STATUS_UNKNOWN, R.string.status_unknown);
		STATUS_CODE_AND_RESOURCE_MAP.put(BatteryConstants.BATTERY_STATUS_CHARGING, R.string.status_charging);
		STATUS_CODE_AND_RESOURCE_MAP.put(BatteryConstants.BATTERY_STATUS_DISCHARGING, R.string.status_discharging);
		STATUS_CODE_AND_RESOURCE_MAP.put(BatteryConstants.BATTERY_STATUS_NOT_CHARGING, R.string.status_not_charging);
		STATUS_CODE_AND_RESOURCE_MAP.put(BatteryConstants.BATTERY_STATUS_FULL, R.string.status_full);
		// HEALTH_CODE_AND_RESOURCE_MAP
		HEALTH_CODE_AND_RESOURCE_MAP.put(BatteryConstants.BATTERY_HEALTH_UNKNOWN, R.string.health_unknown);
		HEALTH_CODE_AND_RESOURCE_MAP.put(BatteryConstants.BATTERY_HEALTH_GOOD, R.string.health_good);
		HEALTH_CODE_AND_RESOURCE_MAP.put(BatteryConstants.BATTERY_HEALTH_OVERHEAT, R.string.health_overheat);
		HEALTH_CODE_AND_RESOURCE_MAP.put(BatteryConstants.BATTERY_HEALTH_DEAD, R.string.health_dead);
		HEALTH_CODE_AND_RESOURCE_MAP.put(BatteryConstants.BATTERY_HEALTH_OVER_VOLTAGE, R.string.health_over_voltage);
		HEALTH_CODE_AND_RESOURCE_MAP.put(BatteryConstants.BATTERY_HEALTH_UNSPECIFIED_FAILURE, R.string.health_unspecified_failure);
		HEALTH_CODE_AND_RESOURCE_MAP.put(BatteryConstants.BATTERY_HEALTH_COLD, R.string.health_cold);
		// PLUGGED_CODE_AND_RESOURCE_MAP
		PLUGGED_CODE_AND_RESOURCE_MAP.put(0, R.string.plugged_none);
		PLUGGED_CODE_AND_RESOURCE_MAP.put(BatteryConstants.BATTERY_PLUGGED_AC, R.string.plugged_ac);
		PLUGGED_CODE_AND_RESOURCE_MAP.put(BatteryConstants.BATTERY_PLUGGED_USB, R.string.plugged_usb);
		PLUGGED_CODE_AND_RESOURCE_MAP.put(BatteryConstants.BATTERY_PLUGGED_WIRELESS, R.string.plugged_wireless);

	}

	public static String getStatusText(Context context, int statusCode)
	{
		String statusText;

		if (STATUS_CODE_AND_RESOURCE_MAP.containsKey(statusCode))
		{
			int resourceId = STATUS_CODE_AND_RESOURCE_MAP.get(statusCode);
			statusText = context.getString(resourceId);
		}
		else
		{
			statusText = String.valueOf(statusCode);
		}

		return statusText;
	}

	public static String getHealthText(Context context, int healthCode)
	{
		String healthText;

		if (HEALTH_CODE_AND_RESOURCE_MAP.containsKey(healthCode))
		{
			int resourceId = HEALTH_CODE_AND_RESOURCE_MAP.get(healthCode);
			healthText = context.getString(resourceId);
		}
		else
		{
			healthText = String.valueOf(healthCode);
		}

		return healthText;
	}

	public static String getPluggedText(Context context, int pluggedCode)
	{
		String pluggedText;
		if (PLUGGED_CODE_AND_RESOURCE_MAP.containsKey(pluggedCode))
		{
			int pluggedId = PLUGGED_CODE_AND_RESOURCE_MAP.get(pluggedCode);
			pluggedText = context.getString(pluggedId);
		}
		else
		{
			pluggedText = String.valueOf(pluggedCode);
		}
		return pluggedText;
	}
}
