/****************************************************
 * R a y  S p e e d e r                             *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#include "_Global.h"

#include "Bar.hpp"

#define m g_main

Bar::Bar(int x, int y, int col, int count, BOOL border) {
	_x      = (double)x;
	_y      = (double)y;
	_col    = col;
	_count  = count;
	_border = border;

	_hit[0] = FALSE;
	_hit[1] = FALSE;
	_hit[2] = FALSE;
}
int Bar::x() { return (int)_x; }
int Bar::y() { return (int)_y; }
int Bar::col() { return _col; }
int Bar::count() { return _count; }
BOOL Bar::update() {
	_y += (double)(m->speeder[0]->speed()) / 20.0;

	int y;
	int dsp_x0, dsp_y0;
	int dsp_x1, dsp_y1;
	int dsp_x2, dsp_y2;
	for ( int i = 0; i < 3; i++ ) {
		y = m->speeder[i]->dsp_y();
		if ( (y > -96) && (y < 640) && ((int)_y > y) && !_hit[i] ) {
			_hit[i] = TRUE;

			if ( i != 0 ) {
				// ړ
				if ( m->speeder[i]->x() <= ((int)_x + 126) ) {
					m->speeder[i]->right();
					m->speeder[i]->__auto(AUTO_MOVED_INERTIA);
				} else if ( m->speeder[i]->x() >= ((int)_x + 226) ) {
					m->speeder[i]->left();
					m->speeder[i]->__auto(AUTO_MOVED_INERTIA);
				} else if ( m->speeder[i]->x() != ((int)_x + 176) ) {
					m->speeder[i]->set_direction((((int)_x + 176) - m->speeder[i]->x()) / 10);
					m->speeder[i]->__auto(AUTO_MOVED_NEUTRAL);
				} else {
					m->speeder[i]->__auto(AUTO_NEUTRAL);
				}

				// XCh
				dsp_x0 = m->speeder[0]->dsp_x();
				dsp_y0 = m->speeder[0]->dsp_y();
				dsp_x1 = m->speeder[1]->dsp_x();
				dsp_y1 = m->speeder[1]->dsp_y();
				dsp_x2 = m->speeder[2]->dsp_x();
				dsp_y2 = m->speeder[2]->dsp_y();
				switch ( i ) {
				case 1:
					if (
					( dsp_x1       <= (dsp_x0 + 48)) &&
					( dsp_y1       <= (dsp_y0 + 96)) &&
					((dsp_x1 + 48) >=  dsp_x0      ) &&
					((dsp_y1 + 96) >=  dsp_y0      )
					) {
						if ( m->speeder[0]->x() < ((int)_x + 176) ) {
							m->speeder[i]->slide_right();
						} else {
							m->speeder[i]->slide_left();
						}
					} else if (
					( dsp_x1       <= (dsp_x2 + 48)) &&
					( dsp_y1       <= (dsp_y2 + 96)) &&
					((dsp_x1 + 48) >=  dsp_x2      ) &&
					((dsp_y1 + 96) >=  dsp_y2      )
					) {
						if ( m->speeder[2]->x() < ((int)_x + 176) ) {
							m->speeder[i]->slide_right();
						} else {
							m->speeder[i]->slide_left();
						}
					}
					break;
				case 2:
					if (
					( dsp_x2       <= (dsp_x0 + 48)) &&
					( dsp_y2       <= (dsp_y0 + 96)) &&
					((dsp_x2 + 48) >=  dsp_x0      ) &&
					((dsp_y2 + 96) >=  dsp_y0      )
					) {
						if ( m->speeder[0]->x() < ((int)_x + 176) ) {
							m->speeder[i]->slide_right();
						} else {
							m->speeder[i]->slide_left();
						}
					} else if (
					( dsp_x2       <= (dsp_x1 + 48)) &&
					( dsp_y2       <= (dsp_y1 + 96)) &&
					((dsp_x2 + 48) >=  dsp_x1      ) &&
					((dsp_y2 + 96) >=  dsp_y1      )
					) {
						if ( m->speeder[1]->x() < ((int)_x + 176) ) {
							m->speeder[i]->slide_right();
						} else {
							m->speeder[i]->slide_left();
						}
					}
					break;
				}
			}

			// ړ
			if ( m->level == 4 ) {
				if ( m->speeder[0]->x() <= ((int)_x + 76) ) {
					m->speeder[0]->right();
					m->speeder[0]->right();
					m->speeder[0]->__auto(AUTO_MOVED_INERTIA);
				} else if ( m->speeder[0]->x() >= ((int)_x + 276) ) {
					m->speeder[0]->left();
					m->speeder[0]->left();
					m->speeder[0]->__auto(AUTO_MOVED_INERTIA);
				} else if ( m->speeder[0]->x() != ((int)_x + 176) ) {
					m->speeder[0]->set_direction((((int)_x + 176) - m->speeder[0]->x()) / 10);
					m->speeder[0]->__auto(AUTO_MOVED_NEUTRAL);
				} else {
					m->speeder[0]->__auto(AUTO_NEUTRAL);
				}
			}

			// V[hύX
			if ( m->level == 5 ) {
				if ( _col < 3 ) m->speeder[0]->shield(_col);
			}

			// Xs[hύX
			BOOL in = TRUE;
			if ( (m->level != 4) && (((int)_x > m->speeder[i]->x()) || (((int)_x + 352) < m->speeder[i]->x())) ) {
				in = FALSE;
			}
			if ( in && ((_col == 3) || (_col == m->speeder[i]->shield())) ) {
				if ( m->level != 6 ) {
					m->speeder[i]->speed_up();
					if ( _col == 3 ) {
						m->speeder[i]->speed_up();
					}
				}
			} else {
				if ( m->level != 6 ) {
					m->speeder[i]->speed_down();
				} else {
					m->speeder[i]->speed_down(5);
				}
			}

			if ( i == 0 ) {
				// Xs[hύX
				if ( (m->level < 2) || (m->level == 7) ) {
					if ( m->speeder[1]->out() ) {
						if ( (m->speeder[1]->dsp_y() <= -96) && (m->shield_wait[0] > 0) ) {
							m->speeder[1]->speed_down();
						} else {
							m->speeder[1]->speed_up();
						}
					}
					if ( m->speeder[2]->out() ) {
						if ( (m->speeder[2]->dsp_y() <= -96) && (m->shield_wait[1] > 0) ) {
							m->speeder[2]->speed_down();
						} else {
							m->speeder[2]->speed_up();
						}
					}
				}

				// bv^Cv
				if ( _border ) {
					m->_elapse_l = m->_elapse;
					m->lap = 9 - _count;
					m->time[m->lap] = m->time[0];
					if ( m->lap == 1 ) {
						m->lap_time = m->time[m->lap] - m->best_time[m->index_b()][m->lap];
					} else {
						m->lap_time = (m->time[m->lap] - m->time[m->lap - 1]) - m->best_time[m->index_b()][m->lap];
					}
					m->dsp_lap = TRUE;
					if ( m->lap == 9 ) {
						m->finish = TRUE;
						m->boost = FALSE;
					}
				}
			}
		}
		if ( (m->level >= 2) && (m->level <= 6) ) break;
	}

	if ( (int)_y >= 640 ) {
		return FALSE;
	}
	return TRUE;
}
