/****************************************************
 * ނ`                                       *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#ifndef SYSTEM_HPP
#define SYSTEM_HPP

#include <windows.h>

#include <stdio.h>
#include <string.h>

#define SYSTEM_VERSION "0001"

struct SystemData {
	BOOL bWindow;
	BOOL bFullFrame;
	BOOL bCheckActive;
	BOOL bShowFPS;
	BOOL bWriteLog;
	int volumeMusic;
	int volumeSound;
	char name[11];
	int button[6];
};

class MySystem {
private:
	char szDir[MAX_PATH];

public:
	/**
	 * RXgN^
	 */
	MySystem(char* dir) {
		strcpy(szDir, dir);
	}

	/**
	 * ݒ̓ǂݍ
	 */
	void load(SystemData* data) {
		// ftHgl
		data->bWindow      = TRUE;
		data->bFullFrame   = TRUE;
		data->bCheckActive = TRUE;
		data->bShowFPS     = FALSE;
		data->bWriteLog    = TRUE;
		data->volumeMusic  = 100;
		data->volumeSound  = 85;
		memset(data->name, '\0', 11);
		data->button[0] = 0;
		data->button[1] = 1;
		data->button[2] = 2;
		data->button[3] = 3;
		data->button[4] = 4;
		data->button[5] = 5;

		int i;
		char file[MAX_PATH];
		sprintf(file, "%s\\system.dat", szDir);
		FILE* fp;
		int tmp;
		char tmp2[11];
		if ( (fp = fopen(file, "rb")) != NULL ) {
			for ( ; ; ) {
				// o[W`FbN
				char header[11];
				char header2[11];
				if ( fread(header, 10, 1, fp) <= 0 ) {
					break;
				}
				header[10] = '\0';
				sprintf(header2, "SYSTEM%s", SYSTEM_VERSION);
				if ( strcmp(header, header2) != 0 ) {
					break;
				}

				if ( fread(&tmp, sizeof(int), 1, fp) == 1 ) {
					data->bWindow = (tmp == 1) ? TRUE : FALSE;
				}

				if ( fread(&tmp, sizeof(int), 1, fp) == 1 ) {
					data->bFullFrame = (tmp == 1) ? TRUE : FALSE;
				}

				if ( fread(&tmp, sizeof(int), 1, fp) == 1 ) {
					data->bCheckActive = (tmp == 1) ? TRUE : FALSE;
				}

				if ( fread(&tmp, sizeof(int), 1, fp) == 1 ) {
					data->bShowFPS = (tmp == 1) ? TRUE : FALSE;
				}

				if ( fread(&tmp, sizeof(int), 1, fp) == 1 ) {
					data->bWriteLog = (tmp == 1) ? TRUE : FALSE;
				}

				if ( fread(&tmp, sizeof(int), 1, fp) == 1 ) {
					data->volumeMusic = tmp;
				}

				if ( fread(&tmp, sizeof(int), 1, fp) == 1 ) {
					data->volumeSound = tmp;
				}

				if ( fread(tmp2, sizeof(char), 10, fp) == 10 ) {
					memcpy(data->name, tmp2, 10);
					data->name[10] = '\0';
				}

				for ( i = 0; i < 6; i++ ) {
					if ( fread(&tmp, sizeof(int), 1, fp) == 1 ) {
						data->button[i] = tmp;
					}
				}

				break;
			}
			fclose(fp);
		}
	}

	/**
	 * ݒ̏o
	 */
	void save(SystemData* data) {
		int i;
		char file[MAX_PATH];
		sprintf(file, "%s\\system.dat", szDir);
		FILE* fp;
		int tmp;
		if ( (fp = fopen(file, "w+b")) != NULL ) {
			char header[11];
			sprintf(header, "SYSTEM%s", SYSTEM_VERSION);
			fwrite(header, sizeof(char), 10, fp);

			tmp = (data->bWindow == TRUE) ? 1 : 0;
			fwrite(&tmp, sizeof(int), 1, fp);

			tmp = (data->bFullFrame == TRUE) ? 1 : 0;
			fwrite(&tmp, sizeof(int), 1, fp);

			tmp = (data->bCheckActive == TRUE) ? 1 : 0;
			fwrite(&tmp, sizeof(int), 1, fp);

			tmp = (data->bShowFPS == TRUE) ? 1 : 0;
			fwrite(&tmp, sizeof(int), 1, fp);

			tmp = (data->bWriteLog == TRUE) ? 1 : 0;
			fwrite(&tmp, sizeof(int), 1, fp);

			fwrite(&(data->volumeMusic), sizeof(int), 1, fp);

			fwrite(&(data->volumeSound), sizeof(int), 1, fp);

			fwrite(data->name, sizeof(char), 10, fp);

			for ( i = 0; i < 6; i++ ) {
				fwrite(&(data->button[i]), sizeof(int), 1, fp);
			}

			fflush(fp);
			fclose(fp);
		}
	}
};

#endif // SYSTEM_HPP
