/****************************************************
 * ނ`                                       *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#include "_Global.h"

#include "Spark.hpp"

#define m g_main
#define g g_main->g

Spark::Spark(int x0, int y0, int color) {
	_x0 = x0;
	_y0 = y0;
	_x1 = 320 + (m->_rand->nextInt() % 320);
	_y1 = 240 + (m->_rand->nextInt() % 240);
	_x = _x0;
	_y = _y0;
	_color = color;
	_elapse = 0;
	if ( _color > 2 ) {
		_color = (m->_rand->nextInt() % 2) + 1;
	}
}

BOOL Spark::update() {
	_elapse++;
	if ( _elapse > 12 ) {
		return FALSE;
	}
	m->move(_x0, _y0, _x1, _y1, _elapse * 5);
	_x = m->move_x();
	_y = m->move_y();
	return TRUE;
}

void Spark::draw() {
	switch ( _elapse / 2 ) {
	case 1:
	case 2:
		g->drawImage(m->use_image(DATA_SHOT), _x - 10, _y - 10,  72 + 18 * _color, 0, 18, 18);
		break;
	case 3:
	case 4:
		g->drawImage(m->use_image(DATA_SHOT), _x - 6, _y - 6,  126 + 12 * _color, 0, 12, 12);
		break;
	case 5:
	case 6:
		g->drawImage(m->use_image(DATA_SHOT), _x - 2, _y - 2, 162 + 6 * _color, 0, 6, 6);
		break;
	}
}
