/****************************************************
 * ނ`                                       *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#include <stdio.h>

#include "_Global.h"

#include "_String.hpp"

#include "Replay.hpp"

Replay::Replay() {
	_key      = NULL;
	_key_size = 0;
	_key_num  = 0;
	_key_cur  = 0;

	_opt      = NULL;
	_opt_size = 0;
	_opt_num  = 0;
	_opt_cur  = 0;

	_rand      = NULL;
	_rand_size = 0;
	_rand_num  = 0;
	_rand_cur  = 0;

	add = TRUE;
}

Replay::~Replay() {
	if ( _key ) {
		GlobalFree(_key);
	}

	if ( _opt ) {
		GlobalFree(_opt);
	}

	if ( _rand ) {
		GlobalFree(_rand);
	}
}

void Replay::add_key(UINT key) {
	if ( !add ) {
		return;
	}
	if ( _key_num == _key_size ) {
		UINT* tmp = (UINT*)GlobalAlloc(GMEM_FIXED, sizeof(UINT) * (_key_size + 1000));
		if ( _key ) {
			memcpy(tmp, _key, sizeof(UINT) * _key_size);
			GlobalFree(_key);
		}
		_key = tmp;
		_key_size += 1000;
	}
	_key[_key_num] = key;
	_key_num++;
}

void Replay::add_opt(BOOL opt1, BOOL opt2, BOOL opt3, BOOL opt4, BOOL opt5) {
	if ( !add ) {
		return;
	}
	if ( _opt_num == _opt_size ) {
		unsigned char* tmp = (unsigned char*)GlobalAlloc(GMEM_FIXED, sizeof(unsigned char) * (_opt_size + 1000));
		if ( _opt ) {
			memcpy(tmp, _opt, sizeof(unsigned char) * _opt_size);
			GlobalFree(_opt);
		}
		_opt = tmp;
		_opt_size += 1000;
	}
	_opt[_opt_num] = 0;
	if ( opt1 ) _opt[_opt_num] +=  1;
	if ( opt2 ) _opt[_opt_num] +=  2;
	if ( opt3 ) _opt[_opt_num] +=  4;
	if ( opt4 ) _opt[_opt_num] +=  8;
	if ( opt5 ) _opt[_opt_num] += 16;
	_opt_num++;
}

void Replay::add_rand(int rand) {
	if ( !add ) {
		return;
	}
	if ( _rand_num == _rand_size ) {
		int* tmp = (int*)GlobalAlloc(GMEM_FIXED, sizeof(int) * (_rand_size + 1000));
		if ( _rand ) {
			memcpy(tmp, _rand, sizeof(int) * _rand_size);
			GlobalFree(_rand);
		}
		_rand = tmp;
		_rand_size += 1000;
	}
	_rand[_rand_num] = rand;
	_rand_num++;
}

void Replay::add_end() {
	add = FALSE;
}

void Replay::save(char* file, _String* name, int level, int st_index, int score) {
	FILE* fp;
	if ( (fp = fopen(file, "w+b")) != NULL ) {
		char comment[256];
		memset(comment, '\0', 256);
		sprintf(comment, "REPLAY%s", REPLAY_VERSION);
		strcat(comment, "\r\n");
		strcat(comment, "ނ`vCf[^\r\n");
		strcat(comment, "NameF");
		strcat(comment, name->str());
		strcat(comment, "\r\n");
		strcat(comment, "LevelF");
		switch ( level ) {
		case 0: strcat(comment, "Normal"); break;
		case 1: strcat(comment, "Hard"); break;
		case 2: strcat(comment, "Extra"); break;
		case 3: strcat(comment, "Normal(\[h)"); break;
		case 4: strcat(comment, "Hard(\[h)"); break;
		case 5: strcat(comment, "Extra(\[h)"); break;
		case 6: strcat(comment, "Normal(Random)"); break;
		case 7: strcat(comment, "Hard(Random)"); break;
		case 8: strcat(comment, "Extra(Random)"); break;
		}
		strcat(comment, "\r\n");
		strcat(comment, "StageF");
		switch ( st_index ) {
		case 0: strcat(comment, "C"); break;
		case 1: strcat(comment, "NX"); break;
		case 2: strcat(comment, "GNZ"); break;
		}
		strcat(comment, "\r\n");
		strcat(comment, "ScoreF");
		char szScore[10];
		sprintf(szScore, "%d", score);
		strcat(comment, szScore);
		strcat(comment, "\r\n");
		comment[strlen(comment)] = 0x1A;
		fwrite(comment, sizeof(char), 256, fp);

		char tmp[11];
		memset(tmp, '\0', 11);
		strcpy(tmp, name->str());
		fwrite(tmp, sizeof(char), 10, fp);

		fwrite(&level   , sizeof(int), 1, fp);
		fwrite(&st_index, sizeof(int), 1, fp);
		fwrite(&score   , sizeof(int), 1, fp);

		fwrite(&_key_num, sizeof(unsigned long), 1, fp);
		if ( _key_num > 0 ) {
			fwrite(_key, sizeof(UINT), _key_num, fp);
		}

		fwrite(&_opt_num, sizeof(unsigned long), 1, fp);
		if ( _opt_num > 0 ) {
			fwrite(_opt, sizeof(unsigned char), _opt_num, fp);
		}

		fwrite(&_rand_num, sizeof(unsigned long), 1, fp);
		if ( _rand_num > 0 ) {
			fwrite(_rand, sizeof(int), _rand_num, fp);
		}

		fclose(fp);
	}
}

BOOL Replay::info(char* file, _String* name, int* level, int* st_index, int* score) {
	BOOL ret = TRUE;
	FILE* fp;
	if ( (fp = fopen(file, "rb")) != NULL ) {
		char comment[256];
		if ( fread(comment, sizeof(char), 256, fp) < 256 ) ret = FALSE;

		char tmp[16];
		sprintf(tmp, "REPLAY%s", REPLAY_VERSION);
		if ( strncmp(comment, tmp, 10) != 0 ) ret = FALSE;

		if ( fread(tmp, sizeof(char), 10, fp) < 10 ) ret = FALSE;
		tmp[10] = '\0';
		name->set(tmp);

		if ( fread(level, sizeof(int), 1, fp) < 1 ) ret = FALSE;
		if ( (*level < 0) || (*level >= LEVEL_NUM) ) ret = FALSE;

		if ( fread(st_index, sizeof(int), 1, fp) < 1 ) ret = FALSE;
		if ( (*st_index < 0) || (*st_index >= STAGE_NUM) ) ret = FALSE;

		if ( fread(score, sizeof(int), 1, fp) < 1 ) ret = FALSE;

		fclose(fp);
	} else {
		return FALSE;
	}
	return ret;
}
BOOL Replay::check(char* file) {
	BOOL ret;
	_String* name = new _String("");
	int level;
	int st_index;
	int score;
	ret = info(file, name, &level, &st_index, &score);
	delete name;
	return ret;
}

BOOL Replay::load(char* file, _String* name, int* level, int* st_index, int* score) {
	BOOL ret = TRUE;

	if ( _key ) {
		GlobalFree(_key);
		_key = NULL;
	}
	_key_size = 0;
	_key_num  = 0;
	_key_cur  = 0;

	if ( _opt ) {
		GlobalFree(_opt);
		_opt = NULL;
	}
	_opt_size = 0;
	_opt_num  = 0;
	_opt_cur  = 0;

	if ( _rand ) {
		GlobalFree(_rand);
		_rand = NULL;
	}
	_rand_size = 0;
	_rand_num  = 0;
	_rand_cur  = 0;

	// t@CTCY擾
	DWORD file_size = 0;
	HANDLE hFile;
	hFile = ::CreateFile(
		(LPCTSTR)file,
		GENERIC_READ,
		FILE_SHARE_READ,
		NULL,
		OPEN_EXISTING,
		NULL,
		NULL
		);
	if ( hFile != INVALID_HANDLE_VALUE ) {
		file_size = ::GetFileSize(hFile, NULL);
		::CloseHandle(hFile);
	}

	FILE* fp;
	if ( (fp = fopen(file, "rb")) != NULL ) {
		char comment[256];
		if ( fread(comment, sizeof(char), 256, fp) < 256 ) ret = FALSE;

		char tmp[16];
		sprintf(tmp, "REPLAY%s", REPLAY_VERSION);
		if ( strncmp(comment, tmp, 10) != 0 ) ret = FALSE;

		if ( fread(tmp, sizeof(char), 10, fp) < 10 ) ret = FALSE;
		tmp[10] = '\0';
		name->set(tmp);

		if ( fread(level   , sizeof(int), 1, fp) < 1 ) ret = FALSE;
		if ( fread(st_index, sizeof(int), 1, fp) < 1 ) ret = FALSE;
		if ( fread(score   , sizeof(int), 1, fp) < 1 ) ret = FALSE;

		if ( (*level    < 0) || (*level    >= LEVEL_NUM) ) ret = FALSE;
		if ( (*st_index < 0) || (*st_index >= STAGE_NUM) ) ret = FALSE;

		if ( fread(&_key_num, sizeof(unsigned long), 1, fp) < 1 ) ret = FALSE;
		if ( _key_num > 0 ) {
			if ( (sizeof(UINT) * _key_num) > file_size ) {
				ret = FALSE;
			} else {
				_key = (UINT*)GlobalAlloc(GMEM_FIXED, sizeof(UINT) * _key_num);
				if ( fread(_key, sizeof(UINT), _key_num, fp) < _key_num ) ret = FALSE;
			}
		}
		_key_size = _key_num;

		if ( fread(&_opt_num, sizeof(unsigned long), 1, fp) < 1 ) ret = FALSE;
		if ( _opt_num > 0 ) {
			if ( (sizeof(unsigned char) * _opt_num) > file_size ) {
				ret = FALSE;
			} else {
				_opt = (unsigned char*)GlobalAlloc(GMEM_FIXED, sizeof(unsigned char) * _opt_num);
				if ( fread(_opt, sizeof(unsigned char), _opt_num, fp) < _opt_num ) ret = FALSE;
			}
		}
		_opt_size = _opt_num;

		if ( fread(&_rand_num, sizeof(unsigned long), 1, fp) < 1 ) ret = FALSE;
		if ( _rand_num > 0 ) {
			if ( (sizeof(int) * _rand_num) > file_size ) {
				ret = FALSE;
			} else {
				_rand = (int*)GlobalAlloc(GMEM_FIXED, sizeof(int) * _rand_num);
				if ( fread(_rand, sizeof(int), _rand_num, fp) < _rand_num ) ret = FALSE;
			}
		}
		_rand_size = _rand_num;

		fclose(fp);
	} else {
		return FALSE;
	}

	return ret;
}

void Replay::get_key(UINT* key) {
	if ( _key_cur < _key_num ) {
		*key = _key[_key_cur];
		_key_cur++;
	} else {
		*key = 0;
	}
}

void Replay::get_opt(BOOL* opt1, BOOL* opt2, BOOL* opt3, BOOL* opt4, BOOL* opt5) {
	if ( _opt_cur < _opt_num ) {
		*opt1 = ((_opt[_opt_cur] &  1) != 0) ? TRUE : FALSE;
		*opt2 = ((_opt[_opt_cur] &  2) != 0) ? TRUE : FALSE;
		*opt3 = ((_opt[_opt_cur] &  4) != 0) ? TRUE : FALSE;
		*opt4 = ((_opt[_opt_cur] &  8) != 0) ? TRUE : FALSE;
		*opt5 = ((_opt[_opt_cur] & 16) != 0) ? TRUE : FALSE;
		_opt_cur++;
	} else {
		*opt1 = FALSE;
		*opt2 = FALSE;
		*opt3 = FALSE;
		*opt4 = FALSE;
		*opt5 = FALSE;
	}
}

void Replay::get_rand(int* rand) {
	if ( _rand_cur < _rand_num ) {
		*rand = _rand[_rand_cur];
		_rand_cur++;
	} else {
		*rand = 0;
	}
}
