/****************************************************
 * ނ`                                       *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#include <io.h>
#include <stdio.h>

#include "_Global.h"

#include "Main.hpp"

// vCf[^p̃tO̓AvœƎɒ`
#define REPLAY_ESCAPE		0x0001
#define REPLAY_SHIFT		0x0002
#define REPLAY_SPACE		0x0004
#define REPLAY_LEFT			0x0008
#define REPLAY_RIGHT		0x0010
#define REPLAY_UP			0x0020
#define REPLAY_DOWN			0x0040
#define REPLAY_BUTTON1		0x0080
#define REPLAY_BUTTON2		0x0100
#define REPLAY_BUTTON3		0x0200
#define REPLAY_BUTTON4		0x0400
#define REPLAY_BUTTON5		0x0800
#define REPLAY_BUTTON6		0x1000
#define REPLAY_BUTTON7		0x2000
#define REPLAY_BUTTON8		0x4000
#define REPLAY_BUTTON9		0x8000

int CIRCLE_X[] = {
	 120,  118,  114,  106,   97,   84,   70,   54,   37,   18,
	   0,  -18,  -37,  -54,  -70,  -84,  -97, -106, -114, -118,
	-120, -118, -114, -106,  -97,  -84,  -70,  -54,  -37,  -18,
	   0,   18,   37,   54,   70,   84,   97,  106,  114,  118,
	 120
};
int CIRCLE_Y[] = {
	   0,   18,   37,   54,   70,   84,   97,  106,  114,  118,
	 120,  118,  114,  106,   97,   84,   70,   54,   37,   18,
	   0,  -18,  -37,  -54,  -70,  -84,  -97, -106, -114, -118,
	-120, -118, -114, -106,  -97,  -84,  -70,  -54,  -37,  -18,
	   0
};

Main::Main() {
	MySystem* sys = new MySystem(g_appDir);
	sys->load(&sys_data);
	delete sys;

	for ( int i = 0; i < 6; i++ ) {
		switch ( sys_data.button[i] ) {
		case  0: button[i] = _KEY_BUTTON1 ; break;
		case  1: button[i] = _KEY_BUTTON2 ; break;
		case  2: button[i] = _KEY_BUTTON3 ; break;
		case  3: button[i] = _KEY_BUTTON4 ; break;
		case  4: button[i] = _KEY_BUTTON5 ; break;
		case  5: button[i] = _KEY_BUTTON6 ; break;
		case  6: button[i] = _KEY_BUTTON7 ; break;
		case  7: button[i] = _KEY_BUTTON8 ; break;
		case  8: button[i] = _KEY_BUTTON9 ; break;
		case  9: button[i] = _KEY_BUTTON10; break;
		case 10: button[i] = _KEY_BUTTON11; break;
		case 11: button[i] = _KEY_BUTTON12; break;
		case 12: button[i] = _KEY_BUTTON13; break;
		}
	}

	setKey(button[0], button[1], button[2], button[3]);
}

void Main::start() {
	int i;

	lock_dispose_image = FALSE;

	pak_data = NULL;

	g = getGraphics();

	_rand       = new _Random();
	_replay     = NULL;
	replay_data = NULL;
	jshot       = NULL;
	eshot       = NULL;
	spark       = NULL;
	tame        = NULL;
	awa         = NULL;
	burst       = NULL;
	jiki        = NULL;
	enemy       = NULL;

	COLOR_M = g->getColorOfRGB(255,   0, 255);
	COLOR_W = g->getColorOfRGB(255, 255, 255);
	COLOR_K = g->getColorOfRGB(  0,   0,   0);

	setBackColor(COLOR_W);

	launch_step = 0;

	state = STATE_LAUNCH;
	old_state = state;
	pause = FALSE;
	select_title = 0;
	select_replay = 0;

	replay = FALSE;

	request_lock    = FALSE;
	request_color_0 = FALSE;
	request_color_1 = FALSE;
	request_color_2 = FALSE;
	request_dash    = FALSE;

	save_replay = FALSE;

	script_reader = NULL;

	set_state(STATE_LAUNCH);
}

void Main::destroy() {
writeLog("I");
	if ( pak_data ) {
		GlobalFree(pak_data);
	}

	delete _rand;
	if ( _replay     ) delete _replay;
	if ( replay_data ) delete replay_data;
	if ( jshot       ) delete jshot;
	if ( eshot       ) delete eshot;
	if ( spark       ) delete spark;
	if ( tame        ) delete tame;
	if ( awa         ) delete awa;
	if ( burst       ) delete burst;
	if ( jiki        ) delete jiki;
	if ( enemy       ) delete enemy;

	if ( script_reader != NULL ) {
		GlobalFree(script_in);
		delete script_reader;
	}

	lock_dispose_image = FALSE;
	dispose_image();

	dispose_music();
	dispose_sound();
writeLog("I܂");
}

void Main::resume() {
	switch ( state ) {
	case STATE_PLAY_MAIN:
	case STATE_PLAY_BOSS:
	case STATE_PLAY_MAIN2:
	case STATE_PLAY_BOSS2:
		pause = TRUE;
		pause2 = TRUE;
		select_pause = 0;
		m_elapse_p = 0;
		break;
	}
}

void Main::paint() {
	UINT key = getKeypadState();

	int i, j;

	switch ( state ) {
	case STATE_LAUNCH:
		g->setColor(COLOR_M);
		g->drawString("`ǒ...", 5, 20);
		g->drawString("`ǒ...", 6, 20);
		if ( launch_step == 0 ) {
			if ( m_elapse > 0 ) {
				launch_step++;
			}
			break;
		} else if ( launch_step == 1 ) {
			// ɋ󂫂ꍇApbNf[^Ɏ荞ł܂
			_String* file = new _String("");
			file->set(g_appDir);
			file->add("\\data.pak");
			HANDLE hFile;
			hFile = ::CreateFile(
				(LPCTSTR)file->str(),
				GENERIC_READ,
				FILE_SHARE_READ,
				NULL,
				OPEN_EXISTING,
				NULL,
				NULL
				);
			if ( hFile != INVALID_HANDLE_VALUE ) {
				DWORD tmp;
				DWORD size = ::GetFileSize(hFile, NULL);
				if ( (pak_data = (unsigned char*)GlobalAlloc(GMEM_FIXED, size)) != NULL ) {
					::ReadFile(hFile, pak_data, size, &tmp, NULL);
writeLog("pbNf[^Ɏ荞݂܂");
				}
				::CloseHandle(hFile);
			}
			delete file;
#ifdef _DEBUG
			{
				char file[MAX_PATH];
				FILE* fp;
				sprintf(file, "%s\\debug", g_appDir);
				CreateDirectory(file, NULL);
				_Memory* data;
				for ( i = 0; i < DATA_NUM; i++ ) {
					data = read_data(i);
					sprintf(file, "%s\\debug\\%d", g_appDir, i);
					if ( (fp = fopen(file, "w+b")) != NULL ) {
						fwrite(data->ptr(), 1, data->size(), fp);
						fflush(fp);
						fclose(fp);
					}
					delete data;
				}
			}
#endif // _DEBUG
			launch_step++;
			break;
		} else if ( launch_step == 2 ) {
			BOOL lock = TRUE;
			for ( i = 0; i < IMAGE_NUM; i++ ) {
				if ( use_image(i) == NULL ) {
					lock = FALSE;
				}
			}
			lock_dispose_image = lock;
			dispose_image();
			launch_step++;
			break;
		} else if ( launch_step == 3 ) {
			for ( i = 0; i < SE_NUM; i++ ) {
				use_sound(i);
			}
			for ( i = 0; i < BGM_NUM; i++ ) {
				if ( !create_music(i) ) {
					dispose_music();
					break;
				}
			}
			launch_step++;
			break;
		} else if ( launch_step == 4 ) {
			load_config();
			launch_step++;
			break;
		}
writeLog("N܂");
		set_state(STATE_TITLE);
		// ̂܂܉ɗ
	case STATE_TITLE:
	case STATE_SELECTSTAGE:
	case STATE_SELECTREPLAY:
	case STATE_SCORE:
	case STATE_EXIT:
	case STATE_EXIT2:
		drawTitleBack();
		switch ( level % 3 ) {
		case 0: g->drawImage(use_image(DATA_FONT_LEV_1 + (level / 3)), 620 - FONT_LEV_LEVEL_W - 8 - FONT_LEV_NORMAL_W, 220, FONT_LEV_NORMAL_X, 0, FONT_LEV_NORMAL_W, FONT_LEV_H); break;
		case 1: g->drawImage(use_image(DATA_FONT_LEV_1 + (level / 3)), 620 - FONT_LEV_LEVEL_W - 8 - FONT_LEV_HARD_W  , 220, FONT_LEV_HARD_X  , 0, FONT_LEV_HARD_W  , FONT_LEV_H); break;
		case 2: g->drawImage(use_image(DATA_FONT_LEV_1 + (level / 3)), 620 - FONT_LEV_LEVEL_W - 8 - FONT_LEV_EXTRA_W , 220, FONT_LEV_EXTRA_X , 0, FONT_LEV_EXTRA_W , FONT_LEV_H); break;
		}
		g->drawImage(use_image(DATA_FONT_LEV_1 + (level / 3)), 620 - FONT_LEV_LEVEL_W, 220, FONT_LEV_LEVEL_X, 0, FONT_LEV_LEVEL_W, FONT_LEV_H);
		switch ( level / 3 ) {
		case 1: g->drawImage(use_image(DATA_FONT_LEV_2), 620 - FONT_LEV_2_SETSU_W, 250, FONT_LEV_SETSU_X, 0, FONT_LEV_2_SETSU_W, FONT_LEV_H); break;
		case 2: g->drawImage(use_image(DATA_FONT_LEV_3), 620 - FONT_LEV_3_SETSU_W, 250, FONT_LEV_SETSU_X, 0, FONT_LEV_3_SETSU_W, FONT_LEV_H); break;
		}
		g->drawImage(use_image(DATA_FONT_LEV_1), 620 - FONT_LEV_SCORE_W, 270, FONT_LEV_SCORE_X, 0, FONT_LEV_SCORE_W, FONT_LEV_H);
		g->drawImage(use_image(DATA_FONT_LEV_1), 620 - FONT_LEV_REPLAY_W, 320, FONT_LEV_REPLAY_X, 0, FONT_LEV_REPLAY_W, FONT_LEV_H);
		g->drawImage(use_image(DATA_FONT_LEV_1), 620 - FONT_LEV_EXIT_W, 370, FONT_LEV_EXIT_X, 0, FONT_LEV_EXIT_W, FONT_LEV_H);
		switch ( select_title ) {
		case 0:
			switch ( level % 3 ) {
			case 0: g->drawImage(use_image(DATA_SELECT), 620 - FONT_LEV_LEVEL_W - 8 - FONT_LEV_NORMAL_W - 50, 222); break;
			case 1: g->drawImage(use_image(DATA_SELECT), 620 - FONT_LEV_LEVEL_W - 8 - FONT_LEV_HARD_W   - 50, 222); break;
			case 2: g->drawImage(use_image(DATA_SELECT), 620 - FONT_LEV_LEVEL_W - 8 - FONT_LEV_EXTRA_W  - 50, 222); break;
			}
			g->drawImage(use_image(DATA_FONT_SMALL), 620 - 412, 420, 0, 54, 412, 21);
			break;
		case 1:
			g->drawImage(use_image(DATA_SELECT), 620 - FONT_LEV_SCORE_W - 50, 272);
			g->drawImage(use_image(DATA_FONT_SMALL), 620 - 184, 420, 0, 75, 184, 21);
			break;
		case 2:
			g->drawImage(use_image(DATA_SELECT), 620 - FONT_LEV_REPLAY_W - 50, 322);
			g->drawImage(use_image(DATA_FONT_SMALL), 620 - 159, 420, 0, 96, 159, 21);
			break;
		case 3:
			g->drawImage(use_image(DATA_SELECT), 620 - FONT_LEV_EXIT_W - 50, 372);
			g->drawImage(use_image(DATA_FONT_SMALL), 620 - 180, 420, 0, 117, 180, 21);
			break;
		}
		switch ( state ) {
		case STATE_TITLE:
			if ( (old_state != STATE_SELECTSTAGE2) && (old_state != STATE_SELECTREPLAY2) && (old_state != STATE_SCORE2) ) {
				g->setAlpha(255 - (((m_elapse * 4) > 255) ? 255 : (m_elapse * 4)));
				g->drawImage(use_image(DATA_WHITE), 0, 0);
				g->setAlpha(255);
			}
			break;
		case STATE_SELECTSTAGE:
			if ( key == 0 ) {
				set_state(STATE_SELECTSTAGE2);
			}
			break;
		case STATE_SELECTREPLAY:
			if ( old_state != STATE_TITLE ) {
				replay_white = TRUE;
				g->drawImage(use_image(DATA_WHITE), 0, 0);
			} else {
				replay_white = FALSE;
			}
			if ( key == 0 ) {
				set_state(STATE_SELECTREPLAY2);
			}
			break;
		case STATE_SCORE:
			if ( key == 0 ) {
				set_state(STATE_SCORE2);
			}
			break;
		case STATE_EXIT2:
			g->setAlpha(((m_elapse * 4) > 255) ? 255 : (m_elapse * 4));
			g->drawImage(use_image(DATA_BLACK), 0, 0);
			g->setAlpha(255);
			if ( (m_elapse * 4) >= 255 ) {
writeLog("Iv");
				setBackColor(COLOR_K);
				lock_dispose_image = FALSE;
				dispose_image();
				dispose_music();
				dispose_sound();
				save_config();
				terminate();
			}
			break;
		}
		break;
	case STATE_SELECTSTAGE2:
		g->setBright(((255 - m_elapse * 3) < 127) ? 127 : (255 - m_elapse * 3));
		g->drawImage(use_image(DATA_BACK_COM), 0, 0);
		g->setBright(255);
		switch ( st_index ) {
		case 0:
			g->setBright(127);
			g->drawImage(use_image(DATA_STAGE3), 20, 170);
			g->drawImage(use_image(DATA_STAGE2), 440, 170);
			g->setBright(255);
			g->drawImage(use_image(DATA_STAGE), 222, 162, 0, 0, 196, 196);
			g->drawImage(use_image(DATA_STAGE1), 230, 170);
			break;
		case 1:
			g->setBright(127);
			g->drawImage(use_image(DATA_STAGE1), 20, 170);
			g->drawImage(use_image(DATA_STAGE3), 440, 170);
			g->setBright(255);
			g->drawImage(use_image(DATA_STAGE), 222, 162, 0, 0, 196, 196);
			g->drawImage(use_image(DATA_STAGE2), 230, 170);
			break;
		case 2:
			g->setBright(127);
			g->drawImage(use_image(DATA_STAGE2), 20, 170);
			g->drawImage(use_image(DATA_STAGE1), 440, 170);
			g->setBright(255);
			g->drawImage(use_image(DATA_STAGE), 222, 162, 0, 0, 196, 196);
			g->drawImage(use_image(DATA_STAGE3), 230, 170);
			break;
		}
		{
			int tmp = m_elapse % WAIT_H;
			if ( tmp < WAIT_Q ) {
				g->setScale(1.0 + (double)tmp * 1.0 / (double)WAIT_Q);
			} else {
				g->setScale(1.0 + (double)(WAIT_H - tmp) * 1.0 / (double)WAIT_Q);
			}
			g->drawImage(use_image(DATA_STAGE), 192, 251, 1, 481, 10, 18);
			g->drawImage(use_image(DATA_STAGE), 438, 251, 12, 481, 10, 18);
			g->setScale(1.0);
		}
		g->drawImage(use_image(DATA_FONT_LARGE), 320 - 306 / 2, 35, 0, FONT_L_H, 306, FONT_L_H);
		g->drawImage(use_image(DATA_FONT_SMALL), 320 - FONT_S_HISCORE_W / 2, 380, FONT_S_HISCORE_X, 0, FONT_S_HISCORE_W, FONT_S_H);
		if ( hi_score[level][st_index] == 0 ) {
			g->drawImage(use_image(DATA_FONT_SMALL), 320 - FONT_S_NULL_W / 2, 420, FONT_S_NULL_X, 0, FONT_S_NULL_W, FONT_S_H);
			first = TRUE;
		} else {
			centerDrawScoreS(hi_score[level][st_index], 420);
			first = FALSE;
		}

		if ( (key & button[0]) != 0 ) {
play_sound(SE_SELECT);

			if ( _replay ) {
				delete _replay;
			}
			_replay = new Replay();
			replay = FALSE;

			set_state(STATE_PLAY_LOAD);
		}
		break;
	case STATE_SELECTREPLAY2:
		g->setBright(((255 - m_elapse * 3) < 127) ? 127 : (255 - m_elapse * 3));
		g->drawImage(use_image(DATA_BACK_COM), 0, 0);
		g->setBright(255);

		if ( select_replay >= 0 ) {
//			g->drawImage(use_image(DATA_FONT_SMALL), 539 - FONT_S_PAGE2_W, 10, FONT_S_PAGE2_X, FONT_S_H, FONT_S_PAGE2_W, FONT_S_H);
			g->drawImage(use_image(DATA_FONT_SMALL), 539 - FONT_S_PAGE1_W, 10, FONT_S_PAGE1_X, 0, FONT_S_PAGE1_W, FONT_S_H);
			drawScoreS((select_replay / 10) + 1, 570, 10);
			g->drawImage(use_image(DATA_FONT_SMALL), 575, 10, FONT_S_REPLAYSEP_X, FONT_S_H, FONT_S_REPLAYSEP_W, FONT_S_H);
			drawScoreS(((replay_data->size() - 1) / 10) + 1, 620, 10);
			ReplayData* tmp;
			int top = (select_replay / 10) * 10;
			for ( i = 0; i < 10; i++ ) {
				j = 50 + i * 40;
				if ( (top + i) == select_replay ) {
					g->drawImage(use_image(DATA_SELECT), 40, j);
				}
				if ( (tmp = (ReplayData*)replay_data->elementAt(top + i)) != NULL ) {
					if ( tmp->error ) {
						g->drawImage(use_image(DATA_FONT_SMALL), 320 - FONT_S_REPLAYERR_W / 2, j, FONT_S_REPLAYERR_X, FONT_S_H, FONT_S_REPLAYERR_W, FONT_S_H);
					} else {
						switch ( tmp->level ) {
						case 0: g->drawImage(use_image(DATA_FONT_LEV_1), 100, j + 2, FONT_LEV_S_NORMAL_X, FONT_LEV_H, FONT_LEV_S_NORMAL_W, FONT_LEV_S_H); break;
						case 1: g->drawImage(use_image(DATA_FONT_LEV_1), 100, j + 2, FONT_LEV_S_HARD_X  , FONT_LEV_H, FONT_LEV_S_HARD_W  , FONT_LEV_S_H); break;
						case 2: g->drawImage(use_image(DATA_FONT_LEV_1), 100, j + 2, FONT_LEV_S_EXTRA_X , FONT_LEV_H, FONT_LEV_S_EXTRA_W , FONT_LEV_S_H); break;
						case 3: g->drawImage(use_image(DATA_FONT_LEV_2), 100, j + 2, FONT_LEV_S_NORMAL_X, FONT_LEV_H, FONT_LEV_S_NORMAL_W, FONT_LEV_S_H); break;
						case 4: g->drawImage(use_image(DATA_FONT_LEV_2), 100, j + 2, FONT_LEV_S_HARD_X  , FONT_LEV_H, FONT_LEV_S_HARD_W  , FONT_LEV_S_H); break;
						case 5: g->drawImage(use_image(DATA_FONT_LEV_2), 100, j + 2, FONT_LEV_S_EXTRA_X , FONT_LEV_H, FONT_LEV_S_EXTRA_W , FONT_LEV_S_H); break;
						case 6: g->drawImage(use_image(DATA_FONT_LEV_3), 100, j + 2, FONT_LEV_S_NORMAL_X, FONT_LEV_H, FONT_LEV_S_NORMAL_W, FONT_LEV_S_H); break;
						case 7: g->drawImage(use_image(DATA_FONT_LEV_3), 100, j + 2, FONT_LEV_S_HARD_X  , FONT_LEV_H, FONT_LEV_S_HARD_W  , FONT_LEV_S_H); break;
						case 8: g->drawImage(use_image(DATA_FONT_LEV_3), 100, j + 2, FONT_LEV_S_EXTRA_X , FONT_LEV_H, FONT_LEV_S_EXTRA_W , FONT_LEV_S_H); break;
						}
						g->drawImage(use_image(DATA_FONT_SMALL), 185, j, FONT_S_REPLAYSEP_X, FONT_S_H, FONT_S_REPLAYSEP_W, FONT_S_H);
						switch ( tmp->st_index ) {
						case 0: g->drawImage(use_image(DATA_FONT_SMALL), 245 - FONT_S_RAY_W, j, FONT_S_RAY_X, 0, FONT_S_RAY_W, FONT_S_H); break;
						case 1: g->drawImage(use_image(DATA_FONT_SMALL), 245 - FONT_S_RAX_W, j, FONT_S_RAX_X, 0, FONT_S_RAX_W, FONT_S_H); break;
						case 2: g->drawImage(use_image(DATA_FONT_SMALL), 245 - FONT_S_EXE_W, j, FONT_S_EXE_X, 0, FONT_S_EXE_W, FONT_S_H); break;
						}
						g->drawImage(use_image(DATA_FONT_SMALL), 250, j, FONT_S_STAGE_X, 0, FONT_S_STAGE_W, FONT_S_H);
						g->drawImage(use_image(DATA_FONT_SMALL), 315, j, FONT_S_REPLAYSEP_X, FONT_S_H, FONT_S_REPLAYSEP_W, FONT_S_H);
						g->drawImage(use_image(DATA_FONT_SMALL), 335, j, FONT_S_SCORE_X, 0, FONT_S_SCORE_W, FONT_S_H);
						drawScoreS(tmp->score, 480, j);
						g->drawImage(use_image(DATA_FONT_SMALL), 490, j, FONT_S_REPLAYSEP_X, FONT_S_H, FONT_S_REPLAYSEP_W, FONT_S_H);
						g->setColor(COLOR_K);
						g->drawString(tmp->name->str(), 515, j + 31);
						g->drawString(tmp->name->str(), 516, j + 31);
						g->setColor(COLOR_W);
						g->drawString(tmp->name->str(), 515, j + 30);
					}
				}
			}
		} else {
			int tmp = m_elapse % WAIT_H;
			if ( tmp < WAIT_Q ) {
				g->setScale(1.0 + (double)tmp * 0.1 / (double)WAIT_Q);
			} else {
				g->setScale(1.0 + (double)(WAIT_H - tmp) * 0.1 / (double)WAIT_Q);
			}
			g->drawImage(use_image(DATA_FONT_SMALL), 320 - FONT_S_REPLAYNAI_W / 2, 220, FONT_S_REPLAYNAI_X, FONT_S_H, FONT_S_REPLAYNAI_W, FONT_S_H);
			g->setScale(1.0);
		}

		if ( replay_white ) {
			g->setAlpha(255 - (((m_elapse * 4) > 255) ? 255 : (m_elapse * 4)));
			g->drawImage(use_image(DATA_WHITE), 0, 0);
			g->setAlpha(255);
		}

		if ( select_replay >= 0 ) {
			if ( (key & button[0]) != 0 ) {
				ReplayData* tmp = (ReplayData*)replay_data->elementAt(select_replay);
				if ( _replay->check(tmp->file) ) {
play_sound(SE_SELECT);
					if ( !save_replay ) {
						save_level = level;
						save_st_index = st_index;
						save_replay = TRUE;
					}
					_String* name = new _String("");
					if ( _replay->load(tmp->file, name, &level, &st_index, &score) ) {
						replay = TRUE;
						set_state(STATE_PLAY_LOAD);
					}
					delete name;
				}
			}
		}
		break;
	case STATE_SCORE2:
		g->setBright(((255 - m_elapse * 3) < 127) ? 127 : (255 - m_elapse * 3));
		g->drawImage(use_image(DATA_BACK_COM), 0, 0);
		g->setBright(255);
		if ( extra() ) {
			g->drawImage(use_image(DATA_STAGE1), 150, 20, 0,  0, 130, 130);
			g->drawImage(use_image(DATA_STAGE2), 310, 20, 0, 50, 130, 130);
			g->drawImage(use_image(DATA_STAGE3), 470, 20, 0,  0, 130, 130);
			g->drawImage(use_image(DATA_FONT_LEV_1), 130 - FONT_LEV_NORMAL_W, 160, FONT_LEV_NORMAL_X, 0, FONT_LEV_NORMAL_W, FONT_LEV_H);
			g->drawImage(use_image(DATA_FONT_LEV_1), 130 - FONT_LEV_HARD_W  , 195, FONT_LEV_HARD_X  , 0, FONT_LEV_HARD_W  , FONT_LEV_H);
			g->drawImage(use_image(DATA_FONT_LEV_1), 130 - FONT_LEV_EXTRA_W , 230, FONT_LEV_EXTRA_X , 0, FONT_LEV_EXTRA_W , FONT_LEV_H);
			g->drawImage(use_image(DATA_FONT_LEV_2), 130 - FONT_LEV_NORMAL_W, 265, FONT_LEV_NORMAL_X, 0, FONT_LEV_NORMAL_W, FONT_LEV_H);
			g->drawImage(use_image(DATA_FONT_LEV_2), 130 - FONT_LEV_HARD_W  , 300, FONT_LEV_HARD_X  , 0, FONT_LEV_HARD_W  , FONT_LEV_H);
			g->drawImage(use_image(DATA_FONT_LEV_2), 130 - FONT_LEV_EXTRA_W , 335, FONT_LEV_EXTRA_X , 0, FONT_LEV_EXTRA_W , FONT_LEV_H);
			g->drawImage(use_image(DATA_FONT_LEV_3), 130 - FONT_LEV_NORMAL_W, 370, FONT_LEV_NORMAL_X, 0, FONT_LEV_NORMAL_W, FONT_LEV_H);
			g->drawImage(use_image(DATA_FONT_LEV_3), 130 - FONT_LEV_HARD_W  , 405, FONT_LEV_HARD_X  , 0, FONT_LEV_HARD_W  , FONT_LEV_H);
			g->drawImage(use_image(DATA_FONT_LEV_3), 130 - FONT_LEV_EXTRA_W , 440, FONT_LEV_EXTRA_X , 0, FONT_LEV_EXTRA_W , FONT_LEV_H);
		} else {
			g->drawImage(use_image(DATA_STAGE1), 150, 90, 0,  0, 130, 130);
			g->drawImage(use_image(DATA_STAGE2), 310, 90, 0, 50, 130, 130);
			g->drawImage(use_image(DATA_STAGE3), 470, 90, 0,  0, 130, 130);
			g->drawImage(use_image(DATA_FONT_LEV_1), 130 - FONT_LEV_NORMAL_W, 280, FONT_LEV_NORMAL_X, 0, FONT_LEV_NORMAL_W, FONT_LEV_H);
			g->drawImage(use_image(DATA_FONT_LEV_1), 130 - FONT_LEV_HARD_W  , 340, FONT_LEV_HARD_X  , 0, FONT_LEV_HARD_W  , FONT_LEV_H);
		}
		for ( i = 0; i < STAGE_NUM; i++ ) {
			j = 270 + i * 160;
			if ( extra() ) {
				if ( hi_score[0][i] == 0 ) {
					g->drawImage(use_image(DATA_FONT_SMALL), j - FONT_S_NULL_W, 164, FONT_S_NULL_X, 0, FONT_S_NULL_W, FONT_S_H);
				} else {
					drawScoreS(hi_score[0][i], j, 164);
				}
				if ( hi_score[1][i] == 0 ) {
					g->drawImage(use_image(DATA_FONT_SMALL), j - FONT_S_NULL_W, 199, FONT_S_NULL_X, 0, FONT_S_NULL_W, FONT_S_H);
				} else {
					drawScoreS(hi_score[1][i], j, 199);
				}
				if ( hi_score[2][i] == 0 ) {
					g->drawImage(use_image(DATA_FONT_SMALL), j - FONT_S_NULL_W, 234, FONT_S_NULL_X, 0, FONT_S_NULL_W, FONT_S_H);
				} else {
					drawScoreS(hi_score[2][i], j, 234);
				}
				if ( hi_score[3][i] == 0 ) {
					g->drawImage(use_image(DATA_FONT_SMALL), j - FONT_S_NULL_W, 269, FONT_S_NULL_X, 0, FONT_S_NULL_W, FONT_S_H);
				} else {
					drawScoreS(hi_score[3][i], j, 269);
				}
				if ( hi_score[4][i] == 0 ) {
					g->drawImage(use_image(DATA_FONT_SMALL), j - FONT_S_NULL_W, 304, FONT_S_NULL_X, 0, FONT_S_NULL_W, FONT_S_H);
				} else {
					drawScoreS(hi_score[4][i], j, 304);
				}
				if ( hi_score[5][i] == 0 ) {
					g->drawImage(use_image(DATA_FONT_SMALL), j - FONT_S_NULL_W, 339, FONT_S_NULL_X, 0, FONT_S_NULL_W, FONT_S_H);
				} else {
					drawScoreS(hi_score[5][i], j, 339);
				}
				if ( hi_score[6][i] == 0 ) {
					g->drawImage(use_image(DATA_FONT_SMALL), j - FONT_S_NULL_W, 374, FONT_S_NULL_X, 0, FONT_S_NULL_W, FONT_S_H);
				} else {
					drawScoreS(hi_score[6][i], j, 374);
				}
				if ( hi_score[7][i] == 0 ) {
					g->drawImage(use_image(DATA_FONT_SMALL), j - FONT_S_NULL_W, 409, FONT_S_NULL_X, 0, FONT_S_NULL_W, FONT_S_H);
				} else {
					drawScoreS(hi_score[7][i], j, 409);
				}
				if ( hi_score[8][i] == 0 ) {
					g->drawImage(use_image(DATA_FONT_SMALL), j - FONT_S_NULL_W, 444, FONT_S_NULL_X, 0, FONT_S_NULL_W, FONT_S_H);
				} else {
					drawScoreS(hi_score[8][i], j, 444);
				}
			} else {
				if ( hi_score[0][i] == 0 ) {
					g->drawImage(use_image(DATA_FONT_SMALL), j - FONT_S_NULL_W, 284, FONT_S_NULL_X, 0, FONT_S_NULL_W, FONT_S_H);
				} else {
					drawScoreS(hi_score[0][i], j, 284);
				}
				if ( hi_score[1][i] == 0 ) {
					g->drawImage(use_image(DATA_FONT_SMALL), j - FONT_S_NULL_W, 344, FONT_S_NULL_X, 0, FONT_S_NULL_W, FONT_S_H);
				} else {
					drawScoreS(hi_score[1][i], j, 344);
				}
			}
		}
		break;
	case STATE_PLAY_LOAD:
		g->setBright(127);
		g->drawImage(use_image(DATA_BACK_COM), 0, 0);
		g->setBright(255);
		if ( !replay ) {
			g->drawImage(use_image(DATA_STAGE), 222, 162, 0, 0, 196, 196);
			switch ( st_index ) {
			case 0:
				g->drawImage(use_image(DATA_STAGE1), 230, 170);
				break;
			case 1:
				g->drawImage(use_image(DATA_STAGE2), 230, 170);
				break;
			case 2:
				g->drawImage(use_image(DATA_STAGE3), 230, 170);
				break;
			}
		}
		g->setAlpha(((m_elapse * 4) > 255) ? 255 : (m_elapse * 4));
		g->drawImage(use_image(DATA_WHITE), 0, 0);
		g->setAlpha(255);
		if ( (m_elapse * 4) >= 255 ) {
			set_state(STATE_PLAY_MAIN);
		}
		break;
	case STATE_PLAY_LOAD2:
		set_state(STATE_PLAY_MAIN2);
		// ̂܂܉ɗ
	case STATE_PLAY_MAIN:
	case STATE_PLAY_BOSS:
	case STATE_PLAY_MAIN2:
	case STATE_PLAY_BOSS2:
if ( !pause ) {
		if ( replay ) {
			// vCf[^ǂݍ
			UINT tmp;
			_replay->get_key(&tmp);
			key = 0;
			if ( (tmp & REPLAY_DOWN   ) != 0 ) key |= _KEY_DOWN;
			if ( (tmp & REPLAY_LEFT   ) != 0 ) key |= _KEY_LEFT;
			if ( (tmp & REPLAY_RIGHT  ) != 0 ) key |= _KEY_RIGHT;
			if ( (tmp & REPLAY_UP     ) != 0 ) key |= _KEY_UP;
			if ( (tmp & REPLAY_BUTTON1) != 0 ) key |= button[0];
			if ( (tmp & REPLAY_BUTTON2) != 0 ) key |= button[1];
			if ( (tmp & REPLAY_BUTTON3) != 0 ) key |= button[2];
			if ( (tmp & REPLAY_BUTTON4) != 0 ) key |= button[3];
			if ( (tmp & REPLAY_BUTTON5) != 0 ) key |= button[4];
			if ( (tmp & REPLAY_BUTTON6) != 0 ) key |= button[5];
			_replay->get_opt(
				&request_lock,
				&request_color_0,
				&request_color_1,
				&request_color_2,
				&request_dash
				);
		} else {
			// vCf[^ɏ
			UINT tmp = 0;
			if ( (key & _KEY_DOWN ) != 0 ) tmp |= REPLAY_DOWN;
			if ( (key & _KEY_LEFT ) != 0 ) tmp |= REPLAY_LEFT;
			if ( (key & _KEY_RIGHT) != 0 ) tmp |= REPLAY_RIGHT;
			if ( (key & _KEY_UP   ) != 0 ) tmp |= REPLAY_UP;
			if ( (key & button[0] ) != 0 ) tmp |= REPLAY_BUTTON1;
			if ( (key & button[1] ) != 0 ) tmp |= REPLAY_BUTTON2;
			if ( (key & button[2] ) != 0 ) tmp |= REPLAY_BUTTON3;
			if ( (key & button[3] ) != 0 ) tmp |= REPLAY_BUTTON4;
			if ( (key & button[4] ) != 0 ) tmp |= REPLAY_BUTTON5;
			if ( (key & button[5] ) != 0 ) tmp |= REPLAY_BUTTON6;
			_replay->add_key(tmp);
			_replay->add_opt(
				request_lock,
				request_color_0,
				request_color_1,
				request_color_2,
				request_dash
				);
		}

		if ( request_lock ) {
			request_lock = FALSE;
			_target = 0;
			for ( i = enemy->size() - 1; i >= 0; i-- ) {
				Enemy* tmp = (Enemy*)enemy->elementAt(i);
				if ( tmp->_lock ) {
					tmp->_lock = FALSE;
				}
			}
			if ( !(jiki->check_special()) ) {
				_target_old = 0;
				lock_enemy();
			}
		}
		if ( request_color_0 ) {
			request_color_0 = FALSE;
			if ( jiki->_color == 0 ) {
				jiki->special();
			} else {
				jiki->color(0);
			}
		}
		if ( request_color_1 ) {
			request_color_1 = FALSE;
			if ( jiki->_color == 1 ) {
				jiki->special();
			} else {
				jiki->color(1);
			}
		}
		if ( request_color_2 ) {
			request_color_2 = FALSE;
			if ( jiki->_color == 2 ) {
				jiki->special();
			} else {
				jiki->color(2);
			}
		}
		if ( request_dash ) {
			request_dash = FALSE;
			jiki->dash();
		}

		if ( (script_reader != NULL) && (m_elapse == script_frame) ) {
			int t, x, y, c, l;
			for ( ; ; ) {
				script_tmp = script_reader->read();
				if ( script_tmp->length() <= 0 ) {
					delete script_tmp;
					GlobalFree(script_in);
					delete script_reader;
					script_reader = NULL;
					break;
				}
				if ( script_tmp->str()[0] == 'S' ) {
					delete script_tmp;
					st_step++;
					if ( (st_index == 1) && (st_step == 4) ) {
						awa->removeAllElements();
						dispose_image(DATA_AWA);
play_sound(SE_SURFACE);
					}
				} else if ( script_tmp->str()[0] == 'E' ) {
					delete script_tmp;
					t = script_reader->read_val();
					x = script_reader->read_val();
					y = script_reader->read_val();
					c = script_reader->read_val();
					l = 0;
					switch ( t ) {
					case ENEMY_ZAKO_1  : l = 10; break;
					case ENEMY_ZAKO_2  : l = 10; break;
					case ENEMY_ZAKO_3  : l = 20; break;
					case ENEMY_ZAKO_4  : l = 10; break;
					case ENEMY_ZAKO_5  : l = 30; break;
					case ENEMY_ZAKO_6_1: l = 10; break;
					}
					if ( (level / 3) == 2 ) {
						next_color(&enemy_color);
						c = enemy_color;
					}
					enemy->addElement(new Enemy(t, x * 8 / 3, y * 2, c, l));
				} else {
					script_frame += script_tmp->parseInt() * 4;
					delete script_tmp;
					break;
				}
			}
		}

		// @̈ړ
		BOOL stop = TRUE;
		if ( (key & button[3]) == 0 ) {
			jiki->_dash = FALSE;
		}
		if ( (key & _KEY_DOWN ) != 0 ) {
			stop = FALSE;
			jiki->down ((((key & _KEY_LEFT) != 0) || ((key & _KEY_RIGHT) != 0)) ? TRUE : FALSE);
		}
		if ( (key & _KEY_LEFT ) != 0 ) {
			stop = FALSE;
			jiki->left ((((key & _KEY_DOWN) != 0) || ((key & _KEY_UP   ) != 0)) ? TRUE : FALSE);
		}
		if ( (key & _KEY_RIGHT) != 0 ) {
			stop = FALSE;
			jiki->right((((key & _KEY_DOWN) != 0) || ((key & _KEY_UP   ) != 0)) ? TRUE : FALSE);
		}
		if ( (key & _KEY_UP   ) != 0 ) {
			stop = FALSE;
			jiki->up   ((((key & _KEY_LEFT) != 0) || ((key & _KEY_RIGHT) != 0)) ? TRUE : FALSE);
		}
		if ( stop ) {
			jiki->_dash_dx = 0;
			jiki->_dash_dy = 0;
		} else {
			jiki->move_dash();
		}
		if ( stop && !jiki->check_muteki() ) {
			jiki->add_dash_power();
		}
		if ( jiki->_dash ) {
			jiki->_dash_power -= DASH_POWER;
			if ( jiki->_dash_power <= 0 ) {
				jiki->_dash_power = 0;
				jiki->_dash = FALSE;
			}
		}

		if ( (jiki->_life > 0) && !(jiki->check_special()) ) {
			// e
			if ( _target > 0 ) {
				if ( (m_elapse % 10) == 0 ) {
play_sound(SE_SHOT);
					jshot->addElement(new JikiShot(JSHOT_NORMAL, _target_x, _target_y));
				}
//			} else if ( !score_lock ) {
//				if ( (m_elapse % 5) == 0 ) {
//					add_score(1);
//				}
			}
		}

		// XV
		switch ( st_index ) {
		case 0:
			for ( i = 0; i < 480; i++ ) {
				scroll_update(i);
			}
			if ( jiki->_life > 0 ) {
				if ( (_target == 0) || (state == STATE_PLAY_BOSS) ) {
					st_coef_dist = ((jiki->x() / 2 + (416 - jiki->y()) / 2) * 500) / 496;
				} else {
					st_coef_dist = (((_target_x - 32) / 2 + (_target_y - 32) / 2) * 500) / 496;
				}
				if ( st_coef < st_coef_dist ) {
					if ( state == STATE_PLAY_BOSS2 ) {
						st_coef += 2;
					} else {
						st_coef++;
					}
				}
				if ( st_coef > st_coef_dist ) {
					if ( state == STATE_PLAY_BOSS2 ) {
						st_coef -= 2;
					} else {
						st_coef--;
					}
				}
				if ( st_coef < 0 ) {
					st_coef = 0;
				} else if ( st_coef > 500 ) {
					st_coef = 500;
				}
			}
			break;
		case 1:
			for ( i = 0; i < 722; i++ ) {
				scroll_update(i);
			}
			switch ( st_step ) {
			case 0:
				st_coef = 250;
				break;
			case 1:
				st_coef += 2;
				if ( st_coef > 500 ) {
					st_coef = 500;
				}
				if ( st_coef == 500 ) {
					st_step++;
					dispose_image(DATA_BACK2);
play_sound(SE_DIVE);
				}
				break;
			case 2:
				if ( (m_elapse % 10) == 0 ) {
					awa->addElement(new Awa(jiki->cx(), jiki->cy()));
				}
				st_coef -= 10;
				if ( st_coef < 0 ) {
					st_coef = 0;
				}
				if ( st_coef == 0 ) {
					st_step++;
					dispose_image(DATA_FORE2);
				}
				break;
			case 3:
				st_coef = 0;
				if ( jiki->_dash ) {
					if ( (m_elapse % 5) == 0 ) {
						awa->addElement(new Awa(jiki->cx(), jiki->cy()));
					}
				} else {
					if ( (m_elapse % 10) == 0 ) {
						if ( (_rand->nextInt() % 2) != 0 ) {
							awa->addElement(new Awa(jiki->cx(), jiki->cy()));
						}
					}
				}
				break;
			case 4:
				st_coef += 10;
				if ( st_coef > 500 ) {
					st_coef = 500;
				}
				if ( st_coef == 500 ) {
					st_step++;
					dispose_image(DATA_BACK3);
					dispose_image(DATA_FORE3);
				}
				break;
			case 5:
				st_coef -= 1;
				if ( st_coef < 250 ) {
					st_coef = 250;
				}
				if ( st_coef == 250 ) {
					st_step = 0;
				}
				break;
			}
			break;
		case 2:
			scroll_update(0);
			scroll_update(1);
			if ( st_step > 0 ) {
				if ( st_step < 100 ) {
					setVolumeMusic(100 - st_step);
				} else if ( st_step == 100 ) {
					stopMusic();
				}
				st_step++;
			}
			break;
		}
		jiki->update();
		for ( i = jshot->size() - 1; i >= 0; i-- ) {
			JikiShot* tmp = (JikiShot*)jshot->elementAt(i);
			if ( !(tmp->update()) ) {
				jshot->removeElementAt(i);
			}
		}
		for ( i = eshot->size() - 1; i >= 0; i-- ) {
			EnemyShot* tmp = (EnemyShot*)eshot->elementAt(i);
			if ( !(tmp->update()) ) {
				eshot->removeElementAt(i);
			}
		}
		for ( i = spark->size() - 1; i >= 0; i-- ) {
			Spark* tmp = (Spark*)spark->elementAt(i);
			if ( !(tmp->update()) ) {
				spark->removeElementAt(i);
			}
		}
		for ( i = tame->size() - 1; i >= 0; i-- ) {
			Tame* tmp = (Tame*)tame->elementAt(i);
			if ( !(tmp->update()) ) {
				tame->removeElementAt(i);
			}
		}
		for ( i = awa->size() - 1; i >= 0; i-- ) {
			Awa* tmp = (Awa*)awa->elementAt(i);
			if ( !(tmp->update()) ) {
				awa->removeElementAt(i);
			}
		}
		for ( i = burst->size() - 1; i >= 0; i-- ) {
			Burst* tmp = (Burst*)burst->elementAt(i);
			if ( !(tmp->update()) ) {
				burst->removeElementAt(i);
			}
		}
		for ( i = enemy->size() - 1; i >= 0; i-- ) {
			Enemy* tmp = (Enemy*)enemy->elementAt(i);
			if ( tmp->update() ) {
				switch ( tmp->_type ) {
				case ENEMY_ZAKO_6_2:
				case ENEMY_BOSS_1:
				case ENEMY_BOSS_2:
				case ENEMY_BOSS_3_1:
				case ENEMY_BOSS_3_2:
				case ENEMY_RAY:
				case ENEMY_RAX:
				case ENEMY_EXE:
					break;
				default:
					if ( (m_elapse % 5) == 0 ) {
						add_score(1);
					}
					break;
				}
			} else {
				enemy->removeElementAt(i);
			}
		}

		// bNĂG𒲂ׂ
		_target_old = _target;
		_target = 0;
		for ( i = enemy->size() - 1; i >= 0; i-- ) {
			Enemy* tmp = (Enemy*)enemy->elementAt(i);
			if ( tmp->_lock ) {
				break;
			}
		}
		if ( (i < 0) && !(jiki->check_special()) ) {
			_target_old = 0;
			lock_enemy();
		}
		for ( i = enemy->size() - 1; i >= 0; i-- ) {
			Enemy* tmp = (Enemy*)enemy->elementAt(i);
			if ( tmp->_lock ) {
				_target_x = tmp->cx();
				_target_y = tmp->cy();
				int w = _target_x - jiki->cx();
				int h = _target_y - jiki->cy();
				if ( ((level / 3) != 1) && ((w * w + h * h) < 12800/*80 * 80 + 80 * 80*/) ) {
					if ( _target_old < 2 ) {
play_sound(SE_LOCKON);
					}
					_target = 2;
				} else {
					if ( _target_old < 1 ) {
play_sound(SE_LOCKON);
					}
					_target = 1;
				}
				break;
			}
		}
}

		// wi̕`
		switch ( st_index ) {
		case 0:
			g->drawImage(use_image(DATA_BACK1_1), 0, 0 - (st_coef * 480) / 500);
			g->lockDraw();
			for ( i = 0; i < 480; i++ ) {
				scroll_draw(i, DATA_FORE1, i + (480 - i) * (500 - st_coef) / 500);
			}
			g->unlockDraw();
			break;
		case 1:
			switch ( st_step ) {
			case 0:
			case 1:
			case 5:
				g->drawImage(use_image(DATA_BACK2), 0, 0 - ((st_coef * 480) / 500 - 240));
				g->lockDraw();
				for ( i = 0; i < 480; i++ ) {
					scroll_draw(i, DATA_FORE2, i + (480 - i) * (500 - st_coef) / 500);
				}
				g->unlockDraw();
				break;
			case 2:
			case 3:
			case 4:
				g->drawImage(use_image(DATA_BACK3), 0, 240);
				g->lockDraw();
				for ( i = 0; i < 240; i++ ) {
					scroll_draw(i + 480, DATA_FORE3, i);
				}
				g->unlockDraw();
				if ( st_step != 3 ) {
					g->lockDraw();
					for ( i = 0; i < 480; i++ ) {
						scroll_draw(i, DATA_FORE2, i + (480 - i) * (500 - st_coef) / 500 - ((500 - st_coef) * 480) / 500);
					}
					if ( (elapse() % 2) == 0 ) {
						scroll_draw(720, DATA_FORE2, ((st_step == 2) ? 460 : 480) - ((500 - st_coef) * 480) / 500);
					} else {
						scroll_draw(721, DATA_FORE2, ((st_step == 2) ? 460 : 480) - ((500 - st_coef) * 480) / 500);
					}
					g->unlockDraw();
				}
				break;
			}
			break;
		case 2:
			if ( st_step > 0 ) {
				g->drawImage(use_image(DATA_BACK4), 0, 0);
			}
			if ( st_step < 255 ) {
				g->setAlpha(255 - st_step);
				g->setBright(127);
				scroll_draw(0, DATA_FORE4, 0);
				g->setROP(_ROP_ADD);
				scroll_draw(1, DATA_FORE5, 0);
				g->setROP(_ROP_COPY);
				g->setBright(255);
				g->setAlpha(255);
			}
			break;
		}

		for ( i = awa->size() - 1; i >= 0; i-- ) {
			Awa* tmp = (Awa*)awa->elementAt(i);
			tmp->draw();
		}
		for ( i = burst->size() - 1; i >= 0; i-- ) {
			Burst* tmp = (Burst*)burst->elementAt(i);
			tmp->draw();
		}
		for ( i = enemy->size() - 1; i >= 0; i-- ) {
			Enemy* tmp = (Enemy*)enemy->elementAt(i);
			tmp->draw();
		}
		if ( (jiki->_life > 0) && (_target > 0) ) {
			g->setROP(_ROP_ADD);
			if ( (level / 3) == 1 ) {
				g->drawImage(use_image(DATA_LOCK), _target_x - 32, _target_y - 32, 0, 0, 64, 64);
			} else {
				g->drawImage(use_image(DATA_LOCK), _target_x - 32, _target_y - 32, ((_target - 1) * 64), 0, 64, 64);
			}
			g->setROP(_ROP_COPY);
		}
		jiki->draw();
		{
			JikiShot* tmp;
			int top = -1;
			int end = -1;
			for ( i = jshot->size() - 1; i >= 0; i-- ) {
				tmp = (JikiShot*)jshot->elementAt(i);
				if ( tmp->_type == JSHOT_SPECIAL ) {
					if ( end == -1 ) {
						end = i;
					}
					top = i;
				}
			}
			if ( (top >= 0) && (end >= 0) ) {
				tmp = (JikiShot*)jshot->elementAt(end);
				JikiShot* tmp2 = (JikiShot*)jshot->elementAt(top);
				int xx = tmp2->_x - tmp->_x;
				int yy = tmp2->_y - tmp->_y;
				int w = (int)sqrt((double)(xx * xx + yy * yy)) + 48;
				g->setRot(jiki->_special_r);
				g->drawImage(use_image(DATA_SPECIAL), tmp->cx() - 24, tmp->cy() - 24, 0, tmp->_color * 48, w, 48, 24.0f, 24.0f);
				g->setRot(0.0);
			}
		}
		for ( i = jshot->size() - 1; i >= 0; i-- ) {
			JikiShot* tmp = (JikiShot*)jshot->elementAt(i);
			tmp->draw();
		}
		for ( i = spark->size() - 1; i >= 0; i-- ) {
			Spark* tmp = (Spark*)spark->elementAt(i);
			tmp->draw();
		}
		for ( i = tame->size() - 1; i >= 0; i-- ) {
			Tame* tmp = (Tame*)tame->elementAt(i);
			tmp->draw();
		}
		for ( i = eshot->size() - 1; i >= 0; i-- ) {
			EnemyShot* tmp = (EnemyShot*)eshot->elementAt(i);
			if ( tmp->_color < 3 ) {
				tmp->draw();
			}
		}
		for ( i = eshot->size() - 1; i >= 0; i-- ) {
			EnemyShot* tmp = (EnemyShot*)eshot->elementAt(i);
			if ( tmp->_color == 3 ) {
				tmp->draw();
			}
		}

		if ( st_index == 0 ) {
			if ( st_coef < 80 ) {
				int coef = 200 + st_coef * 2 / 5;
				g->setROP(_ROP_ADD);
				g->setAlpha(127);
				g->drawImage(use_image(DATA_BACK1_2),
					(-70 + 10 * coef / 25) * 4,
					(-80 + 10 * coef / 19) * 2,
					0, 0, 30, 30
					);
				g->drawImage(use_image(DATA_BACK1_2),
					(-148 + 20 * coef / 25) * 4,
					(-160 + 20 * coef / 19) * 2,
					0, 30, 20, 20
					);
				g->drawImage(use_image(DATA_BACK1_2),
					(-164 + 22 * coef / 25) * 4,
					(-176 + 22 * coef / 19) * 2,
					0, 50, 40, 40
					);
				g->drawImage(use_image(DATA_BACK1_2),
					(-305 + 40 * coef / 25) * 4,
					(-320 + 40 * coef / 19) * 2,
					40, 0, 80, 80
					);
				g->setAlpha(255);
				g->setROP(_ROP_COPY);
			}
		}

		// XRA`
		{
			BOOL top = TRUE;
			int alpha = 256;
			if ( jiki->cy() < 240 ) {
				top = FALSE;
				for ( i = enemy->size() - 1; i >= 0; i-- ) {
					Enemy* tmp = (Enemy*)enemy->elementAt(i);
					if ( tmp->bottom() > 408 ) {
						alpha = 160;
						break;
					}
				}
			} else {
				for ( i = enemy->size() - 1; i >= 0; i-- ) {
					Enemy* tmp = (Enemy*)enemy->elementAt(i);
					if ( tmp->top() < 72 ) {
						alpha = 160;
						break;
					}
				}
			}
			g->setAlpha(alpha - 1);
			g->drawImage(use_image(DATA_FONT_SMALL), 0, top ? 0 : (480 - FONT_S_H), FONT_S_SCORE_X, 0, FONT_S_SCORE_W, FONT_S_H);
			drawScoreS(score, 240, top ? 0 : (480 - FONT_S_H));
			g->setAlpha(alpha / 4 - 1);
			g->drawImage(use_image(DATA_BAR), 0, top ? 26 : 440, 256 - 242, 42, 242, 14);
			g->drawImage(use_image(DATA_BAR), 0, top ? 42 : 424, 256 - 242, 42, 242, 14);
			g->drawImage(use_image(DATA_BAR), 0, top ? 58 : 408, 256 - 242, 42, 242, 14);
			g->setAlpha(alpha - 1);
			if ( jiki->_life > 0 ) {
				int w;
				w = 242 * jiki->_life / JIKI_LIFE_MAX;
				g->drawImage(use_image(DATA_BAR), 0, top ? 26 : 440, 256 - w, 0, w, 14);
			}
			if ( jiki->_special_power > 0 ) {
				int w;
				w = 242 * jiki->_special_power / SPECIAL_POWER_MAX;
				if ( (jiki->_special_power == SPECIAL_POWER_MAX) || jiki->_special ) {
					g->drawImage(use_image(DATA_BAR), 0, top ? 42 : 424, 256 - w, 14 * ((elapse() / 5) % 3), w, 14);
				} else {
					g->drawImage(use_image(DATA_BAR), 0, top ? 42 : 424, 256 - w, 14, w, 14);
				}
			}
			if ( jiki->_dash_power > 0 ) {
				int w;
				w = 242 * jiki->_dash_power / DASH_POWER_MAX;
				g->drawImage(use_image(DATA_BAR), 0, top ? 58 : 408, 256 - w, 56, w, 14);
			}
			if ( (state == STATE_PLAY_BOSS) || (state == STATE_PLAY_BOSS2) ) {
				if ( state == STATE_PLAY_BOSS2 ) {
					switch ( st_index ) {
					case 0:
						g->drawImage(use_image(DATA_FONT_SMALL), 640 - FONT_S_RAY_W, top ? 0 : (480 - FONT_S_H), FONT_S_RAY_X, 0, FONT_S_RAY_W, FONT_S_H);
						break;
					case 1:
						g->drawImage(use_image(DATA_FONT_SMALL), 640 - FONT_S_RAX_W, top ? 0 : (480 - FONT_S_H), FONT_S_RAX_X, 0, FONT_S_RAX_W, FONT_S_H);
						break;
					case 2:
						g->drawImage(use_image(DATA_FONT_SMALL), 640 - FONT_S_EXE_W, top ? 0 : (480 - FONT_S_H), FONT_S_EXE_X, 0, FONT_S_EXE_W, FONT_S_H);
						break;
					}
				}
				if ( (state == STATE_PLAY_BOSS2) || (enemy->size() > 0) ) {
					g->setAlpha(alpha / 4 - 1);
					g->drawImage(use_image(DATA_BAR), 436, top ? 26 : 440, 256 - 202, 42, 202, 14);
					g->setAlpha(alpha - 1);
				}
				if ( enemy->size() > 0 ) {
					Enemy* tmp = (Enemy*)enemy->elementAt(0);
					if ( tmp->_life > 0 ) {
						int w;
						w = 202 * tmp->_life / tmp->_life_max;
						g->drawImage(use_image(DATA_BAR), 436, top ? 26 : 440, 256 - w, 28, w, 14);
					}
				}
				if ( (state == STATE_PLAY_BOSS) && (st_index == 2) ) {
					if ( enemy->size() > 1 ) {
						g->setAlpha(alpha / 4 - 1);
						g->drawImage(use_image(DATA_BAR), 436, top ? 42 : 424, 256 - 202, 42, 202, 14);
						g->setAlpha(alpha - 1);
						Enemy* tmp = (Enemy*)enemy->elementAt(1);
						if ( tmp->_life > 0 ) {
							int w;
							w = 202 * tmp->_life / tmp->_life_max;
							g->drawImage(use_image(DATA_BAR), 436, top ? 42 : 424, 256 - w, 28, w, 14);
						}
					}
				}
			}
			g->setAlpha(255);
		}

		if ( (state == STATE_PLAY_MAIN) && ((m_elapse * 4) < 255) ) {
			g->setAlpha(255 - (m_elapse * 4));
			g->drawImage(use_image(DATA_WHITE), 0, 0);
			g->setAlpha(255);
		}

		// |[Y̕`
		if ( pause && pause2 ) {
			g->setAlpha(((m_elapse_p * 3) > 127) ? 127 : (m_elapse_p * 3));
			g->drawImage(use_image(DATA_BLACK), 0, 0);
			g->setAlpha(255);
			if ( m_elapse_r == 0 ) {
				int tmp = m_elapse_p % WAIT_H;
				if ( tmp < WAIT_Q ) {
					g->setScale(1.0 + (double)tmp * 0.3 / (double)WAIT_Q);
				} else {
					g->setScale(1.0 + (double)(WAIT_H - tmp) * 0.3 / (double)WAIT_Q);
				}
				g->drawImage(use_image(DATA_FONT_SMALL), 320 - FONT_S_PAUSE_W / 2, 180, FONT_S_PAUSE_X, 0, FONT_S_PAUSE_W, FONT_S_H - 2);
				g->setScale(1.0);
			}
			if ( replay ) {
				g->drawImage(use_image(DATA_FONT_SMALL), 320 - FONT_S_SAIKAI_W / 2, 240, FONT_S_SAIKAI_X, FONT_S_H, FONT_S_SAIKAI_W, FONT_S_H);
				g->drawImage(use_image(DATA_FONT_SMALL), 320 - FONT_S_CYUUDAN_W / 2, 280, FONT_S_CYUUDAN_X, FONT_S_H, FONT_S_CYUUDAN_W, FONT_S_H);
				g->drawImage(use_image(DATA_SELECT), 240, (select_pause == 0) ? 240 : 280);
			} else {
				g->drawImage(use_image(DATA_FONT_SMALL), 320 - FONT_S_GAME_W / 2, 240, FONT_S_GAME_X, 0, FONT_S_GAME_W, FONT_S_H);
				g->drawImage(use_image(DATA_FONT_SMALL), 320 - FONT_S_TITLE_W / 2, 280, FONT_S_TITLE_X, 0, FONT_S_TITLE_W, FONT_S_H);
				g->drawImage(use_image(DATA_SELECT), 200, (select_pause == 0) ? 240 : 280);
			}
			if ( m_elapse_r > 0 ) {
				m_elapse_r++;
				g->setAlpha(((m_elapse_r * 4) > 255) ? 255 : (m_elapse_r * 4));
				g->drawImage(use_image(DATA_WHITE), 0, 0);
				g->setAlpha(255);
				if ( (m_elapse_r * 4) >= 255 ) {
					set_state(replay ? STATE_SELECTREPLAY : STATE_TITLE);
					break;
				}
			}
		}

if ( !pause ) {
		if ( jiki->_life < 0 ) {
			set_state(STATE_PLAY_GAMEOVER);
			break;
		}

		for ( i = jshot->size() - 1; i >= 0; i-- ) {
			JikiShot* tmp_s = (JikiShot*)jshot->elementAt(i);

			// eƓGeƂ̓蔻
			if ( (tmp_s->_type == JSHOT_SPECIAL) || (tmp_s->_type == JSHOT_SWORD) ) {
				for ( j = eshot->size() - 1; j >= 0; j-- ) {
					EnemyShot* tmp_e = (EnemyShot*)eshot->elementAt(j);
					if (
					(tmp_s->left  () <= tmp_e->right ()) &&
					(tmp_s->top   () <= tmp_e->bottom()) &&
					(tmp_s->right () >= tmp_e->left  ()) &&
					(tmp_s->bottom() >= tmp_e->top   ())
					) {
						eshot->removeElementAt(j);
					}
				}
			}

			// eƓGƂ̓蔻
			for ( int k = 0; k < 2; k++ ) {
				for ( j = enemy->size() - 1; j >= 0; j-- ) {
					Enemy* tmp_e = (Enemy*)enemy->elementAt(j);
					if ( !(tmp_e->destroyed()) && (tmp_e->_color < 3) ) {
						if (
						((k == 0) &&   tmp_e->_lock ) ||
						((k == 1) && !(tmp_e->_lock))
						) {
							if (
							(tmp_s->left  () <= tmp_e->right ()) &&
							(tmp_s->top   () <= tmp_e->bottom()) &&
							(tmp_s->right () >= tmp_e->left  ()) &&
							(tmp_s->bottom() >= tmp_e->top   ())
							) {
								if ( tmp_s->_color == tmp_e->_color ) {
									if ( tmp_e->damage(tmp_s->_power * 2, tmp_s->_type) ) {
										if ( tmp_s->_type == JSHOT_SPECIAL ) {
											add_score(tmp_s->_power * 20);
										} else {
											add_score(tmp_s->_power * 2);
										}
									}
								} else {
									if ( tmp_e->damage(tmp_s->_power, tmp_s->_type) ) {
										if ( tmp_s->_type == JSHOT_SPECIAL ) {
											add_score(tmp_s->_power * 10);
										} else {
											add_score(tmp_s->_power);
										}
									}
								}
								if ( !(tmp_e->destroyed()) ) {
stop_sound(SE_HIT);
play_sound(SE_HIT);
									int ll = tmp_s->left  () > tmp_e->left  () ? tmp_s->left  () : tmp_e->left  ();
									int tt = tmp_s->top   () > tmp_e->top   () ? tmp_s->top   () : tmp_e->top   ();
									int rr = tmp_s->right () < tmp_e->right () ? tmp_s->right () : tmp_e->right ();
									int bb = tmp_s->bottom() < tmp_e->bottom() ? tmp_s->bottom() : tmp_e->bottom();
									spark->addElement(new Spark((ll + rr) / 2, (tt + bb) / 2, tmp_s->_color));
								} else if (
								(tmp_e->_type != ENEMY_RAY) &&
								(tmp_e->_type != ENEMY_RAX) &&
								(tmp_e->_type != ENEMY_EXE)
								) {
									if ( state == STATE_PLAY_BOSS ) {
										switch ( st_index ) {
										case 0:
play_music(BGM_STAGE1);
											break;
										case 1:
play_music(BGM_STAGE2);
											break;
										case 2:
											// BGM ĐȂ
											break;
										}
										burst->addElement(new Burst(tmp_e->cx(), tmp_e->cy(), 0));
										burst->addElement(new Burst(tmp_e->cx(), tmp_e->cy(), 3));
										burst->addElement(new Burst(tmp_e->cx(), tmp_e->cy(), 6));
										burst->addElement(new Burst(tmp_e->cx() + (_rand->nextInt() % 100), tmp_e->cy() + (_rand->nextInt() % 100), 9));
										burst->addElement(new Burst(tmp_e->cx() + (_rand->nextInt() % 100), tmp_e->cy() + (_rand->nextInt() % 100), 12));
										burst->addElement(new Burst(tmp_e->cx() + (_rand->nextInt() % 100), tmp_e->cy() + (_rand->nextInt() % 100), 15));
										burst->addElement(new Burst(tmp_e->cx() + (_rand->nextInt() % 100), tmp_e->cy() + (_rand->nextInt() % 100), 20));
										burst->addElement(new Burst(tmp_e->cx() + (_rand->nextInt() % 100), tmp_e->cy() + (_rand->nextInt() % 100), 25));
									} else {
										burst->addElement(new Burst(tmp_e->cx(), tmp_e->cy(), 0));
										burst->addElement(new Burst(tmp_e->cx(), tmp_e->cy(), 3));
										burst->addElement(new Burst(tmp_e->cx(), tmp_e->cy(), 8));
									}
									enemy->removeElementAt(j);
								}
								if ( tmp_s->_type != JSHOT_SWORD ) {
									jshot->removeElementAt(i);
									break;
								}
							}
						}
					}
				}
				if ( j >= 0 ) {
					break;
				}
			}
		}

		// @ƓGeƂ̓蔻
		if ( jiki->_life > 0 ) {
			for ( i = eshot->size() - 1; i >= 0; i-- ) {
				EnemyShot* tmp_e = (EnemyShot*)eshot->elementAt(i);
				if (
				(jiki->h_left  () <= tmp_e->right ()) &&
				(jiki->h_top   () <= tmp_e->bottom()) &&
				(jiki->h_right () >= tmp_e->left  ()) &&
				(jiki->h_bottom() >= tmp_e->top   ())
				) {
					if ( jiki->_color == tmp_e->_color ) {
						jiki->add_special_power();
					} else {
stop_sound(SE_HIT);
play_sound(SE_HIT);
						int ll = jiki->h_left  () > tmp_e->left  () ? jiki->h_left  () : tmp_e->left  ();
						int tt = jiki->h_top   () > tmp_e->top   () ? jiki->h_top   () : tmp_e->top   ();
						int rr = jiki->h_right () < tmp_e->right () ? jiki->h_right () : tmp_e->right ();
						int bb = jiki->h_bottom() < tmp_e->bottom() ? jiki->h_bottom() : tmp_e->bottom();
						spark->addElement(new Spark((ll + rr) / 2, (tt + bb) / 2, tmp_e->_color));
						if ( !jiki->check_muteki() ) {
							jiki->damage(tmp_e->cx(), tmp_e->cy());
						}
					}
					eshot->removeElementAt(i);
					break;
				}
			}
		}

		if (
		(script_reader == NULL) &&
		(enemy->size() == 0) &&
		(eshot->size() == 0) &&
		(burst->size() == 0)
		) {
			switch ( state ) {
			case STATE_PLAY_MAIN:
				set_state(STATE_PLAY_BOSS);
				break;
			case STATE_PLAY_BOSS:
				set_state(STATE_PLAY_LOAD2);
				break;
			case STATE_PLAY_MAIN2:
				set_state(STATE_PLAY_BOSS2);
				break;
			case STATE_PLAY_BOSS2:
				set_state(STATE_PLAY_CLEAR);
				break;
			}
		}
}
		break;
	case STATE_PLAY_CLEAR:
	case STATE_PLAY_CLEAR2:
	case STATE_PLAY_GAMEOVER:
	case STATE_PLAY_GAMEOVER2:
		if ( (state == STATE_PLAY_CLEAR) || (state == STATE_PLAY_GAMEOVER) ) {
			if ( m_elapse <= 100 ) {
				setVolumeMusic(100 - m_elapse);
			} else {
				stopMusic();
			}
		}

		switch ( state ) {
		case STATE_PLAY_CLEAR:
		case STATE_PLAY_CLEAR2:
			g->setBright(127);
			if ( replay ) {
				g->drawImage(use_image(DATA_BACK_COM), 0, 0);
			} else {
				g->drawImage(use_image(DATA_BACK_COM + (st_index + 1)), 0, 0);
			}
			g->setBright(255);
			g->drawImage(use_image(DATA_FONT_LARGE), 320 - FONT_L_STAGECLEAR_W / 2, 80, FONT_L_STAGECLEAR_X, 0, FONT_L_STAGECLEAR_W, FONT_L_H);
			g->drawImage(use_image(DATA_FONT_MEDIUM), 300 - FONT_M_SCORE_W, 170, FONT_M_SCORE_X, 0, FONT_M_SCORE_W, FONT_M_H);
			drawScoreL(score_d, -150, 170);
			g->drawImage(use_image(DATA_FONT_MEDIUM), 300 - FONT_M_LIFE_W, 210, FONT_M_LIFE_X, 0, FONT_M_LIFE_W, FONT_M_H);
			if ( jiki->_life > 0 ) {
				drawScoreL(jiki->_life * 1000, -150, 210);
			} else {
				drawScoreL(0, -150, 210);
			}
			g->drawImage(use_image(DATA_FONT_MEDIUM), 300 - FONT_M_TOTAL_W, 250, FONT_M_TOTAL_X, 0, FONT_M_TOTAL_W, FONT_M_H);
			drawScoreL(score, -150, 250);
			if ( !replay && !first && (score == hi_score[level][st_index]) ) {
				g->drawImage(use_image(DATA_FONT_MEDIUM), 320 - FONT_M_HISCORE_W / 2, 320, FONT_M_HISCORE_X, 0, FONT_M_HISCORE_W, FONT_M_H);
			}
			break;
		case STATE_PLAY_GAMEOVER:
		case STATE_PLAY_GAMEOVER2:
			g->drawImage(use_image(DATA_BLACK), 0, 0);
			g->drawImage(use_image(DATA_FONT_LARGE), 320 - FONT_L_GAMEOVER_W / 2, 100, FONT_L_GAMEOVER_X, 0, FONT_L_GAMEOVER_W, FONT_L_H);
			g->drawImage(use_image(DATA_FONT_MEDIUM), 300 - FONT_M_SCORE_W, 200, FONT_M_SCORE_X, 0, FONT_M_SCORE_W, FONT_M_H);
			drawScoreL(score, 340, 200);
			if ( !replay && !first && (score == hi_score[level][st_index]) ) {
				g->drawImage(use_image(DATA_FONT_MEDIUM), 320 - FONT_M_HISCORE_W / 2, 290, FONT_M_HISCORE_X, 0, FONT_M_HISCORE_W, FONT_M_H);
			}
			break;
		}

		if ( !replay ) {
			g->drawImage(use_image(DATA_FONT_SMALL), 320 - FONT_S_REPLAY_W / 2, 390, FONT_S_REPLAY_X, FONT_S_H, FONT_S_REPLAY_W, FONT_S_H);
			g->drawImage(use_image(DATA_FONT_SMALL), 290 - FONT_S_HAI_W, 430, FONT_S_HAI_X, FONT_S_H, FONT_S_HAI_W, FONT_S_H);
			g->drawImage(use_image(DATA_FONT_SMALL), 350, 430, FONT_S_IIE_X, FONT_S_H, FONT_S_IIE_W, FONT_S_H);
			g->drawImage(use_image(DATA_SELECT), (select_replay == 0) ? (290 - FONT_S_HAI_W - 40) : 350 - 40, 430);
		}

		if ( (state == STATE_PLAY_CLEAR2) || (state == STATE_PLAY_GAMEOVER2) ) {
			m_elapse_r++;
			g->setAlpha(((m_elapse_r * 4) > 255) ? 255 : (m_elapse_r * 4));
			g->drawImage(use_image(DATA_WHITE), 0, 0);
			g->setAlpha(255);
			if ( (m_elapse_r * 4) >= 255 ) {
				set_state(replay ? STATE_SELECTREPLAY : STATE_TITLE);
				break;
			}
		}
		break;
	}

	if ( pause ) {
		m_elapse_p++;
	} else {
		m_elapse++;
	}

	// FPS \
	if ( sys_data.bShowFPS ) {
		drawScoreS(g_framePerSecond, 637, 455);
	}
}

void Main::processEvent(UINT type, UINT param) {
	if ( type == _KEY_PRESSED_EVENT ) {
		switch ( state ) {
		case STATE_LAUNCH:
			break;
		case STATE_TITLE:
			if ( param == _KEY_LEFT ) {
				if ( select_title == 0 ) {
play_sound(SE_CURSOR);
					level--; if ( level < 0 ) level = extra() ? (LEVEL_NUM - 1) : 1;
				}
			} else if ( param == _KEY_RIGHT ) {
				if ( select_title == 0 ) {
play_sound(SE_CURSOR);
					level++; if ( level > (extra() ? (LEVEL_NUM - 1) : 1) ) level = 0;
				}
			} else if ( param == _KEY_UP ) {
play_sound(SE_CURSOR);
				select_title--; if ( select_title < 0 ) select_title = 0;
			} else if ( param == _KEY_DOWN ) {
play_sound(SE_CURSOR);
				select_title++; if ( select_title > 3 ) select_title = 3;
			} else if ( param == button[0] ) {
play_sound(SE_SELECT);
				switch ( select_title ) {
				case 0:
					set_state(STATE_SELECTSTAGE);
					break;
				case 1:
					set_state(STATE_SCORE);
					break;
				case 2:
					set_state(STATE_SELECTREPLAY);
					break;
				case 3:
					set_state(STATE_EXIT);
					break;
				}
			}
			break;
		case STATE_SELECTSTAGE2:
			if ( param == button[1] ) {
play_sound(SE_CANCEL);
				set_state(STATE_TITLE);
			} else if ( param == _KEY_LEFT ) {
play_sound(SE_CURSOR);
				st_index--; if ( st_index < 0 ) st_index = STAGE_NUM - 1;
			} else if ( param == _KEY_RIGHT ) {
play_sound(SE_CURSOR);
				st_index++; if ( st_index >= STAGE_NUM ) st_index = 0;
			}
			break;
		case STATE_SELECTREPLAY2:
			if ( param == button[0] ) {
				if ( select_replay < 0 ) {
play_sound(SE_CANCEL);
					set_state(STATE_TITLE);
				}
			} else if ( param == button[1] ) {
play_sound(SE_CANCEL);
				set_state(STATE_TITLE);
			} else if ( param == _KEY_LEFT ) {
				if ( replay_data->size() > 10 ) {
play_sound(SE_CURSOR);
					select_replay -= 10;
					if ( select_replay < 0 ) {
						select_replay = ((replay_data->size() - 1) / 10 + 1) * 10 + select_replay;
						if ( select_replay >= replay_data->size() ) {
							select_replay = replay_data->size() - 1;
						}
					}
				}
			} else if ( param == _KEY_RIGHT ) {
				if ( replay_data->size() > 10 ) {
play_sound(SE_CURSOR);
					select_replay += 10;
					if ( select_replay >= ((replay_data->size() - 1) / 10 + 1) * 10 ) {
						select_replay = select_replay % 10;
					}
					if ( select_replay >= replay_data->size() ) {
						select_replay = replay_data->size() - 1;
					}
				}
			} else if ( param == _KEY_UP ) {
				if ( replay_data->size() > 1 ) {
play_sound(SE_CURSOR);
					select_replay--; if ( select_replay < 0 ) select_replay = replay_data->size() - 1;
				}
			} else if ( param == _KEY_DOWN ) {
				if ( replay_data->size() > 1 ) {
play_sound(SE_CURSOR);
					select_replay++; if ( select_replay >= replay_data->size() ) select_replay = 0;
				}
			}
			break;
		case STATE_SCORE2:
			if ( (param == button[0]) || (param == button[1]) ) {
play_sound(SE_CANCEL);
				set_state(STATE_TITLE);
			}
			break;
		case STATE_PLAY_MAIN:
		case STATE_PLAY_BOSS:
		case STATE_PLAY_MAIN2:
		case STATE_PLAY_BOSS2:
			if ( (param == _KEY_SPACE) || (param == button[5]) ) {
				if ( m_elapse_r == 0 ) {
					pause = pause ? FALSE : TRUE;
					if ( pause ) {
						pause2 = TRUE;
						select_pause = 0;
						m_elapse_p = 0;
					}
				}
			} else if ( param == _KEY_UP ) {
				if ( m_elapse_r == 0 ) {
					if ( pause && pause2 ) {
play_sound(SE_CURSOR);
						select_pause = 0;
					}
				}
			} else if ( param == _KEY_DOWN ) {
				if ( m_elapse_r == 0 ) {
					if ( pause && pause2 ) {
play_sound(SE_CURSOR);
						select_pause = 1;
					}
				}
			} else if ( (param == _KEY_SHIFT) || (param == button[4]) ) {
				if ( pause ) {
					pause2 = pause2 ? FALSE : TRUE;
				} else {
					request_lock = TRUE;
				}
			} else if ( param == button[0] ) {
				if ( pause ) {
					if ( m_elapse_r == 0 ) {
						if ( pause2 ) {
							switch ( select_pause ) {
							case 0:
								pause = FALSE;
								break;
							case 1:
play_sound(SE_CANCEL);
								m_elapse_r++;
								break;
							}
						} else {
							pause = FALSE;
						}
					}
				} else {
					request_color_0 = TRUE;
				}
			} else if ( param == button[1] ) {
				if ( pause ) {
					pause = FALSE;
				} else {
					request_color_1 = TRUE;
				}
			} else if ( param == button[2] ) {
				if ( !pause ) {
					request_color_2 = TRUE;
				}
			} else if ( param == button[3] ) {
				if ( !pause ) {
					request_dash = TRUE;
				}
			}
			break;
		case STATE_PLAY_CLEAR:
		case STATE_PLAY_GAMEOVER:
			if ( param == _KEY_LEFT ) {
				if ( !replay ) {
play_sound(SE_CURSOR);
					select_replay = 0;
				}
			} else if ( param == _KEY_RIGHT ) {
				if ( !replay ) {
play_sound(SE_CURSOR);
					select_replay = 1;
				}
			} else if ( param == button[0] ) {
				if ( !replay && (select_replay == 0) ) {
play_sound(SE_SELECT);
				} else {
play_sound(SE_CANCEL);
				}
				switch ( state ) {
				case STATE_PLAY_CLEAR:
					set_state(STATE_PLAY_CLEAR2);
					break;
				case STATE_PLAY_GAMEOVER:
					set_state(STATE_PLAY_GAMEOVER2);
					break;
				}
			}
			break;
		}
	} else if ( type == _KEY_RELEASED_EVENT ) {
		if ( param == _KEY_ESCAPE ) {
writeLog("Iv");
			setBackColor(COLOR_K);
			lock_dispose_image = FALSE;
			dispose_image();
			dispose_music();
			dispose_sound();
			save_config();
			terminate();
		} else {
			switch ( state ) {
			case STATE_EXIT:
				if ( param == button[0] ) {
					set_state(STATE_EXIT2);
				}
				break;
			}
		}
	}
}

int Main::rand() {
	int val;
	if ( replay && _replay ) {
		// vCf[^ǂݍ
		_replay->get_rand(&val);
	} else {
		val = _rand->nextInt();

		// vCf[^ɏ
		if ( _replay ) {
			_replay->add_rand(val);
		}
	}
	return val;
}

void Main::next_color(int* color) {
	int tmp;
	for ( ; ; ) {
		tmp = (rand() % 2) + 1;
		if ( tmp != *color ) {
			*color = tmp;
			break;
		}
	}
}

int Main::pattern(int x0, int y0, int x1, int y1) {
	int i, j;
	int w, h;
	int dist = 640000/*640 * 640 + 480 * 480*/;
	int tmp_d;
	x1 -= x0;
	y1 -= y0;
	j = -1;
	for ( i = 0; i < 40; i++ ) {
		w = x1 - CIRCLE_X[i];
		h = y1 - CIRCLE_Y[i];
		tmp_d = w * w + h * h;
		if ( tmp_d < dist ) {
			j = i;
			dist = tmp_d;
		}
	}
	return j;
}

/**
 * ݒ̓ǂݍ
 */
void Main::load_config() {
	int i;

	// ftHgl
	level = 0;
	st_index = 0;
	for ( i = 0; i < STAGE_NUM; i++ ) {
		clear[0][i] = FALSE;
		clear[1][i] = FALSE;
		hi_score[0][i] = 0;
		hi_score[1][i] = 0;
		hi_score[2][i] = 0;
		hi_score[3][i] = 0;
		hi_score[4][i] = 0;
		hi_score[5][i] = 0;
		hi_score[6][i] = 0;
		hi_score[7][i] = 0;
		hi_score[8][i] = 0;
	}

	char file[MAX_PATH];
	sprintf(file, "%s\\save.dat", g_appDir);
	FILE* fp;
	int tmp;
	if ( (fp = fopen(file, "rb")) != NULL ) {
		for ( ; ; ) {
			char header[9];
			char header2[9];
			if ( fread(header, 8, 1, fp) <= 0 ) {
				break;
			}
			header[8] = '\0';
			sprintf(header2, "SAVE%s", CONFIG_VERSION);
			if ( strcmp(header, header2) != 0 ) {
				break;
			}
			if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) level = tmp;
			if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) st_index = tmp;
			for ( i = 0; i < 2; i++ ) {
				if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) clear[0][i] = (tmp == 1) ? TRUE : FALSE;
			}
			for ( i = 0; i < 2; i++ ) {
				if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) clear[1][i] = (tmp == 1) ? TRUE : FALSE;
			}
			for ( i = 0; i < 2; i++ ) {
				if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) hi_score[0][i] = tmp;
			}
			for ( i = 0; i < 2; i++ ) {
				if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) hi_score[1][i] = tmp;
			}
			for ( i = 0; i < 2; i++ ) {
				if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) hi_score[2][i] = tmp;
			}
			for ( i = 0; i < 2; i++ ) {
				if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) hi_score[3][i] = tmp;
			}
			for ( i = 0; i < 2; i++ ) {
				if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) hi_score[4][i] = tmp;
			}
			for ( i = 0; i < 2; i++ ) {
				if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) hi_score[5][i] = tmp;
			}
			if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) clear[0][2] = (tmp == 1) ? TRUE : FALSE;
			if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) clear[1][2] = (tmp == 1) ? TRUE : FALSE;
			if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) hi_score[0][2] = tmp;
			if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) hi_score[1][2] = tmp;
			if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) hi_score[2][2] = tmp;
			if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) hi_score[3][2] = tmp;
			if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) hi_score[4][2] = tmp;
			if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) hi_score[5][2] = tmp;
			for ( i = 0; i < 3; i++ ) {
				if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) hi_score[6][i] = tmp;
			}
			for ( i = 0; i < 3; i++ ) {
				if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) hi_score[7][i] = tmp;
			}
			for ( i = 0; i < 3; i++ ) {
				if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) hi_score[8][i] = tmp;
			}
			break;
		}
		fclose(fp);
	}

#ifdef _DEBUG
	for ( i = 0; i < STAGE_NUM; i++ ) {
		clear[0][i] = TRUE;
		clear[1][i] = TRUE;
	}
#endif // _DEBUG
}

/**
 * ݒ̏o
 */
void Main::save_config() {
	int i;

	char file[MAX_PATH];
	sprintf(file, "%s\\save.dat", g_appDir);
	FILE* fp;
	int tmp;
	if ( (fp = fopen(file, "w+b")) != NULL ) {
		char header[9];
		sprintf(header, "SAVE%s", CONFIG_VERSION);
		fwrite(header, sizeof(char), 8, fp);
		tmp = level;
		fwrite(&tmp, sizeof(int), 1, fp);
		tmp = st_index;
		fwrite(&tmp, sizeof(int), 1, fp);
		for ( i = 0; i < 2; i++ ) {
			tmp = (clear[0][i] == TRUE) ? 1 : 0;
			fwrite(&tmp, sizeof(int), 1, fp);
		}
		for ( i = 0; i < 2; i++ ) {
			tmp = (clear[1][i] == TRUE) ? 1 : 0;
			fwrite(&tmp, sizeof(int), 1, fp);
		}
		for ( i = 0; i < 2; i++ ) {
			tmp = hi_score[0][i];
			fwrite(&tmp, sizeof(int), 1, fp);
		}
		for ( i = 0; i < 2; i++ ) {
			tmp = hi_score[1][i];
			fwrite(&tmp, sizeof(int), 1, fp);
		}
		for ( i = 0; i < 2; i++ ) {
			tmp = hi_score[2][i];
			fwrite(&tmp, sizeof(int), 1, fp);
		}
		for ( i = 0; i < 2; i++ ) {
			tmp = hi_score[3][i];
			fwrite(&tmp, sizeof(int), 1, fp);
		}
		for ( i = 0; i < 2; i++ ) {
			tmp = hi_score[4][i];
			fwrite(&tmp, sizeof(int), 1, fp);
		}
		for ( i = 0; i < 2; i++ ) {
			tmp = hi_score[5][i];
			fwrite(&tmp, sizeof(int), 1, fp);
		}
		tmp = (clear[0][2] == TRUE) ? 1 : 0;
		fwrite(&tmp, sizeof(int), 1, fp);
		tmp = (clear[1][2] == TRUE) ? 1 : 0;
		fwrite(&tmp, sizeof(int), 1, fp);
		tmp = hi_score[0][2];
		fwrite(&tmp, sizeof(int), 1, fp);
		tmp = hi_score[1][2];
		fwrite(&tmp, sizeof(int), 1, fp);
		tmp = hi_score[2][2];
		fwrite(&tmp, sizeof(int), 1, fp);
		tmp = hi_score[3][2];
		fwrite(&tmp, sizeof(int), 1, fp);
		tmp = hi_score[4][2];
		fwrite(&tmp, sizeof(int), 1, fp);
		tmp = hi_score[5][2];
		fwrite(&tmp, sizeof(int), 1, fp);
		for ( i = 0; i < 3; i++ ) {
			tmp = hi_score[6][i];
			fwrite(&tmp, sizeof(int), 1, fp);
		}
		for ( i = 0; i < 3; i++ ) {
			tmp = hi_score[7][i];
			fwrite(&tmp, sizeof(int), 1, fp);
		}
		for ( i = 0; i < 3; i++ ) {
			tmp = hi_score[8][i];
			fwrite(&tmp, sizeof(int), 1, fp);
		}
		fflush(fp);
		fclose(fp);
	}
}

/**
 * f[^ǂݍ
 */
_Memory* Main::read_data(int id) {
	_Memory* data = NULL;
	if ( pak_data ) {
		unsigned long top;
		top = ((unsigned long*)pak_data)[id];
		data = new _Memory();
		if ( data->alloc(((unsigned long*)pak_data)[id + 1] - top) ) {
			memcpy(data->ptr(), &pak_data[top], data->size());
		} else {
			delete data;
			data = NULL;
		}
	} else {
		_String* file = new _String("");
		file->set(g_appDir);
		file->add("\\data.pak");
		FILE* fp;
		unsigned long top;
		unsigned long size;
		if ( (fp = fopen(file->str(), "rb")) != NULL ) {
			fseek(fp, id * sizeof(unsigned long), SEEK_SET);
			fread(&top, sizeof(unsigned long), 1, fp);
			fread(&size, sizeof(unsigned long), 1, fp);
			size -= top;
			data = new _Memory();
			if ( data->alloc(size) ) {
				fseek(fp, top, SEEK_SET);
				fread(data->ptr(), data->size(), 1, fp);
			} else {
				delete data;
				data = NULL;
			}
			fclose(fp);
		}
		delete file;
	}
	return data;
}

/**
 * C[Wǂݍ
 */
void Main::create_image(int id) {
	if ( !(main_img[id].isCreated()) ) {
		{
			char tmp[128];
			sprintf(tmp, "C[W %d \z", id);
			writeLog(tmp);
		}
		_Memory* data = read_data(id);
		g->createImage(&main_img[id], data);
		delete data;
	}
}
void Main::dispose_image(int id) {
	if ( lock_dispose_image ) return;
	if ( main_img[id].isCreated() ) {
		{
			char tmp[128];
			sprintf(tmp, "C[W %d ", id);
			writeLog(tmp);
		}
		g->disposeImage(&main_img[id]);
	}
}
void Main::dispose_image() {
	for ( int i = 0; i < IMAGE_NUM; i++ ) {
		dispose_image(i);
	}
}
_Image* Main::use_image(int id) {
	create_image(id);
	return &main_img[id];
}

/**
 * TEhf[^ǂݍ
 */
void Main::create_sound(int id) {
	if ( !(main_sound[id].isEnabled()) ) {
		{
			char tmp[128];
			sprintf(tmp, "SEf[^ %d \z", id);
			writeLog(tmp);
		}

		char key[16];
		char file[128 + 1];
		switch ( id ) {
		case SE_CURSOR : strcpy(key, "cursor"); break;
		case SE_SELECT : strcpy(key, "select"); break;
		case SE_CANCEL : strcpy(key, "cancel"); break;
		case SE_LOCKON : strcpy(key, "lockon"); break;
		case SE_SHOT   : strcpy(key, "shot"); break;
		case SE_SPECIAL: strcpy(key, "special"); break;
		case SE_SWORD  : strcpy(key, "sword"); break;
		case SE_HIT    : strcpy(key, "hit"); break;
		case SE_DAMAGE : strcpy(key, "damage"); break;
		case SE_POWER  : strcpy(key, "power"); break;
		case SE_BURST  : strcpy(key, "burst"); break;
		case SE_DIVE   : strcpy(key, "dive"); break;
		case SE_SURFACE: strcpy(key, "surface"); break;
		case SE_AWA    : strcpy(key, "awa"); break;
		case SE_DOWN   : strcpy(key, "down"); break;
		case SE_BEAM   : strcpy(key, "beam"); break;
		case SE_DASH   : strcpy(key, "dash"); break;
		}
		char inifile[256];
		sprintf(inifile, "%s\\sound.ini", g_appDir);
		::GetPrivateProfileString("SE", key, "", file, 128, inifile);
		char file2[256];
		sprintf(file2, "%s\\sound\\%s", g_appDir, file);

		int type = _SOUND_WAV;
		if ( strstr(file2, ".wav") != NULL ) {
			type = _SOUND_WAV;
#ifdef _USE_MP3
		} else if ( strstr(file2, ".mp3") != NULL ) {
			type = _SOUND_MP3;
#endif // _USE_MP3
#ifdef _USE_OGGVORBIS
		} else if ( strstr(file2, ".ogg") != NULL ) {
			type = _SOUND_OGGVORBIS;
#endif // _USE_OGGVORBIS
		}

		createSound(&main_sound[id], file2, type);
	}
}
void Main::dispose_sound(int id) {
	if ( main_sound[id].isEnabled() ) {
		{
			char tmp[128];
			sprintf(tmp, "SEf[^ %d ", id);
			writeLog(tmp);
		}
		disposeSound(&main_sound[id]);
	}
}
void Main::dispose_sound() {
	for ( int i = 0; i < SE_NUM; i++ ) {
		dispose_sound(i);
	}
}
_SoundData* Main::use_sound(int id) {
	create_sound(id);
	return &main_sound[id];
}

BOOL Main::create_music(int id) {
	if ( !(main_music[id].isEnabled()) ) {
		{
			char tmp[128];
			sprintf(tmp, "BGMf[^ %d \z", id);
			writeLog(tmp);
		}

		char key[16];
		char file[128 + 1];
		switch ( id ) {
		case BGM_TITLE : strcpy(key, "title"); break;
		case BGM_STAGE1: strcpy(key, "stage1"); break;
		case BGM_STAGE2: strcpy(key, "stage2"); break;
		case BGM_STAGE3: strcpy(key, "stage3"); break;
		case BGM_BOSS1 : strcpy(key, "boss1"); break;
		case BGM_BOSS2 : strcpy(key, "boss2"); break;
		case BGM_BOSS3 : strcpy(key, "boss3"); break;
		case BGM_RAY   : strcpy(key, "ray"); break;
		case BGM_RAX   : strcpy(key, "rax"); break;
		case BGM_EXE   : strcpy(key, "exe"); break;
		}
		char inifile[256];
		sprintf(inifile, "%s\\sound.ini", g_appDir);
		::GetPrivateProfileString("BGM", key, "", file, 128, inifile);
		char file2[256];
		sprintf(file2, "%s\\sound\\%s", g_appDir, file);

		int type = _SOUND_WAV;
		if ( strstr(file2, ".wav") != NULL ) {
			type = _SOUND_WAV;
#ifdef _USE_MP3
		} else if ( strstr(file2, ".mp3") != NULL ) {
			type = _SOUND_MP3;
#endif // _USE_MP3
#ifdef _USE_OGGVORBIS
		} else if ( strstr(file2, ".ogg") != NULL ) {
			type = _SOUND_OGGVORBIS;
#endif // _USE_OGGVORBIS
		}

		createSound(&main_music[id], file2, type);
	}

	return main_music[id].isEnabled();
}
void Main::dispose_music(int id) {
	if ( main_music[id].isEnabled() ) {
		{
			char tmp[128];
			sprintf(tmp, "BGMf[^ %d ", id);
			writeLog(tmp);
		}
		disposeSound(&main_music[id]);
	}
}
void Main::dispose_music() {
	for ( int i = 0; i < BGM_NUM; i++ ) {
		dispose_music(i);
	}
}

void Main::play_music(int id) {
	stopMusic();
	setVolumeMusic(100);

	if ( main_music[id].isEnabled() ) {
		playMusic(&main_music[id], TRUE);
		return;
	}

	char key[16];
	char file[128 + 1];
	switch ( id ) {
	case BGM_TITLE : strcpy(key, "title"); break;
	case BGM_STAGE1: strcpy(key, "stage1"); break;
	case BGM_STAGE2: strcpy(key, "stage2"); break;
	case BGM_STAGE3: strcpy(key, "stage3"); break;
	case BGM_BOSS1 : strcpy(key, "boss1"); break;
	case BGM_BOSS2 : strcpy(key, "boss2"); break;
	case BGM_BOSS3 : strcpy(key, "boss3"); break;
	case BGM_RAY   : strcpy(key, "ray"); break;
	case BGM_RAX   : strcpy(key, "rax"); break;
	case BGM_EXE   : strcpy(key, "exe"); break;
	}
	char inifile[256];
	sprintf(inifile, "%s\\sound.ini", g_appDir);
	::GetPrivateProfileString("BGM", key, "", file, 128, inifile);
	char file2[256];
	sprintf(file2, "%s\\sound\\%s", g_appDir, file);

	int type = _SOUND_WAV;
	if ( strstr(file2, ".wav") != NULL ) {
		type = _SOUND_WAV;
#ifdef _USE_MP3
	} else if ( strstr(file2, ".mp3") != NULL ) {
		type = _SOUND_MP3;
#endif // _USE_MP3
#ifdef _USE_OGGVORBIS
	} else if ( strstr(file2, ".ogg") != NULL ) {
		type = _SOUND_OGGVORBIS;
#endif // _USE_OGGVORBIS
	}

	playMusic(file2, type, TRUE);
}
void Main::play_sound(int id) {
	playSound(use_sound(id));
}
void Main::stop_sound(int id) {
	stopSound(use_sound(id));
}

/**
 * oߎԂmF
 */
int Main::elapse() {
	return pause ? m_elapse_p : m_elapse;
}

/**
 * Av̏ԂύX
 */
void Main::set_state(int new_state) {
	int i;

	old_state = state;
	state = new_state;
	m_elapse = 0;
	m_elapse_p = 0;
	m_elapse_r = 0;

	switch ( old_state ) {
	case STATE_TITLE:
		dispose_image(DATA_LOGO);
		break;
	case STATE_SELECTSTAGE2:
		dispose_image();
		break;
	case STATE_SELECTREPLAY2:
		if ( replay_data ) {
			delete replay_data;
			replay_data = NULL;
		}

		dispose_image();

		break;
	case STATE_PLAY_MAIN:
	case STATE_PLAY_MAIN2:
		dispose_image(DATA_ZAKO1    );
		dispose_image(DATA_ZAKO1_F  );
		dispose_image(DATA_ZAKO2_1  );
		dispose_image(DATA_ZAKO2_1_F);
		dispose_image(DATA_ZAKO2_2  );
		dispose_image(DATA_ZAKO2_2_F);
		dispose_image(DATA_ZAKO3_1  );
		dispose_image(DATA_ZAKO3_1_F);
		dispose_image(DATA_ZAKO3_2  );
		dispose_image(DATA_ZAKO3_2_F);
		dispose_image(DATA_ZAKO4_1  );
		dispose_image(DATA_ZAKO4_1_F);
		dispose_image(DATA_ZAKO4_2  );
		dispose_image(DATA_ZAKO4_2_F);
		dispose_image(DATA_ZAKO5    );
		dispose_image(DATA_ZAKO5_F  );
		dispose_image(DATA_ZAKO6    );
		dispose_image(DATA_ZAKO6_F  );
		break;
	case STATE_PLAY_BOSS:
		switch ( st_index ) {
		case 0:
			dispose_image(DATA_BOSS1_1  );
			dispose_image(DATA_BOSS1_1_F);
			dispose_image(DATA_BOSS1_2  );
			dispose_image(DATA_BOSS1_2_F);
			dispose_image(DATA_BOSS1_3  );
			dispose_image(DATA_BOSS1_3_F);
			break;
		case 1:
			dispose_image(DATA_BOSS2_1  );
			dispose_image(DATA_BOSS2_1_F);
			dispose_image(DATA_BOSS2_2  );
			dispose_image(DATA_BOSS2_2_F);
			dispose_image(DATA_BOSS2_3  );
			dispose_image(DATA_BOSS2_3_F);
			break;
		case 2:
			dispose_image(DATA_BOSS3_1  );
			dispose_image(DATA_BOSS3_1_F);
			dispose_image(DATA_BOSS3_2  );
			dispose_image(DATA_BOSS3_2_F);
			break;
		}
		break;
	case STATE_PLAY_BOSS2:
		switch ( st_index ) {
		case 0:
			dispose_image(DATA_RAY1);
			dispose_image(DATA_RAY1_2);
			dispose_image(DATA_RAY2);
			dispose_image(DATA_RAY3);
			break;
		case 1:
			dispose_image(DATA_RAX1);
			dispose_image(DATA_RAX2);
			break;
		case 2:
			dispose_image(DATA_EXE1);
			dispose_image(DATA_EXE2);
			dispose_image(DATA_EXE2_2);
			dispose_image(DATA_EXE3);
			dispose_image(DATA_EXE3_2);
			break;
		}
		break;
	}

	switch ( state ) {
	case STATE_LAUNCH:
		launch_step = 0;
		break;
	case STATE_TITLE:
		if ( _replay ) {
			delete _replay;
			_replay = NULL;
		}
		replay = FALSE;

		if ( save_replay ) {
			level = save_level;
			st_index = save_st_index;
			save_replay = FALSE;
		}

		dispose_image();
		pause = FALSE;
		if ( (old_state != STATE_SELECTSTAGE2) && (old_state != STATE_SELECTREPLAY2) && (old_state != STATE_SCORE2) ) {
play_music(BGM_TITLE);
		}

		break;
	case STATE_SELECTREPLAY:
		if ( _replay ) {
			delete _replay;
		}
		_replay = new Replay();

		dispose_image();
		pause = FALSE;
		if ( old_state == STATE_TITLE ) {
			select_replay = 0;
		} else {
play_music(BGM_TITLE);
		}

		break;
	case STATE_SELECTREPLAY2:
		if ( !create_replay_data() ) {
			select_replay = -1;
		}
		break;
	case STATE_PLAY_LOAD:
		use_image(DATA_JIKI1);
		use_image(DATA_JIKI2);
		use_image(DATA_JIKI2_2);
		use_image(DATA_JIKI3);
		use_image(DATA_JIKI3_2);
		use_image(DATA_JIKI4);
		use_image(DATA_JIKI4_2);
		use_image(DATA_SHIELD);
		use_image(DATA_SHOT);
		use_image(DATA_BAKU);
		// ̂܂܉ɗ
	case STATE_PLAY_LOAD2:
		if ( script_reader != NULL ) {
			GlobalFree(script_in);
			delete script_reader;
			script_reader = NULL;
		}
		{
			int id;
			if ( state == STATE_PLAY_LOAD ) {
				id = DATA_STAGE11 + st_index * 2;
			} else {
				id = DATA_STAGE12 + st_index * 2;
			}
			_Memory* data = read_data(id);
			script_in = (char*)GlobalAlloc(GMEM_FIXED, data->size() + 1);
			memcpy(script_in, data->ptr(), data->size());
			script_in[data->size()] = '\0';
			delete data;
		}
		script_reader = new StreamReader(script_in);
		for ( ; ; ) {
			script_tmp = script_reader->read();
			if ( script_tmp->str()[0] == 'U' ) {
				delete script_tmp;
				switch ( script_reader->read_val() ) {
				case ENEMY_ZAKO_1:
					use_image(DATA_ZAKO1  );
					use_image(DATA_ZAKO1_F);
					break;
				case ENEMY_ZAKO_2:
					use_image(DATA_ZAKO2_1  );
					use_image(DATA_ZAKO2_1_F);
					use_image(DATA_ZAKO2_2  );
					use_image(DATA_ZAKO2_2_F);
					break;
				case ENEMY_ZAKO_3:
					use_image(DATA_ZAKO3_1  );
					use_image(DATA_ZAKO3_1_F);
					use_image(DATA_ZAKO3_2  );
					use_image(DATA_ZAKO3_2_F);
					break;
				case ENEMY_ZAKO_4:
					use_image(DATA_ZAKO4_1  );
					use_image(DATA_ZAKO4_1_F);
					use_image(DATA_ZAKO4_2  );
					use_image(DATA_ZAKO4_2_F);
					break;
				case ENEMY_ZAKO_5:
					use_image(DATA_ZAKO5  );
					use_image(DATA_ZAKO5_F);
					break;
				case ENEMY_ZAKO_6_1:
					use_image(DATA_ZAKO6  );
					use_image(DATA_ZAKO6_F);
					break;
				}
			} else {
				script_frame = script_tmp->parseInt() * 4;
				delete script_tmp;
				break;
			}
		}
		break;
	case STATE_PLAY_MAIN:
		enemy_color = -1;

		_target = 0;
		_target_old = _target;

		score = 0;
		score_lock = FALSE;

		switch ( st_index ) {
		case 0:
			scroll_w = 320;
			for ( i = 0; i < 480; i++ ) {
				scroll_sy  [i] = i;
				scroll_h   [i] = 1;
				scroll_step[i] = 8.0;
				scroll_dx  [i] = 0.0;
			}
			break;
		case 1:
			scroll_w = 320;
			for ( i = 0; i < 480; i++ ) {
				scroll_sy  [i     ] = i;
				scroll_h   [i     ] = 1;
				scroll_step[i     ] = (double)((i / 10) * 10 + 1) / 4.0 / 24.0;
				scroll_dx  [i     ] = 0.0;
			}
			for ( i = 0; i < 240; i++ ) {
				scroll_sy  [i + 480] = i;
				scroll_h   [i + 480] = 1;
				scroll_step[i + 480] = (double)(240 - i) / 4.0 / 12.0;
				scroll_dx  [i + 480] = 0.0;
			}
			scroll_sy  [720] = 480;
			scroll_h   [720] = 40;
			scroll_step[720] = (double)(480 + 1) / 4.0 / 24.0;
			scroll_dx  [720] = 0.0;
			scroll_sy  [721] = 520;
			scroll_h   [721] = 40;
			scroll_step[721] = (double)(480 + 1) / 4.0 / 24.0;
			scroll_dx  [721] = 0.0;
			break;
		case 2:
			scroll_w = 640;
			scroll_sy  [0] = 0;
			scroll_h   [0] = 480;
			scroll_step[0] = 10.0;
			scroll_dx  [0] = 0.0;
			scroll_sy  [1] = 0;
			scroll_h   [1] = 480;
			scroll_step[1] = 30.0;
			scroll_dx  [1] = 0.0;
			break;
		}

		if ( jshot ) delete jshot;
		if ( eshot ) delete eshot;
		if ( spark ) delete spark;
		if ( tame  ) delete tame;
		if ( awa   ) delete awa;
		if ( burst ) delete burst;
		if ( enemy ) delete enemy;
		jshot = new _Vector();
		eshot = new _Vector();
		spark = new _Vector();
		tame  = new _Vector();
		awa   = new _Vector();
		burst = new _Vector();
		enemy = new _Vector();

		if ( jiki  ) delete jiki;
		jiki = new Jiki();

		st_step = 0;
		st_coef = ((jiki->x() / 2 + (416 - jiki->y()) / 2) * 500) / 496;
		st_coef_dist = st_coef;

		switch ( st_index ) {
		case 0:
play_music(BGM_STAGE1);
			break;
		case 1:
play_music(BGM_STAGE2);
			break;
		case 2:
play_music(BGM_STAGE3);
			break;
		}

		break;
	case STATE_PLAY_BOSS:
		switch ( st_index ) {
		case 0:
play_music(BGM_BOSS1);
			enemy->addElement(new Enemy(ENEMY_BOSS_1, 640, 160, (this->rand() % 2) + 1, 500));
			use_image(DATA_BOSS1_1  );
			use_image(DATA_BOSS1_1_F);
			use_image(DATA_BOSS1_2  );
			use_image(DATA_BOSS1_2_F);
			use_image(DATA_BOSS1_3  );
			use_image(DATA_BOSS1_3_F);
			break;
		case 1:
play_music(BGM_BOSS2);
			enemy->addElement(new Enemy(ENEMY_BOSS_2, 240, -160, (this->rand() % 2) + 1, 500));
			use_image(DATA_BOSS2_1  );
			use_image(DATA_BOSS2_1_F);
			use_image(DATA_BOSS2_2  );
			use_image(DATA_BOSS2_2_F);
			use_image(DATA_BOSS2_3  );
			use_image(DATA_BOSS2_3_F);
			break;
		case 2:
play_music(BGM_BOSS3);
			i = (this->rand() % 2) + 1;
			enemy->addElement(new Enemy(
				ENEMY_BOSS_3_1,
				(this->rand() < 0) ? -100 : 640,
				0,
				i,
				300
				));
			enemy->addElement(new Enemy(
				ENEMY_BOSS_3_2,
				0,
				(this->rand() < 0) ? -100 : 480,
				(i == 2) ? 0 : (i + 1),
				300
				));
			use_image(DATA_BOSS3_1  );
			use_image(DATA_BOSS3_1_F);
			use_image(DATA_BOSS3_2  );
			use_image(DATA_BOSS3_2_F);
			break;
		}
		break;
	case STATE_PLAY_BOSS2:
		switch ( st_index ) {
		case 0:
play_music(BGM_RAY);
			enemy->addElement(new Enemy(ENEMY_RAY, -80, 200, (this->rand() % 2) + 1, 500));
			use_image(DATA_RAY1);
			use_image(DATA_RAY1_2);
			use_image(DATA_RAY2);
			use_image(DATA_RAY3);
			break;
		case 1:
play_music(BGM_RAX);
			enemy->addElement(new Enemy(ENEMY_RAX, 256, 480, (this->rand() % 2) + 1, 500));
			use_image(DATA_RAX1);
			use_image(DATA_RAX2);
			break;
		case 2:
play_music(BGM_EXE);
			enemy->addElement(new Enemy(ENEMY_EXE, 480, -48, 3, 300));
			use_image(DATA_EXE1);
			use_image(DATA_EXE2);
			use_image(DATA_EXE2_2);
			use_image(DATA_EXE3);
			use_image(DATA_EXE3_2);
			use_image(DATA_ZAKO6);
			use_image(DATA_ZAKO6_F);
			break;
		}
		break;
	case STATE_PLAY_CLEAR:
	case STATE_PLAY_GAMEOVER:
		dispose_image();

		if ( replay ) {
			if ( _replay ) {
				delete _replay;
				_replay = NULL;
			}
		} else {
			_replay->add_end();
		}

		if ( state == STATE_PLAY_CLEAR ) {
			if ( !replay ) {
				clear[level][st_index] = TRUE;
			}

			score_d = score;
			if ( jiki->_life > 0 ) {
				add_score(jiki->_life * 100);
			}
		}

		if ( !replay ) {
			save_config();
		}

		if ( !replay ) {
			select_replay = 0;
		}

		break;
	case STATE_PLAY_CLEAR2:
	case STATE_PLAY_GAMEOVER2:
		if ( !replay && (select_replay == 0) ) {
			char file[MAX_PATH];
			FILE* fp;
			sprintf(file, "%s\\replay", g_appDir);
			CreateDirectory(file, NULL);
			for ( int i = 0; ; i++ ) {
				sprintf(file, "%s\\replay\\%08d.csr", g_appDir, i);
				if ( (fp = fopen(file, "rb")) == NULL ) {
					break;
				}
				fclose(fp);
			}
			_String* name = new _String("");
			name->set(sys_data.name);
			_replay->save(file, name, level, st_index, score);
			delete name;
		}
		break;
	}
}

/**
 * XN[XV
 */
void Main::scroll_update(int i) {
	scroll_dx[i] -= scroll_step[i];
	if ( scroll_dx[i] <= 0.0 - (double)scroll_w ) {
		scroll_dx[i] = 0.0;
	}
}

/**
 * XN[`
 */
void Main::scroll_draw(int i, int id, int dy) {
	g->drawImage(use_image(id), (int)scroll_dx[i]           , dy, 0, scroll_sy[i], scroll_w, scroll_h[i]);
	g->drawImage(use_image(id), (int)scroll_dx[i] + scroll_w, dy, 0, scroll_sy[i], scroll_w, scroll_h[i]);
	if ( scroll_w < 640 ) {
		g->drawImage(use_image(id), (int)scroll_dx[i] + (scroll_w * 2), dy, 0, scroll_sy[i], scroll_w, scroll_h[i]);
	}
}

BOOL Main::move(int x0, int y0, int x1, int y1, int cnt) {
	if ( (x0 == x1) && (y0 == y1) ) {
		_move_x = x0 + cnt;
		_move_y = y0;
		return FALSE;
	}
	BOOL ret = TRUE;
	int i;
	int e;
	int dx, dy, sx, sy;
	int w, h;
	int d = cnt * cnt;
	sx = (x1 > x0) ? 1 : -1;
	dx = (x1 > x0) ? x1 - x0 : x0 - x1;
	sy = (y1 > y0) ? 1 : -1;
	dy = (y1 > y0) ? y1 - y0 : y0 - y1;
	_move_x = x0;
	_move_y = y0;
	if ( dx >= dy ) {
		e = -dx;
		for ( i = 0; i <= cnt; i++ ) {
			_move_x += sx;
			e += 2 * dy;
			if ( e >= 0 ) {
				_move_y += sy;
				e -= 2 * dx;
			}
			if ( (_move_x == x1) && (_move_y == y1) ) {
				ret = FALSE;
			}
			w = _move_x - x0;
			h = _move_y - y0;
			if ( (w * w + h * h) >= d ) {
				// ڕWɒBƔ(ɔԒe΂߂ɔԒexɂȂ)
				break;
			}
		}
	} else {
		e = -dy;
		for ( i = 0; i <= cnt; i++ ) {
			_move_y += sy;
			e += 2 * dx;
			if ( e >= 0 ) {
				_move_x += sx;
				e -= 2 * dy;
			}
			if ( (_move_x == x1) && (_move_y == y1) ) {
				ret = FALSE;
			}
			w = _move_x - x0;
			h = _move_y - y0;
			if ( (w * w + h * h) >= d ) {
				// ڕWɒBƔ(ɔԒe΂߂ɔԒexɂȂ)
				break;
			}
		}
	}
	return ret;
}
int Main::move_x() {
	return _move_x;
}
int Main::move_y() {
	return _move_y;
}

/**
 * GNXgI\ǂ
 */
BOOL Main::extra() {
	int i, j;
	for ( i = 0; i < 2; i++ ) {
		for ( j = 0; j < STAGE_NUM; j++ ) {
			if ( !(clear[i][j]) ) {
				return FALSE;
			}
		}
	}
	return TRUE;
}

/**
 * XRAZ
 */
void Main::add_score(int point) {
	score += point * 10;
	if ( !replay ) {
		if ( score > hi_score[level][st_index] ) hi_score[level][st_index] = score;
	}
}

void Main::lock_enemy() {
	int i, j;
	int jx = jiki->cx();
	int jy = jiki->cy();
	int ex, ey;
	int w, h;
	int dist = 460800/*480 * 480 + 480 * 480*/;
	int tmp_d;
	j = -1;
	for ( i = enemy->size() - 1; i >= 0; i-- ) {
		Enemy* tmp = (Enemy*)enemy->elementAt(i);
		if ( !(tmp->destroyed()) && (tmp->_color < 3) ) {
			ex = tmp->cx();
			ey = tmp->cy();
			w = jx - ex;
			h = jy - ey;
			tmp_d = w * w + h * h;
			if ( tmp_d < dist ) {
				j = i;
				dist = tmp_d;
			}
		}
	}
	if ( j >= 0 ) {
		Enemy* tmp = (Enemy*)enemy->elementAt(j);
		tmp->_lock = TRUE;
	}
}

int FONT_S_NUM_X[] = {
	FONT_S_0_X,
	FONT_S_1_X - 2,
	FONT_S_2_X,
	FONT_S_3_X,
	FONT_S_4_X,
	FONT_S_5_X,
	FONT_S_6_X,
	FONT_S_7_X - 1,
	FONT_S_8_X,
	FONT_S_9_X
};
void Main::drawScoreS(int score, int x, int y) {
	int i;
	int tmp_score;
	x -= 13;
	if ( score == 0 ) {
		g->drawImage(use_image(DATA_FONT_SMALL), x, y, FONT_S_NUM_X[0], 0, 15, FONT_S_H);
	} else {
		tmp_score = score;
		for ( i = 0; tmp_score > 0; i++ ) {
			g->drawImage(use_image(DATA_FONT_SMALL), x, y, FONT_S_NUM_X[tmp_score % 10], 0, 15, FONT_S_H);
			tmp_score /= 10;
			x -= 13;
		}
	}
}
void Main::centerDrawScoreS(int score, int y) {
	int i;
	int tmp_score;
	tmp_score = score;
	if ( tmp_score == 0 ) {
		i = 1;
	} else {
		for ( i = 0; tmp_score > 0; i++ ) {
			tmp_score /= 10;
		}
	}
	drawScoreS(score, 320 + (i * 13) / 2, y);
}

int FONT_L_NUM_X[] = {
	FONT_L_0_X,
	FONT_L_1_X - 2,
	FONT_L_2_X,
	FONT_L_3_X,
	FONT_L_4_X,
	FONT_L_5_X,
	FONT_L_6_X - 1,
	FONT_L_7_X - 1,
	FONT_L_8_X,
	FONT_L_9_X - 1
};
void Main::drawScoreL(int score, int x, int y) {
	int i;
	int tmp_score;
	if ( x < 0 ) {
		x += width();
	} else {
		tmp_score = score;
		if ( tmp_score == 0 ) {
			i = 1;
		} else {
			for ( i = 0; tmp_score > 0; i++ ) {
				tmp_score /= 10;
			}
		}
		x += i * 20;
	}
	x -= 20;
	if ( score == 0 ) {
		g->drawImage(use_image(DATA_FONT_LARGE), x, y, FONT_L_NUM_X[0], 0, 22, FONT_L_H);
	} else {
		tmp_score = score;
		for ( i = 0; tmp_score > 0; i++ ) {
			g->drawImage(use_image(DATA_FONT_LARGE), x, y, FONT_L_NUM_X[tmp_score % 10], 0, 22, FONT_L_H);
			tmp_score /= 10;
			x -= 20;
		}
	}
}

void Main::drawTitleBack() {
	g->drawImage(use_image(DATA_BACK_COM), 0, 0);
	g->setColor(COLOR_W);
	g->rightDrawString(VERSION, 20, 160);
	g->rightDrawString(VERSION, 21, 160);
	g->setROP(_ROP_ADD);
	g->drawImage(use_image(DATA_LOGO), 620 - 342,  30, 0,  0, 342, 61);
	g->drawImage(use_image(DATA_LOGO), 620 - 209,  95, 0, 61, 209, 24);
	g->drawImage(use_image(DATA_LOGO), 620 - 250, 455, 0, 85, 250, 17);
	g->setROP(_ROP_COPY);
}

BOOL Main::create_replay_data() {
	if ( replay_data ) delete replay_data;
	replay_data = new _Vector();

	struct _finddata_t find;
	long fh;
	char path[MAX_PATH];
	char file[MAX_PATH];
	sprintf(path, "%s\\replay\\*.csr", g_appDir);
	if ( (fh = _findfirst((LPCTSTR)path, &find)) != -1 ) {
		do {
			if ( !(find.attrib & _A_SUBDIR) ) {
				sprintf(file, "%s\\replay\\%s", g_appDir, find.name);
				replay_data->addElement(new ReplayData(file));
			}
		} while ( _findnext(fh, &find) != -1 );
	}

	return (replay_data->size() > 0) ? TRUE : FALSE;
}

#ifdef SHOW_AREA
void Main::drawArea(int x, int y, int w, int h) {
	g->drawImage(m->use_image(DATA_STAGE), x, y, 0, 0, w, 1);
	g->drawImage(m->use_image(DATA_STAGE), x, y + h - 1, 0, 0, w, 1);
	g->drawImage(m->use_image(DATA_STAGE), x, y, 0, 0, 1, h);
	g->drawImage(m->use_image(DATA_STAGE), x + w - 1, y, 0, 0, 1, h);
}
#endif // SHOW_AREA
