/****************************************************
 * ނ`                                       *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#include "_Global.h"

#include "Enemy.hpp"

#define m g_main
#define g g_main->g

extern int CIRCLE_X[];
extern int CIRCLE_Y[];

Enemy::Enemy(int type, int x0, int y0, int color, int life) {
	_type      = type;
	_step      = 0;
	_x0        = x0;
	_y0        = y0;
	_x         = _x0;
	_y         = _y0;
	_color     = color;
	_life_max  = life;
	_life      = _life_max;
	_elapse    = 0;
	_elapse2   = 0;
	_elapse3   = 0;
	_lock      = FALSE;
	_damaged   = FALSE;
	_add_score = FALSE;

	switch ( _type ) {
	case ENEMY_ZAKO_4:
		x1 = 240;
		y1 = y0;
		break;
	case ENEMY_BOSS_1:
		flag = (m->rand() > 0) ? TRUE : FALSE;
		break;
	case ENEMY_BOSS_3_1:
		flag = (m->rand() > 0) ? TRUE : FALSE;
		yy = flag ? 20 : 460;
		if ( _x >= 640 ) {
			_step = 0;
		} else {
			_step = 1;
		}
		break;
	case ENEMY_BOSS_3_2:
		flag = (m->rand() > 0) ? TRUE : FALSE;
		xx = flag ? 20 : 620;
		if ( _y >= 480 ) {
			_step = 0;
		} else {
			_step = 1;
		}
		break;
	case ENEMY_RAX:
		shot = 0;
		break;
	case ENEMY_EXE:
		m->exe_x = (m->rand() % 100) + 100;
		m->exe_y = (m->rand() % 100) + 100;
		m->exe_color = -1;
		m->exe_r = 0.0;
		break;
	}
}

void Enemy::next_step() {
	_step++;
	_elapse = 0;
}

int Enemy::left() {
	switch ( _type ) {
	case ENEMY_ZAKO_1  : return _x;
	case ENEMY_ZAKO_2  : return (_x0 < 0) ? _x : (_x + 64);
	case ENEMY_ZAKO_3  : return _x;
	case ENEMY_ZAKO_4  : return (_x0 > x1) ? _x : (_x + 16);
	case ENEMY_ZAKO_5  : return _x;
	case ENEMY_ZAKO_6_1: return _x;
	case ENEMY_ZAKO_6_2: return _x;
	case ENEMY_BOSS_1  : return _x + 40;
	case ENEMY_BOSS_2  : return _x + 40;
	case ENEMY_BOSS_3_1: return _x;
	case ENEMY_BOSS_3_2: return _x;
	case ENEMY_RAY     : return _x + 15;
	case ENEMY_RAX     : return _x + 15;
	case ENEMY_EXE     : return _x;
	}
	return 0;
}

int Enemy::top() {
	switch ( _type ) {
	case ENEMY_ZAKO_1  : return _y;
	case ENEMY_ZAKO_2  : return _y;
	case ENEMY_ZAKO_3  : return _y;
	case ENEMY_ZAKO_4  : return _y;
	case ENEMY_ZAKO_5  : return _y;
	case ENEMY_ZAKO_6_1: return _y;
	case ENEMY_ZAKO_6_2: return _y;
	case ENEMY_BOSS_1  : return _y + 40;
	case ENEMY_BOSS_2  : return _y + 40;
	case ENEMY_BOSS_3_1: return _y;
	case ENEMY_BOSS_3_2: return _y;
	case ENEMY_RAY     : return _y + 15;
	case ENEMY_RAX     : return _y + 15;
	case ENEMY_EXE     : return _y;
	}
	return 0;
}

int Enemy::right() {
	switch ( _type ) {
	case ENEMY_ZAKO_1  : return _x + 63;
	case ENEMY_ZAKO_2  : return _x + ((_x0 < 0) ? 63 : 127);
	case ENEMY_ZAKO_3  : return _x + (((_x0 >= 0) && (_x0 < 640)) ? 31 : 159);
	case ENEMY_ZAKO_4  : return _x + ((_x0 > x1) ? 63 : 79);
	case ENEMY_ZAKO_5  : return _x + 79;
	case ENEMY_ZAKO_6_1: return _x + 63;
	case ENEMY_ZAKO_6_2: return _x + 63;
	case ENEMY_BOSS_1  : return _x + 119;
	case ENEMY_BOSS_2  : return _x + 119;
	case ENEMY_BOSS_3_1: return _x + 99;
	case ENEMY_BOSS_3_2: return _x + 639;
	case ENEMY_RAY     : return _x + 44;
	case ENEMY_RAX     : return _x + 80;
	case ENEMY_EXE     : return _x + 47;
	}
	return 0;
}

int Enemy::bottom() {
	switch ( _type ) {
	case ENEMY_ZAKO_1  : return _y + 63;
	case ENEMY_ZAKO_2  : return _y + 63;
	case ENEMY_ZAKO_3  : return _y + (((_x0 >= 0) && (_x0 < 640)) ? 159 : 31);
	case ENEMY_ZAKO_4  : return _y + 63;
	case ENEMY_ZAKO_5  : return _y + 99;
	case ENEMY_ZAKO_6_1: return _y + 63;
	case ENEMY_ZAKO_6_2: return _y + 63;
	case ENEMY_BOSS_1  : return _y + 119;
	case ENEMY_BOSS_2  : return _y + 119;
	case ENEMY_BOSS_3_1: return _y + 479;
	case ENEMY_BOSS_3_2: return _y + 99;
	case ENEMY_RAY     : return _y + 44;
	case ENEMY_RAX     : return _y + 80;
	case ENEMY_EXE     : return _y + 47;
	}
	return 0;
}

int Enemy::cx() { return (left() + right()) / 2; }
int Enemy::cy() { return (top() + bottom()) / 2; }

BOOL Enemy::damage(int cnt, int type) {
	if ( type == JSHOT_SPECIAL ) {
		if ( _damaged ) return FALSE;
		_damaged = TRUE;
	}
	_life -= cnt;
	if ( _life <= 0 ) {
		_lock = FALSE;
		if ( !_add_score ) {
			_add_score = TRUE;
			m->add_score(_life_max);
		}
	}
	if ( _type == ENEMY_ZAKO_6_2 ) {
		// GNZɃ_[W
		Enemy* tmp = (Enemy*)m->enemy->elementAt(0);
		if ( tmp != NULL ) {
			if ( tmp->_type == ENEMY_EXE ) {
				tmp->damage(cnt, type);
			}
		}
	}
	return TRUE;
}

BOOL Enemy::destroyed() {
	return (_life <= 0) ? TRUE : FALSE;
}

BOOL Enemy::update() {
	int i;

	_damaged = FALSE;

	_elapse++;
	switch ( _type ) {
	case ENEMY_ZAKO_1/*H`*/:
		if ( (m->level % 3) == 2 ) {
			if ( (_elapse % 5) == 0 ) {
				_elapse2 += 2;
				if ( _elapse2 > 39 ) {
					_elapse2 -= 40;
				}
				m->eshot->addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), cx() + CIRCLE_X[_elapse2], cy() + CIRCLE_Y[_elapse2], _color, 6));
			}
		}
		switch ( _step ) {
		case 0:
			if ( (_x0 >= 0) && (_x0 < 640) ) {
				if ( _y0 < 0 ) {
					_y += 2;
					if ( _y >= 56 ) {
						next_step();
					}
				} else {
					_y -= 2;
					if ( _y <= 360 ) {
						next_step();
					}
				}
			} else {
				if ( _x0 < 0 ) {
					_x += 2;
					if ( _x >= 56 ) {
						next_step();
					}
				} else {
					_x -= 2;
					if ( _x <= 520 ) {
						next_step();
					}
				}
			}
			break;
		case 1:
			if ( (_elapse % 50) == 1 ) {
				if ( (m->level % 3) < 2 ) {
					m->eshot->addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), m->jiki->cx(), m->jiki->cy(), _color, 6));
				}
				if ( (m->level % 3) >= 1 ) {
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), m->jiki->cx(), m->jiki->cy(), 3, 3));
				}
			}
			if ( _elapse > 150 ) {
				next_step();
			}
			break;
		case 2:
			if ( (_x0 >= 0) && (_x0 < 640) ) {
				if ( _y0 < 0 ) {
					_y += 2;
					if ( _y >= 480 ) {
						return FALSE;
					}
				} else {
					_y -= 2;
					if ( _y < -64 ) {
						return FALSE;
					}
				}
			} else {
				if ( _x0 < 0 ) {
					_x += 2;
					if ( _x >= 640 ) {
						return FALSE;
					}
				} else {
					_x -= 2;
					if ( _x < -64 ) {
						return FALSE;
					}
				}
			}
			break;
		}
		break;
	case ENEMY_ZAKO_2/*Op*/:
		switch ( _step ) {
		case 0:
			if ( _x0 < 0 ) {
				_x += 6;
				if ( _x >= 512 ) {
					_step++;
				}
			} else {
				_x -= 6;
				if ( _x <= 0 ) {
					_step++;
				}
			}
			if ( (_elapse % 10) == 1 ) {
				if ( ((m->level % 3) == 2) && ((_elapse % 20) == 1) ) {
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), cx(), -20, 3, 6));
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), cx(), 500, 3, 6));
				} else {
					m->eshot->addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), cx(), -20, _color, 6));
					m->eshot->addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), cx(), 500, _color, 6));
				}
			}
			break;
		case 1:
			xx = m->jiki->cx();
			yy = m->jiki->cy();
			next_step();
			// ̂܂܉ɗ
		case 2:
			if ( (_elapse % 10) == 1 ) {
				if ( (m->level % 3) >= 1 ) {
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), m->jiki->cx(), m->jiki->cy(), 3, 6));
				} else {
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), xx, yy, 3, 6));
				}
			}
			if ( _elapse > 50 ) {
				next_step();
			}
			break;
		case 3:
			if ( _y0 < 208 ) {
				_y += 2;
				if ( _y >= 480 ) {
					return FALSE;
				}
			} else {
				_y -= 2;
				if ( _y < -64 ) {
					return FALSE;
				}
			}
			break;
		}
		break;
	case ENEMY_ZAKO_3/*˂炵*/:
		if ( (m->level % 3) == 2 ) {
			if ( (_elapse % 5) == 0 ) {
				_elapse2++;
				if ( (_elapse2 % 3) == 1 ) {
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), (m->rand() % 240) + 240, (m->rand() % 240) + 240, 3, 3));
				} else {
					m->eshot->addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), (m->rand() % 240) + 240, (m->rand() % 240) + 240, _color, 6));
				}
			}
		}
		switch ( _step ) {
		case 0:
			if ( (_x0 >= 0) && (_x0 < 640) ) {
				if ( _y0 < 0 ) {
					_y += 6;
					if ( _y >= 320 ) {
						next_step();
					}
				} else {
					_y -= 6;
					if ( _y <= 0 ) {
						next_step();
					}
				}
			} else {
				if ( _x0 < 0 ) {
					_x += 6;
					if ( _x >= 480 ) {
						next_step();
					}
				} else {
					_x -= 6;
					if ( _x <= 0 ) {
						next_step();
					}
				}
			}
			break;
		case 1:
			if ( (m->level % 3) < 2 ) {
				if ( (_elapse % 5) == 0 ) {
					if ( (_elapse % 3) == 1 ) {
						m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), (m->rand() % 320) + 320, (m->rand() % 240) + 240, 3, 3));
					} else {
						m->eshot->addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), (m->rand() % 320) + 320, (m->rand() % 240) + 240, _color, 6));
					}
				}
				if ( (m->level % 3) == 1 ) {
					if ( (_elapse % 20) == 1 ) {
						m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), (m->rand() % 320) + 320, (m->rand() % 240) + 240, 3, 2));
					}
				}
			}
			if ( _elapse > 150 ) {
				next_step();
			}
			break;
		case 2:
			if ( (_x0 >= 0) && (_x0 < 640) ) {
				if ( _y0 < 0 ) {
					_y -= 6;
					if ( _y <= -160 ) {
						return FALSE;
					}
				} else {
					_y += 6;
					if ( _y >= 480 ) {
						return FALSE;
					}
				}
			} else {
				if ( _x0 < 0 ) {
					_x -= 6;
					if ( _x <= -160 ) {
						return FALSE;
					}
				} else {
					_x += 6;
					if ( _x >= 640 ) {
						return FALSE;
					}
				}
			}
			break;
		}
		break;
	case ENEMY_ZAKO_4/**/:
		if ( (m->level % 3) == 2 ) {
			if ( (_elapse % 5) == 0 ) {
				_elapse2++;
				if ( (_elapse2 % 5) == 1 ) {
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), m->jiki->cx(), m->jiki->cy(), 3, 7));
				}
			}
		}
		switch ( _step ) {
		case 0:
			m->move(_x0, _y0, x1, y1, _elapse * 5);
			_x = m->move_x();
			_y = m->move_y();
			if ( _elapse > 30 ) {
				next_step();
			}
			break;
		case 1:
		case 3:
		case 5:
			if ( (_elapse % 50) == 1 ) {
				m->eshot->addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), m->jiki->cx(), m->jiki->cy(), _color, 6));
				if ( (m->level % 3) == 1 ) {
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), m->jiki->cx(), m->jiki->cy(), 3, 4));
				}
			}
			if ( _elapse > 45 ) {
				_x0 = _x;
				_y0 = _y;
				x1 = m->jiki->cx();
				y1 = m->jiki->cy();
				next_step();
			}
			break;
		case 2:
		case 4:
			m->move(_x0, _y0, x1, y1, _elapse * 5);
			_x = m->move_x();
			_y = m->move_y();
			if ( _elapse > 50 ) {
				next_step();
			}
			break;
		case 6:
			m->move(_x0, _y0, x1, y1, _elapse * 5);
			_x = m->move_x();
			_y = m->move_y();
			if ( (_x < -80) || (_x > 640) || (_y < -80) || (_y > 480) ) {
				return FALSE;
			}
			break;
		}
		break;
	case ENEMY_ZAKO_5/*lp*/:
		if ( (m->level % 3) == 2 ) {
			if ( (_elapse % 3) == 0 ) {
				_elapse2++;
				if ( (_elapse2 % 3) == 1 ) {
					int x = cx();
					int y = cy();
					int dx = m->jiki->cx();
					int dy = m->jiki->cy();
					int w = (dx - x) / 10;
					int h = (dy - y) / 10;
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx + h * 6, dy - w * 6, 3, 8));
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx - h * 6, dy + w * 6, 3, 8));
				}
			}
		}
		switch ( _step ) {
		case 0:
			if ( _x0 < 0 ) {
				_x += 2;
				if ( _x >= 40 ) {
					next_step();
				}
			} else {
				_x -= 2;
				if ( _x <= 520 ) {
					next_step();
				}
			}
			break;
		case 1:
			switch ( _elapse % 175 ) {
			case 5:
				xx = m->jiki->cx();
				yy = m->jiki->cy();
				// ̂܂܉ɗ
			case 15:
			case 25:
			case 35:
				m->eshot->addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), xx, yy, _color, 6));
				break;
			}
			if ( (m->level % 3) < 2 ) {
				if ( (_elapse % 225) == 1 ) {
					int x = cx();
					int y = cy();
					int dx = m->jiki->cx();
					int dy = m->jiki->cy();
					int w = (dx - x) / 10;
					int h = (dy - y) / 10;
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx + h *  4, dy - w *  4, 3, 3));
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx + h * 17, dy - w * 17, 3, 3));
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx - h *  4, dy + w *  4, 3, 3));
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx - h * 17, dy + w * 17, 3, 3));
					if ( (m->level % 3) == 1 ) {
						m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx + h *  4, dy - w *  4, 3, 6));
						m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx + h * 17, dy - w * 17, 3, 6));
						m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx - h *  4, dy + w *  4, 3, 6));
						m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx - h * 17, dy + w * 17, 3, 6));
					}
				}
			}
			if ( _elapse >= 500 ) {
				next_step();
			}
			break;
		case 2:
			if ( _x0 < 0 ) {
				_x -= 2;
				if ( _x <= -80 ) {
					return FALSE;
				}
			} else {
				_x += 2;
				if ( _x >= 640 ) {
					return FALSE;
				}
			}
			break;
		}
		break;
	case ENEMY_ZAKO_6_1/*`*/:
	case ENEMY_ZAKO_6_2/*`iGNZj*/:
		if ( (_x0 >= 0) && (_x0 < 640) ) {
			if ( _y0 < 0 ) {
				_y += (_type == ENEMY_ZAKO_6_1) ? 3 : 2;
				if ( _y >= 480 ) {
					return FALSE;
				}
			} else {
				_y -= (_type == ENEMY_ZAKO_6_1) ? 3 : 2;
				if ( _y < -64 ) {
					return FALSE;
				}
			}
		} else {
			if ( _x0 < 0 ) {
				_x += (_type == ENEMY_ZAKO_6_1) ? 3 : 2;
				if ( _x >= 640 ) {
					return FALSE;
				}
			} else {
				_x -= (_type == ENEMY_ZAKO_6_1) ? 3 : 2;
				if ( _x < -64 ) {
					return FALSE;
				}
			}
		}
		switch ( m->level % 3 ) {
		case 0:
			if ( (_elapse % 72) == 1 ) {
				m->eshot->addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), m->jiki->cx(), m->jiki->cy(), _color, (_type == ENEMY_ZAKO_6_1) ? 6 : 4));
			}
			break;
		case 1:
			switch ( _elapse % 72 ) {
			case 1:
				xx = m->jiki->cx();
				yy = m->jiki->cy();
				// ̂܂܉ɗ
			case 13:
			case 25:
				m->eshot->addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), xx, yy, _color, (_type == ENEMY_ZAKO_6_1) ? 7 : 5));
				break;
			}
			break;
		case 2:
			switch ( _elapse % 36 ) {
			case 1:
				xx = m->jiki->cx();
				yy = m->jiki->cy();
				// ̂܂܉ɗ
			case 13:
			case 25:
				m->eshot->addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), xx, yy, _color, (_type == ENEMY_ZAKO_6_1) ? 8 : 6));
				break;
			}
			break;
		}
		if (
		(_type == ENEMY_ZAKO_6_1) &&
		((m->level % 3) > 0) &&
		((_elapse % 60) == 1)
		) {
			if ( (m->level % 3) == 1 ) {
				m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), (m->rand() % 240) + 240, (m->rand() % 240) + 240, 3, 3));
			} else {
				m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), (m->rand() % 240) + 240, (m->rand() % 240) + 240, 3, 4));
			}
		}
		break;
	case ENEMY_BOSS_1/*{XP*/:
		switch ( _step ) {
		case 0:
			_x -= 2;
			if ( _x <= 240 ) {
				next_step();
			}
			break;
		case 1:
			if ( _elapse > 50 ) {
				next_step();
			}
			break;
		case 2:
			if ( (_elapse % 10) == 1 ) {
				if ( flag ) {
					_elapse2++;
					if ( _elapse2 > 39 ) {
						_elapse2 -= 40;
					}
					if ( (m->level % 3) == 2 ) {
						_elapse3--;
						if ( _elapse3 < 0 ) {
							_elapse3 += 40;
						}
					}
				} else {
					_elapse2--;
					if ( _elapse2 < 0 ) {
						_elapse2 += 40;
					}
					if ( (m->level % 3) == 2 ) {
						_elapse3++;
						if ( _elapse3 > 39 ) {
							_elapse3 -= 40;
						}
					}
				}
				if ( (m->level % 3) == 2 ) {
					int a =  _elapse2           ;
					int b = (_elapse2 + 13) % 40;
					int c = (_elapse2 + 26) % 40;
					m->eshot->addElement(new EnemyShot(ESHOT_LARGE, 320 + CIRCLE_X[a] / 2, 240 + CIRCLE_Y[a] / 2, 320 + CIRCLE_X[a], 240 + CIRCLE_Y[a], _color, 4));
					m->eshot->addElement(new EnemyShot(ESHOT_LARGE, 320 + CIRCLE_X[b] / 2, 240 + CIRCLE_Y[b] / 2, 320 + CIRCLE_X[b], 240 + CIRCLE_Y[b], _color, 4));
					m->eshot->addElement(new EnemyShot(ESHOT_LARGE, 320 + CIRCLE_X[c] / 2, 240 + CIRCLE_Y[c] / 2, 320 + CIRCLE_X[c], 240 + CIRCLE_Y[c], _color, 4));
					a = (_elapse3 +  7) % 40;
					b = (_elapse3 + 20) % 40;
					c = (_elapse3 + 33) % 40;
					m->eshot->addElement(new EnemyShot(ESHOT_LARGE, 320 + CIRCLE_X[a] / 2, 240 + CIRCLE_Y[a] / 2, 320 + CIRCLE_X[a], 240 + CIRCLE_Y[a], _color, 4));
					m->eshot->addElement(new EnemyShot(ESHOT_LARGE, 320 + CIRCLE_X[b] / 2, 240 + CIRCLE_Y[b] / 2, 320 + CIRCLE_X[b], 240 + CIRCLE_Y[b], _color, 4));
					m->eshot->addElement(new EnemyShot(ESHOT_LARGE, 320 + CIRCLE_X[c] / 2, 240 + CIRCLE_Y[c] / 2, 320 + CIRCLE_X[c], 240 + CIRCLE_Y[c], _color, 4));
				} else {
					int a =  _elapse2           ;
					int b = (_elapse2 + 10) % 40;
					int c = (_elapse2 + 20) % 40;
					int d = (_elapse2 + 30) % 40;
					m->eshot->addElement(new EnemyShot(ESHOT_LARGE, 320 + CIRCLE_X[a] / 2, 240 + CIRCLE_Y[a] / 2, 320 + CIRCLE_X[a], 240 + CIRCLE_Y[a], _color, 4));
					m->eshot->addElement(new EnemyShot(ESHOT_LARGE, 320 + CIRCLE_X[b] / 2, 240 + CIRCLE_Y[b] / 2, 320 + CIRCLE_X[b], 240 + CIRCLE_Y[b], _color, 4));
					m->eshot->addElement(new EnemyShot(ESHOT_LARGE, 320 + CIRCLE_X[c] / 2, 240 + CIRCLE_Y[c] / 2, 320 + CIRCLE_X[c], 240 + CIRCLE_Y[c], _color, 4));
					m->eshot->addElement(new EnemyShot(ESHOT_LARGE, 320 + CIRCLE_X[d] / 2, 240 + CIRCLE_Y[d] / 2, 320 + CIRCLE_X[d], 240 + CIRCLE_Y[d], _color, 4));
				}
			}
			if ( (_elapse % 100) == 75 ) {
				int dx = m->jiki->cx();
				int dy = m->jiki->cy();
				int w = dx - 320;
				int h = dy - 240;
				if ( (m->level % 3) == 2 ) {
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, 320, 240, dx    , dy    , 3, 3));
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, 320, 240, dx + h, dy - w, 3, 3));
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, 320, 240, dx - h, dy + w, 3, 3));
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, 320, 240, dx    , dy    , 3, 6));
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, 320, 240, dx + h, dy - w, 3, 6));
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, 320, 240, dx - h, dy + w, 3, 6));
				} else {
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, 320, 240, dx    , dy    , 3, 2));
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, 320, 240, dx + h, dy - w, 3, 2));
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, 320, 240, dx - h, dy + w, 3, 2));
					if ( (m->level % 3) >= 1 ) {
						m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, 320, 240, dx    , dy    , 3, 4));
						m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, 320, 240, dx + h, dy - w, 3, 4));
						m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, 320, 240, dx - h, dy + w, 3, 4));
					}
				}
			}
			if ( (m->level / 3) == 2 ) {
				// Random [hI
				if ( (m->level % 3) == 2 ) {
					if ( (_elapse % 35) == 34 ) {
						m->next_color(&_color);
					}
				} else {
					if ( (_elapse % 70) == 69 ) {
						m->next_color(&_color);
					}
				}
			} else {
				if ( (m->level % 3) == 2 ) {
					if ( (_elapse % 75) == 74 ) {
						m->next_color(&_color);
					}
				} else {
					if ( (_elapse % 150) == 149 ) {
						m->next_color(&_color);
					}
				}
			}
			if ( (_elapse % 300) == 299 ) {
				flag = (m->rand() > 0) ? TRUE : FALSE;
			}
			break;
		}
		break;
	case ENEMY_BOSS_2/*{XQ*/:
		if ( (m->level % 3) == 2 ) {
			_color = (_elapse / 5) % 3;
		}
		switch ( _step ) {
		case 0:
			_y += 2;
			if ( _y >= 160 ) {
				next_step();
			}
			break;
		case 1:
			if ( ((m->level % 3) == 2) || ((_elapse % 10) == 1) ) {
				if ( (_elapse % 5) == 1 ) {
					m->eshot->addElement(new EnemyShot(ESHOT_LARGE, 320, 240, 320 + (m->rand() % 320), 240 + (m->rand() % 240), _color, 4));
				}
			}
			if ( (_elapse % 15) == 1 ) {
				m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, 320, 160, 320 + (m->rand() % 120), 0, 3, 6));
			}
			if ( (_elapse > 100) && ((_elapse % 30) == 1) ) {
				int xx = (10 + (m->rand() % 10)) * 32;
				m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, xx, -8, xx, 480, 3, 2));
			}
			if ( (m->level % 3) >= 1 ) {
				if ( (_elapse % 50) == 1 ) {
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, 320, 240, m->jiki->cx(), m->jiki->cy(), 3, 4));
				}
			}
			if ( (m->level % 3) < 2 ) {
				if ( (m->level / 3) == 2 ) {
					// Random [hI
					if ( (_elapse % 70) == 69 ) {
						m->next_color(&_color);
					}
				} else {
					if ( (_elapse % 150) == 149 ) {
						m->next_color(&_color);
					}
				}
			}
			break;
		}
		break;
	case ENEMY_BOSS_3_1/*{XR^e*/:
		if ( (_elapse % 2) == 1 ) {
			switch ( _step ) {
			case 0:
				_x -= 1;
				if ( _x <= 0 ) {
					_step = 1;
				}
				break;
			case 1:
				_x += 1;
				if ( _x >= 540 ) {
					_step = 0;
				}
				break;
			}
		}
		if ( (_elapse % 10) == 1 ) {
			m->eshot->addElement(new EnemyShot(ESHOT_SMALL, cx(), yy, -20, yy, _color, 2));
			m->eshot->addElement(new EnemyShot(ESHOT_SMALL, cx(), yy, 660, yy, _color, 2));
			if ( (m->level % 3) == 2 ) {
				m->eshot->addElement(new EnemyShot(ESHOT_SMALL, cx(), 480 - yy, -20, 480 - yy, _color, 2));
				m->eshot->addElement(new EnemyShot(ESHOT_SMALL, cx(), 480 - yy, 660, 480 - yy, _color, 2));
			}
			if ( flag ) {
				yy += 40; if ( yy >= 460 ) flag = FALSE;
			} else {
				yy -= 40; if ( yy <=  20 ) flag = TRUE;
			}
		}
		switch ( m->level % 3 ) {
		case 0:
			if ( (m->level / 3) == 2 ) {
				// Random [hI
				if ( (_elapse % 100) == 99 ) {
					_color++; if ( _color > 2 ) _color = 0;
				}
			} else {
				if ( (_elapse % 300) == 299 ) {
					_color++; if ( _color > 2 ) _color = 0;
				}
			}
			break;
		case 1:
			if ( (m->level / 3) == 2 ) {
				// Random [hI
				if ( (_elapse % 50) == 49 ) {
					_color++; if ( _color > 2 ) _color = 0;
				}
			} else {
				if ( (_elapse % 100) == 99 ) {
					_color++; if ( _color > 2 ) _color = 0;
				}
			}
			break;
		case 2:
			if ( m->enemy->size() == 1 ) {
				if ( (m->level / 3) == 2 ) {
					// Random [hI
					if ( (_elapse % 50) == 49 ) {
						_color++; if ( _color > 2 ) _color = 0;
					}
				} else {
					if ( (_elapse % 100) == 99 ) {
						_color++; if ( _color > 2 ) _color = 0;
					}
				}
			} else {
				if ( (m->level / 3) == 2 ) {
					// Random [hI
					if ( (_elapse % 100) == 99 ) {
						_color++; if ( _color > 2 ) _color = 0;
					}
				} else {
					if ( (_elapse % 300) == 299 ) {
						_color++; if ( _color > 2 ) _color = 0;
					}
				}
			}
			break;
		}
		break;
	case ENEMY_BOSS_3_2/*{XRR*/:
		if ( (_elapse % 2) == 1 ) {
			switch ( _step ) {
			case 0:
				_y -= 1;
				if ( _y <= 0 ) {
					_step = 1;
				}
				break;
			case 1:
				_y += 1;
				if ( _y >= 380 ) {
					_step = 0;
				}
				break;
			}
		}
		if ( (_elapse % 10) == 1 ) {
			m->eshot->addElement(new EnemyShot(ESHOT_SMALL, xx, cy(), xx, -20, _color, 2));
			m->eshot->addElement(new EnemyShot(ESHOT_SMALL, xx, cy(), xx, 500, _color, 2));
			if ( (m->level % 3) == 2 ) {
				m->eshot->addElement(new EnemyShot(ESHOT_SMALL, 640 - xx, cy(), 640 - xx, -20, _color, 2));
				m->eshot->addElement(new EnemyShot(ESHOT_SMALL, 640 - xx, cy(), 640 - xx, 500, _color, 2));
			}
			if ( flag ) {
				xx += 40; if ( xx >= 620 ) flag = FALSE;
			} else {
				xx -= 40; if ( xx <=  20 ) flag = TRUE;
			}
		}
		if ( (m->level % 3) == 1 ) {
			if ( (m->level / 3) == 2 ) {
				// Random [hI
				if ( (_elapse % 50) == 49 ) {
					_color++; if ( _color > 2 ) _color = 0;
				}
			} else {
				if ( (_elapse % 100) == 99 ) {
					_color++; if ( _color > 2 ) _color = 0;
				}
			}
		} else {
			if ( (m->level / 3) == 2 ) {
				// Random [hI
				if ( (_elapse % 100) == 99 ) {
					_color++; if ( _color > 2 ) _color = 0;
				}
			} else {
				if ( (_elapse % 300) == 299 ) {
					_color++; if ( _color > 2 ) _color = 0;
				}
			}
		}
		break;
	case ENEMY_RAY/*C*/:
		if ( (_life <= 0) && (_step < 5) ) {
m->play_sound(SE_DOWN);
			_step = 5;
		}
		switch ( _step ) {
		case 0:
			_x += 6;
			if ( _x >= 580 ) {
				next_step();
			}
			if ( (m->level % 3) == 2 ) {
				if ( (_elapse % 10) == 1 ) {
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), m->jiki->cx(), m->jiki->cy(), 3, 8));
				}
			}
			break;
		case 1:
			if ( _elapse >= 50 ) {
				_x0 = cx();
				_y0 = cy();
				x1 = (m->rand() % 160) + 320;
				y1 = (m->rand() % 120) + 240;
				r = atan2((double)(y1 - _y0), (double)(x1 - _x0));
				next_step();
			}
			break;
		case 2:
			m->move(_x0, _y0, x1, y1, _elapse * 5);
			_x = m->move_x() - 30;
			_y = m->move_y() - 30;
			if ( (_elapse % 10) == 1 ) {
				m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), m->jiki->cx(), m->jiki->cy(), 3, 8));
			}
			if ( (_x >= 20) && (_x <= 560) && (_y >= 20) && (_y <= 400) ) {
				_step++;
			}
			break;
		case 3:
			m->move(_x0, _y0, x1, y1, _elapse * 5);
			_x = m->move_x() - 30;
			_y = m->move_y() - 30;
			if ( (_elapse % 10) == 1 ) {
				m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), m->jiki->cx(), m->jiki->cy(), 3, 8));
			}
			if ( (_x < 20) || (_x > 560) || (_y < 20) || (_y > 400) ) {
				r = atan2((double)(m->jiki->cy() - cy()), (double)(m->jiki->cx() - cx()));
				p0 = m->pattern(cx(), cy(), m->jiki->cx(), m->jiki->cy());
				p = p0;
				next_step();
			}
			break;
		case 4:
			if ( ((_elapse % 100) > 25) && ((_elapse % 100) <= 75) ) {
				r += 0.0314159265358979;
				if ( (_elapse % 5) == 0 ) {
					p0++;
				}
			} else {
				r -= 0.0314159265358979;
				if ( (_elapse % 5) == 0 ) {
					p0--;
				}
			}
			if ( (_elapse % 5) == 0 ) {
				if ( p0 < 0 ) {
					p = p0 + 40;
				} else if ( p0 >= 40 ) {
					p = p0 - 40;
				} else {
					p = p0;
				}
				m->eshot->addElement(new EnemyShot(ESHOT_LARGE, cx() + CIRCLE_X[p] / 2, cy() + CIRCLE_Y[p] / 2, cx() + CIRCLE_X[p], cy() + CIRCLE_Y[p], _color, 4));
			}
			switch ( m->level % 3 ) {
			case 2:
				if ( (_elapse % 25) == 1 ) {
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), m->jiki->cx(), m->jiki->cy(), 3, 6));
				}
				// ̂܂܉ɗ
			case 1:
				if ( (_elapse % 50) == 1 ) {
					m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), m->jiki->cx(), m->jiki->cy(), 3, 3));
				}
				break;
			}
			if ( (m->level / 3) == 2 ) {
				// Random [hI
				if ( (_elapse % 50) == 35 ) {
					m->next_color(&_color);
				}
			} else {
				if ( (_elapse % 100) == 70 ) {
					m->next_color(&_color);
				}
			}
			if ( _elapse > 200 ) {
				_step = 1;
				_elapse = 0;
			}
			break;
		case 5:
			_x0 = cx();
			_y0 = cy();
			x1 = -320;
			y1 = (m->rand() % 240) + 240;
			next_step();
			break;
		case 6:
			m->move(_x0, _y0, x1, y1, _elapse * 2);
			_x = m->move_x() - 30;
			_y = m->move_y() - 30;
			if ( _x < -60 ) {
				return FALSE;
			}
			break;
		}
		break;
	case ENEMY_RAX/*NX*/:
		if ( (_life <= 0) && (_step < 50) ) {
m->play_sound(SE_DOWN);
			_step = 50;
		}
		if ( (_step >= 10) && (_step < 50) ) {
			if ( (m->level % 3) == 2 ) {
				if ( (_elapse % 15) == 1 ) {
					shot = 1;
					sx0 = cx();
					sy0 = cy();
					sx1 = m->jiki->cx();
					sy1 = m->jiki->cy();
				}
			} else {
				if ( (_elapse % 25) == 1 ) {
					shot = 1;
					sx0 = cx();
					sy0 = cy();
					sx1 = m->jiki->cx();
					sy1 = m->jiki->cy();
				}
			}
		}
		if ( shot > 0 ) {
			if ( (_elapse % 5) == 0 ) {
				m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, sx0, sy0, sx1, sy1, 3, 8));
				shot++;
				if ( shot > 3 ) {
					shot = 0;
				}
			}
		}
		switch ( _step ) {
		case 0:
			_y -= 3;
			if ( _y <= 384 ) {
				next_step();
			}
			break;
		case 1:
			if ( _elapse >= 50 ) {
				if ( m->rand() < 0 ) {
					_step = 10;
				} else {
					_step = 11;
				}
				_elapse = 0;
			}
			break;
		case 2:
			m->next_color(&_color);
			next_step();
			// ̂܂܉ɗ
		case 3:
			if ( (m->level % 3) == 2 ) {
				if ( (_elapse % 5) == 0 ) {
					_elapse2++;
					if ( (_elapse2 % 3) == 1 ) {
						m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), (m->rand() % 320) + 320, (m->rand() % 240) + 240, 3, 6));
					} else {
						if ( (m->level / 3) == 2 ) {
							// Random [hI
							m->next_color(&_color);
						}
						m->eshot->addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), (m->rand() % 320) + 320, (m->rand() % 240) + 240, _color, 8));
					}
				}
				if ( (m->level % 3) >= 1 ) {
					if ( (_elapse % 20) == 1 ) {
						m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), (m->rand() % 320) + 320, (m->rand() % 240) + 240, 3, 4));
					}
				}
			} else {
				if ( _elapse < 100 ) {
					if ( (_elapse % 5) == 0 ) {
						_elapse2++;
						if ( (_elapse2 % 3) == 1 ) {
							m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), (m->rand() % 320) + 320, (m->rand() % 240) + 240, 3, 4));
						} else {
							if ( (m->level / 3) == 2 ) {
								// Random [hI
								m->next_color(&_color);
							}
							m->eshot->addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), (m->rand() % 320) + 320, (m->rand() % 240) + 240, _color, 6));
						}
					}
					if ( (m->level % 3) >= 1 ) {
						if ( (_elapse % 20) == 1 ) {
							m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), (m->rand() % 320) + 320, (m->rand() % 240) + 240, 3, 2));
						}
					}
				}
			}
			if ( _elapse > 150 ) {
				if ( m->rand() < 0 ) {
					_step = ((old_step % 10) == 0) ? (old_step + 1) : (old_step - 1);
				} else {
					switch ( old_step ) {
					case 10:
					case 20:
					case 30:
						_step = old_step + 10;
						break;
					case 40:
						_step = 10;
						break;
					case 11:
						_step = 41;
						break;
					case 21:
					case 31:
					case 41:
						_step = old_step - 10;
						break;
					}
				}
				_elapse = 0;
			}
			break;
		case 10:
		case 31:
			_x -= 6;
			if ( _x <= 0 ) {
				_x = 0;
				old_step = _step;
				_step = 2;
			}
			break;
		case 11:
		case 30:
			_x += 6;
			if ( _x >= 544 ) {
				_x = 544;
				old_step = _step;
				_step = 2;
			}
			break;
		case 20:
		case 41:
			_y -= 6;
			if ( _y <= 0 ) {
				_y = 0;
				old_step = _step;
				_step = 2;
			}
			break;
		case 21:
		case 40:
			_y += 6;
			if ( _y >= 384 ) {
				_y = 384;
				old_step = _step;
				_step = 2;
			}
			break;
		case 50:
			_x0 = cx();
			_y0 = cy();
			x1 = -320;
			y1 = (m->rand() % 240) + 240;
			next_step();
			break;
		case 51:
			m->move(_x0, _y0, x1, y1, _elapse * 2);
			_x = m->move_x() - 48;
			_y = m->move_y() - 48;
			if ( _x < -96 ) {
				return FALSE;
			}
			break;
		}
		break;
	case ENEMY_EXE/*GNZ*/:
		m->score_lock = FALSE;
		if ( (_life <= 0) && (_step < 5) ) {
m->play_sound(SE_DOWN);
			_step = 5;
		}
		switch ( _step ) {
		case 0:
			_y += 1;
			if ( _y >= 216 ) {
				next_step();
			}
			break;
		case 1:
			if ( m->rand() < 0 ) {
				if ( m->rand() < 0 ) {
					xx = -32;
				} else {
					xx = 240;
				}
				m->exe_y += 80 + (m->rand() % 40); if ( m->exe_y >= 210 ) m->exe_y -= 210;
				yy = m->exe_y;
			} else {
				m->exe_x += 80 + (m->rand() % 40); if ( m->exe_x >= 210 ) m->exe_x -= 210;
				xx = m->exe_x;
				if ( m->rand() < 0 ) {
					yy = -32;
				} else {
					yy = 240;
				}
			}
			m->next_color(&(m->exe_color));
			m->enemy->addElement(new Enemy(ENEMY_ZAKO_6_2, xx * 8 / 3, yy * 2, m->exe_color, 10));

			_x0 = _x + 24;
			_y0 = _y + 24;
			x1 = (m->rand() % 296) + 320;
			y1 = (m->rand() % 216) + 240;
			_step = 2;
			// ̂܂܉ɗ
		case 2:
			if ( (_elapse % 100) == 0 ) {
				_step = 1;
				break;
			}
			if ( (_elapse % 30) == 1 ) {
				m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), (m->rand() % 240) + 240, (m->rand() % 240) + 240, 3, 3));
			}
			if ( (m->level / 3) == 2 ) {
				// Random [hI
				if ( (_elapse % 30) == 16 ) {
					m->next_color(&(m->exe_color));
					m->eshot->addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), (m->rand() % 240) + 240, (m->rand() % 240) + 240, m->exe_color, 3));
				}
			}
			m->move(_x0, _y0, x1, y1, _elapse % 100);
			_x = m->move_x() - 24;
			_y = m->move_y() - 24;
			if ( _x <   0 ) _x =   0;
			if ( _x > 592 ) _x = 592;
			if ( _y <   0 ) _y =   0;
			if ( _y > 432 ) _y = 432;
			r = atan2((double)(m->jiki->cy() - cy()), (double)(m->jiki->cx() - cx()));
			if ( (_elapse % 600) == 599 ) {
				next_step();
			}
			break;
		case 3:
			m->score_lock = TRUE;
			{
				double tmp = m->exe_r;
				m->exe_r = atan2((double)(m->jiki->cy() - cy()), (double)(m->jiki->cx() - cx()));
				flag = (tmp < m->exe_r) ? TRUE : FALSE;
				if ( _elapse <= 80 ) {
					r = m->exe_r;
				}
			}
			if ( (_elapse <= 107) && ((_elapse % 5) == 0) ) {
				m->tame->addElement(new Tame(cx(), cy(), _color));
			}
			if ( _elapse >= 120 ) {
m->play_sound(SE_BEAM);
				next_step();
			}
			break;
		case 4:
			m->score_lock = TRUE;
			if ( flag ) {
				r += 0.01 * (double)((m->level % 3) + 1);
			} else {
				r -= 0.01 * (double)((m->level % 3) + 1);
			}
			for ( i = 1; i <= 32; i++ ) {
				m->move(cx(), cy(), cx() + (int)(cos(r) * 100.0), cy() + (int)(sin(r) * 100.0), i * 24);
				m->eshot->addElement(new EnemyShot(ESHOT_BEAM, m->move_x(), m->move_y(), 0, 0, _color, 0));
				if ( i == 1 ) {
					if ( (_elapse % 10) == 1 ) {
						if ( (m->level % 3) == 0 ) {
							m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, m->move_x(), m->move_y(), (m->rand() % 240) + 240, (m->rand() % 240) + 240, 3, 3));
							if ( (m->level / 3) == 2 ) {
								// Random [hI
								m->next_color(&(m->exe_color));
								m->eshot->addElement(new EnemyShot(ESHOT_SMALL, m->move_x(), m->move_y(), (m->rand() % 240) + 240, (m->rand() % 240) + 240, m->exe_color, 3));
							}
						} else {
							m->eshot->addElement(new EnemyShot(ESHOT_NORMAL, m->move_x(), m->move_y(), (m->rand() % 240) + 240, (m->rand() % 240) + 240, 3, 5));
							if ( (m->level / 3) == 2 ) {
								// Random [hI
								m->next_color(&(m->exe_color));
								m->eshot->addElement(new EnemyShot(ESHOT_SMALL, m->move_x(), m->move_y(), (m->rand() % 240) + 240, (m->rand() % 240) + 240, m->exe_color, 5));
							}
						}
					}
				}
			}
			if ( _elapse >= 120 ) {
				_step = 1;
				_elapse = 0;
			}
			break;
		case 5:
			_x0 = cx();
			_y0 = cy();
			x1 = -320;
			y1 = (m->rand() % 240) + 240;
			next_step();
			break;
		case 6:
			m->move(_x0, _y0, x1, y1, _elapse * 2);
			_x = m->move_x() - 24;
			_y = m->move_y() - 24;
			if ( _x < -48 ) {
				return FALSE;
			}
			break;
		}
		break;
	}
	return TRUE;
}

void Enemy::draw(int id, int id_f, int dx, int dy, int sx, int sy, int width, int height) {
	g->drawImage(m->use_image(id), dx, dy, sx, sy, width, height);
	if ( ((m->elapse() / 4) % 2) == 0 ) {
		g->drawImage(m->use_image(id_f), dx, dy, sx, sy, width, height);
	}
}
void Enemy::draw() {
	switch ( _type ) {
	case ENEMY_ZAKO_1:
		draw(DATA_ZAKO1, DATA_ZAKO1_F, _x, _y, 64 * (m->m_elapse % 9), 192 * ((m->m_elapse % 18) / 9) + 64 * _color, 64, 64);
		break;
	case ENEMY_ZAKO_2:
		draw((_x0 < 0) ? DATA_ZAKO2_2 : DATA_ZAKO2_1, (_x0 < 0) ? DATA_ZAKO2_2_F : DATA_ZAKO2_1_F, _x, _y, 384 * ((m->m_elapse % 18) / 9) + 128 * _color, 64 * (m->m_elapse % 9), 128, 64);
		break;
	case ENEMY_ZAKO_3:
		if ( (_x0 >= 0) && (_x0 < 640) ) {
			draw(DATA_ZAKO3_2, DATA_ZAKO3_2_F, _x, _y, 32 * (m->m_elapse % 18), 160 * _color, 32, 160);
			draw(DATA_ZAKO3_2, DATA_ZAKO3_2_F, _x + 12, (_y0 < 0) ? (_y - 472) : (_y + 152), 576 + _color * 8, 0, 8, 480);
		} else {
			draw(DATA_ZAKO3_1, DATA_ZAKO3_1_F, _x, _y, 160 * _color, 32 * (m->m_elapse % 18), 160, 32);
			draw(DATA_ZAKO3_1, DATA_ZAKO3_1_F, (_x0 < 0) ? (_x - 504) : (_x + 152), _y + 12, 0, 576 + _color * 8, 512, 8);
		}
		break;
	case ENEMY_ZAKO_4:
		xx = 0;
		switch ( m->m_elapse % 20 ) {
		case 0:
			xx = 0;
			break;
		case 1:
		case 19:
			xx = 80;
			break;
		case 2:
		case 18:
			xx = 160;
			break;
		case 3:
		case 17:
			xx = 240;
			break;
		case 4:
		case 16:
			xx = 320;
			break;
		case 5:
		case 15:
			xx = 400;
			break;
		case 6:
		case 14:
			xx = 480;
			break;
		case 7:
		case 13:
			xx = 560;
			break;
		case 8:
		case 12:
			xx = 640;
			break;
		case 9:
		case 11:
			xx = 720;
			break;
		case 10:
			xx = 800;
			break;
		}
		draw((_x0 > x1) ? DATA_ZAKO4_1 : DATA_ZAKO4_2, (_x0 > x1) ? DATA_ZAKO4_1_F : DATA_ZAKO4_2_F, _x, _y, xx, 64 * _color, 80, 64);
		break;
	case ENEMY_ZAKO_5:
		draw(DATA_ZAKO5, DATA_ZAKO5_F, _x, _y, 80 * (m->m_elapse % 10), 300 * ((m->m_elapse % 30) / 10) + 100 * _color, 80, 100);
		break;
	case ENEMY_ZAKO_6_1:
	case ENEMY_ZAKO_6_2:
		draw(DATA_ZAKO6, DATA_ZAKO6_F, _x, _y, 0, 64 * _color, 64, 64);
		break;
	case ENEMY_BOSS_1:
		switch ( (m->m_elapse % 15) / 5 ) {
		case 0:
			draw(DATA_BOSS1_1, DATA_BOSS1_1_F, _x, _y, 160 * (m->m_elapse % 5), 160 * _color, 160, 160);
			break;
		case 1:
			draw(DATA_BOSS1_2, DATA_BOSS1_2_F, _x, _y, 160 * (m->m_elapse % 5), 160 * _color, 160, 160);
			break;
		case 2:
			draw(DATA_BOSS1_3, DATA_BOSS1_3_F, _x, _y, 160 * (m->m_elapse % 5), 160 * _color, 160, 160);
			break;
		}
		break;
	case ENEMY_BOSS_2:
		switch ( (m->m_elapse % 15) / 5 ) {
		case 0:
			draw(DATA_BOSS2_1, DATA_BOSS2_1_F, _x, _y, 160 * (m->m_elapse % 5), 160 * _color, 160, 160);
			break;
		case 1:
			draw(DATA_BOSS2_2, DATA_BOSS2_2_F, _x, _y, 160 * (m->m_elapse % 5), 160 * _color, 160, 160);
			break;
		case 2:
			draw(DATA_BOSS2_3, DATA_BOSS2_3_F, _x, _y, 160 * (m->m_elapse % 5), 160 * _color, 160, 160);
			break;
		}
		break;
	case ENEMY_BOSS_3_1:
		draw(DATA_BOSS3_1, DATA_BOSS3_1_F, _x, _y      , 100 * (m->m_elapse % 10), 320 * _color, 100, 320);
		draw(DATA_BOSS3_1, DATA_BOSS3_1_F, _x, _y + 320, 100 * (m->m_elapse % 10), 320 * _color, 100, 320);
		break;
	case ENEMY_BOSS_3_2:
		draw(DATA_BOSS3_2, DATA_BOSS3_2_F, _x      , _y, 320 * _color, 100 * (m->m_elapse % 10), 320, 100);
		draw(DATA_BOSS3_2, DATA_BOSS3_2_F, _x + 320, _y, 320 * _color, 100 * (m->m_elapse % 10), 320, 100);
		break;
	case ENEMY_RAY:
		switch ( _step ) {
		case 0:
		case 1:
			g->drawImage(m->use_image(DATA_RAY1), _x, _y, 0, 0, 60, 60);
			break;
		case 2:
		case 3:
			g->setRot(r);
			if ( (r > -1.5707963267949) && (r < 1.5707963267949) ) {
				g->drawImage(m->use_image(DATA_RAY1), _x, _y, 0, 0, 60, 60);
			} else {
				g->drawImage(m->use_image(DATA_RAY1_2), _x, _y, 0, 0, 60, 60);
			}
			g->setRot(0.0);
			break;
		case 4:
			g->setRot(r);
			g->drawImage(m->use_image(DATA_RAY2), _x, _y, 0, 0, 60, 60);
			g->setRot(0.0);
			break;
		case 5:
		case 6:
			g->setRot(0.0 - (double)_elapse / 6.0);
			g->drawImage(m->use_image(DATA_RAY3), _x, _y, 0, 0, 60, 60);
			g->setRot(0.0);
			break;
		}
		break;
	case ENEMY_RAX:
		switch ( _step ) {
		case 0:
		case 1:
			g->setRot(atan2(-1.0, 0.0));
			g->drawImage(m->use_image(DATA_RAX1), _x, _y, 0, 0, 96, 96);
			g->setRot(0.0);
			break;
		case 50:
		case 51:
			g->setRot(0.0 - (double)_elapse / 6.0);
			g->drawImage(m->use_image(DATA_RAX2), _x, _y, 0, 0, 96, 96);
			g->setRot(0.0);
			break;
		default:
			g->setRot(atan2((double)(cy() - 240), (double)(cx() - 320)));
			g->drawImage(m->use_image(DATA_RAX1), _x, _y, 0, 0, 96, 96);
			g->setRot(0.0);
			break;
		}
		break;
	case ENEMY_EXE:
		switch ( _step ) {
		case 0:
			g->drawImage(m->use_image(DATA_EXE1), _x, _y, 48 * ((m->elapse() / 5) % 2), 0, 48, 48);
			break;
		case 1:
		case 2:
			g->setRot(r);
			if ( (r > -1.5707963267949) && (r < 1.5707963267949) ) {
				g->drawImage(m->use_image(DATA_EXE2), _x, _y, 48 * ((m->elapse() / 5) % 2), 0, 48, 48);
			} else {
				g->drawImage(m->use_image(DATA_EXE2_2), _x, _y, 48 * ((m->elapse() / 5) % 2), 0, 48, 48);
			}
			g->setRot(0.0);
			break;
		case 3:
		case 4:
			g->setRot(r);
			if ( (r > -1.5707963267949) && (r < 1.5707963267949) ) {
				g->drawImage(m->use_image(DATA_EXE3), _x, _y, 0, 0, 48, 48);
			} else {
				g->drawImage(m->use_image(DATA_EXE3_2), _x, _y, 0, 0, 48, 48);
			}
			if ( _step == 4 ) {
				g->drawImage(m->use_image(DATA_SPECIAL), cx() - 24, cy() - 24, -24, 48 * ((m->elapse() / 5) % 3), 1024, 48, 24.0f, 24.0f);
			}
			g->setRot(0.0);
			break;
		case 5:
		case 6:
			g->setRot(0.0 - (double)_elapse / 6.0);
			g->drawImage(m->use_image(DATA_EXE1), _x, _y, 96, 0, 48, 48);
			g->setRot(0.0);
			break;
		}
		break;
	}
#ifdef SHOW_AREA
	m->drawArea(left(), top(), right() - left() + 1, bottom() - top() + 1);
#endif // SHOW_AREA
}
