/*
 * D2DX
 * Copyright (C) SatisKia. All rights reserved.
 */

#ifndef _IMAGEINFO_HPP
#define _IMAGEINFO_HPP

#include <windows.h>

#include "_Object.hpp"

class _ImageInfo : public _Object
{
public:
	int		rop;
	FLOAT	scaleX;
	FLOAT	scaleY;
	FLOAT	rot;
	int		flip;
	int		alpha;
	int		bright;

	BOOL	full;
	FLOAT	dx;
	FLOAT	dy;
	int		sx;
	int		sy;
	int		width;
	int		height;
	FLOAT	cx;
	FLOAT	cy;

public:
	_ImageInfo(){}
	_ImageInfo( _ImageInfo* info )
	{
		set( info );
	}
	void set( _ImageInfo* info )
	{
		rop    = info->rop;
		scaleX = info->scaleX;
		scaleY = info->scaleY;
		rot    = info->rot;
		flip   = info->flip;
		alpha  = info->alpha;
		bright = info->bright;

		full   = info->full;
		dx     = info->dx;
		dy     = info->dy;
		sx     = info->sx;
		sy     = info->sy;
		width  = info->width;
		height = info->height;
		cx     = info->cx;
		cy     = info->cy;
	}
};

#endif // _IMAGEINFO_HPP
