unit GikoMessage;

interface

uses
	Classes, IniFiles;

type
	//! MessageList
	TGikoMessageListType = (gmLogout, gmLogin, gmForceLogin, gmSureItiran,
			gmUnKnown, gmSureSyutoku, gmSureDiff, gmNotMod, gmAbort, gmError,
			gmNewRes, gmNewSure, gmResError, gmSureError);

	TGikoMessage = class(THashedStringList)
	private
	public
		constructor Create;
		function GetMessage(MesType: TGikoMessageListType): String;
	end;

implementation

const
	DEF_MESSAGES : array[0..13] of string = (  'OAEg܂',
											   'OC܂ - ',
											   'OC܂ - ',
											   '[Xꗗ擾]',
											   '(̕sj',
											   '[X擾]',
											   '[X擾]',
											   '[XV]',
											   '[f]',
											   '[G[]',
											   '[XMI]',
											   '[VXMI]',
											   '[XMs]',
											   '[VXMs]');

	MESSAGE_KEYS : array[0..13] of String = ( 'Logout', 'Login',
											'ForceLogin', 'SureItiran',
											'UnKnown', 'SureSyutoku',
											'SureDiff', 'NotMod',
											'Abort', 'Error',
											'NewRes', 'NewSure',
											'ResError', 'SureError');

constructor TGikoMessage.Create;
begin
	inherited Create;
	Self.Sorted := true;
	Self.Duplicates := dupIgnore;
end;
//! MesTypeŎw肳ꂽbZ[W擾
function TGikoMessage.GetMessage(MesType: TGikoMessageListType): String;
begin
	Result := '';
	if MesType in [gmLogout..gmSureError] then begin
		//KeyŌČ΂Ԃ
		Result := Self.Values[MESSAGE_KEYS[Ord(MesType)]];
		if Result = '' then begin
			//Ȃ̂ŁAftHgŕԂ
			Result := DEF_MESSAGES[Ord(MesType)];
		end;
	end;
end;

end.
 