﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Collections.Generic;
using Formula;
using Formula.Node;
using System.Text;
using System.Reflection;
using Formula.Node.Impl;


namespace UnitTestFormula
{
    [TestClass]
    public class UnitTest論理演算
    {
        public UnitTest論理演算()
        {
            //DllLoader loader = DllLoader.getInstance();
            //loader.Load();
        }

        [TestMethod]
        public void true1()
        {
            Assert.AreEqual(true, FormulaTest.Formula("true", null));
        }
        [TestMethod]
        public void true2()
        {
            Assert.AreEqual("true", FormulaTest.Formula("\"true\"", null));
        }
        [TestMethod]
        public void false1()
        {
            Assert.AreEqual(false, FormulaTest.Formula("false", null));
        }
        [TestMethod]
        public void false2()
        {
            Assert.AreEqual("false", FormulaTest.Formula("\"false\"", null));
        }

        [TestMethod]
        public void IF1()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("if(1,1,0)", null));
        }
        [TestMethod]
        public void IF2()
        {
            Assert.AreEqual(0m, FormulaTest.Formula("if(0,1,0)", null));
        }
        [TestMethod]
        public void IF3()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("if(1+2=3,1,0)", null));
        }
        [TestMethod]
        public void IF4()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("if(1+2<=3,1,0)", null));
        }
        [TestMethod]
        public void IF5()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("if(2+3*2=8,1,0)", null));
        }
        [TestMethod]
        public void IF6()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("if((2+3)*2=10,1,0)", null));
        }
        [TestMethod]
        public void IF7()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("if(\"a\"&\"b\"=\"ab\",1,0)", null));
        }
        [TestMethod]
        public void IF8()
        {
            Assert.AreEqual("aaa", FormulaTest.Formula("if((2+3)*2=10,\"aaa\",0)", null));
        }
        [TestMethod]
        public void IF9()
        {
            Dictionary<string, string> arg = new Dictionary<string, string>();
            arg.Add("a", "1");
            Assert.AreEqual(4m, FormulaTest.Formula("if((2+3)*2=10,a+3,0)", arg));
        }
        [TestMethod]
        public void IF10()
        {
            Dictionary<string, string> arg = new Dictionary<string, string>();
            arg.Add("a", "1");
            Assert.AreEqual(10m, FormulaTest.Formula("if((2+3)*2=10,a+3*3,0)", arg));
        }
        [TestMethod]
        public void IF11()
        {
            Assert.AreEqual(0m, FormulaTest.Formula("if((2+3)*2=11,\"aaa\",0)", null));
        }
        [TestMethod]
        public void IF12()
        {
            Assert.AreEqual(0m, FormulaTest.Formula("if(1+2=4,1,0)", null));
        }
        [TestMethod]
        public void IF13()
        {
            Dictionary<string, string> arg = new Dictionary<string, string>();
            arg.Add("a", "1");
            Assert.AreEqual(10m, FormulaTest.Formula("if((a+3)*2=8,a+3*3,0)", arg));
        }
        [TestMethod]
        public void IF14()
        {
            Dictionary<string, string> arg = new Dictionary<string, string>();
            arg.Add("a", "1");
            arg.Add("b", "2");
            Assert.AreEqual(11m, FormulaTest.Formula("if((a+3)*2=8,b+3*3,0)", arg));
        }
        [TestMethod]
        public void IF15()
        {
            Dictionary<string, string> arg = new Dictionary<string, string>();
            arg.Add("a", "1");
            arg.Add("b", "2");
            Assert.AreEqual(4m, FormulaTest.Formula("if((a+3)*2<8,b+3*3,b+2)", arg));
        }
        [TestMethod]
        public void IF16()
        {
            Assert.AreEqual(7m, FormulaTest.Formula("if(1+2,3+4,5+6)", null));
        }

        [TestMethod]
        public void equal1()
        {
            Assert.AreEqual(true, FormulaTest.Formula("1=1", null));
        }
        [TestMethod]
        public void equal2()
        {
            Assert.AreEqual(false, FormulaTest.Formula("1=0", null));
        }
        [TestMethod]
        public void notEqual1()
        {
            Assert.AreEqual(true, FormulaTest.Formula("1<>0", null));
        }
        [TestMethod]
        public void notEqual2()
        {
            Assert.AreEqual(false, FormulaTest.Formula("1<>1", null));
        }
        [TestMethod]
        public void and1()
        {
            Assert.AreEqual(0m, FormulaTest.Formula("if(and(1,0),1,0)", null));
        }
        [TestMethod]
        public void and2()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("if(and(1,1),1,0)", null));
        }
        [TestMethod]
        public void and3()
        {
            Assert.AreEqual(0m, FormulaTest.Formula("if(and(0,0),1,0)", null));
        }
        [TestMethod]
        public void or1()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("if(or(1,0),1,0)", null));
        }
        [TestMethod]
        public void or2()
        {
            Assert.AreEqual(0m, FormulaTest.Formula("if(or(0,0),1,0)", null));
        }
        [TestMethod]
        public void or3()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("if(or(1,1),1,0)", null));
        }
        [TestMethod]
        public void not1()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("if(not(0),1,0)", null));
        }
        [TestMethod]
        public void not2()
        {
            Assert.AreEqual(0m, FormulaTest.Formula("if(not(1),1,0)", null));
        }
        [TestMethod]
        public void greaterOrEqual1()
        {
            Assert.AreEqual(false, FormulaTest.Formula("1>=2", null));
        }
        [TestMethod]
        public void greaterOrEqual2()
        {
            Assert.AreEqual(true, FormulaTest.Formula("1>=1", null));
        }
        [TestMethod]
        public void greaterOrEqual3()
        {
            Assert.AreEqual(true, FormulaTest.Formula("1>=0", null));
        }
        [TestMethod]
        public void greaterOrEqual4()
        {
            Assert.AreEqual(false, FormulaTest.Formula("1>=", null));
        }
        [TestMethod]
        public void greaterOrEqual5()
        {
            Assert.AreEqual(false, FormulaTest.Formula(">=2", null));
        }
        [TestMethod]
        public void LessOrEqual1()
        {
            Assert.AreEqual(true, FormulaTest.Formula("1<=2", null));
        }
        [TestMethod]
        public void LessOrEqual2()
        {
            Assert.AreEqual(true, FormulaTest.Formula("1<=1", null));
        }
        [TestMethod]
        public void LessOrEqual3()
        {
            Assert.AreEqual(false, FormulaTest.Formula("1<=0", null));
        }
        [TestMethod]
        public void LessOrEqual4()
        {
            Assert.AreEqual(false, FormulaTest.Formula("1<=", null));
        }
        [TestMethod]
        public void LessOrEqual5()
        {
            Assert.AreEqual(false, FormulaTest.Formula("<=2", null));
        }
        [TestMethod]
        public void Less1()
        {
            Assert.AreEqual(true, FormulaTest.Formula("1<2", null));
        }
        [TestMethod]
        public void Less2()
        {
            Assert.AreEqual(false, FormulaTest.Formula("1<1", null));
        }
        [TestMethod]
        public void Less3()
        {
            Assert.AreEqual(false, FormulaTest.Formula("3<2", null));
        }
        [TestMethod]
        public void Less4()
        {
            Assert.AreEqual(false, FormulaTest.Formula("1<", null));
        }
        [TestMethod]
        public void Less5()
        {
            Assert.AreEqual(false, FormulaTest.Formula("<2", null));
        }
        [TestMethod]
        public void greater1()
        {
            Assert.AreEqual(false, FormulaTest.Formula("1>2", null));
        }
        [TestMethod]
        public void greater2()
        {

            Assert.AreEqual(false, FormulaTest.Formula("2>2", null));
        }
        [TestMethod]
        public void greater3()
        {

            Assert.AreEqual(true, FormulaTest.Formula("3>2", null));
        }
        [TestMethod]
        public void greater4()
        {

            Assert.AreEqual(false, FormulaTest.Formula("1>", null));
        }
        [TestMethod]
        public void greater5()
        {
            Assert.AreEqual(false, FormulaTest.Formula(">2", null));
        }
    }
}
