﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Collections.Generic;
using Formula;
using Formula.Node;
using System.Text;
using System.Reflection;
using Formula.Node.Impl;


namespace UnitTestFormula
{
    [TestClass]
    public class UnitTest算術関数
    {
        public UnitTest算術関数()
        {
            //DllLoader loader = DllLoader.getInstance();
            //loader.Load();
        }
        
        [TestMethod]
        public void SUM1()
        {
            Assert.AreEqual(6m, FormulaTest.Formula("sum(3,2,1)", null));
        }

        [TestMethod]
        public void SUM2()
        {

            Assert.AreEqual(5m, FormulaTest.Formula("sum(3,2,0)", null));
        }
        [TestMethod]
        public void SUM3()
        {

            Assert.AreEqual(5m, FormulaTest.Formula("sum(3,2)", null));
        }
        [TestMethod]
        public void SUM4()
        {

            Assert.AreEqual(0.9m, FormulaTest.Formula("sum(3,-2.1,0)", null));
        }
        [TestMethod]
        public void SUM5()
        {

            Assert.AreEqual(0.9m, FormulaTest.Formula("sum(3,(-2.1),0)", null));
        }
        [TestMethod]
        public void PRODUCT1()
        {

            Assert.AreEqual(6m, FormulaTest.Formula("product(3,2,1)", null));
        }

        [TestMethod]
        public void PRODUCT2()
        {

            Assert.AreEqual(0m, FormulaTest.Formula("product(3,2,0)", null));
        }
        [TestMethod]
        public void PRODUCT3()
        {

            Assert.AreEqual(6m, FormulaTest.Formula("product(3,2)", null));
        }
        [TestMethod]
        public void PRODUCT4()
        {

            Assert.AreEqual(0m, FormulaTest.Formula("product(3,-2.1,0)", null));
        }
        [TestMethod]
        public void PRODUCT5()
        {

            Assert.AreEqual(0m, FormulaTest.Formula("product(3,(-2.1),0)", null));
        }
        [TestMethod]
        public void RoundDown_1()
        {

            Assert.AreEqual(0m, FormulaTest.Formula("rounddown(456.456 , -4)", null));
        }

        [TestMethod]
        public void RoundDown_2()
        {

            Assert.AreEqual(0m, FormulaTest.Formula("rounddown(456.456 , -3)", null));
        }

        [TestMethod]
        public void RoundDown_3()
        {

            Assert.AreEqual(400m, FormulaTest.Formula("rounddown(456.456 , -2)", null));
        }

        [TestMethod]
        public void RoundDown_4()
        {

            Assert.AreEqual(450m, FormulaTest.Formula("rounddown(456.456 , -1)", null));
        }

        [TestMethod]
        public void RoundDown_5()
        {

            Assert.AreEqual(456m, FormulaTest.Formula("rounddown(456.456 , 0)", null));
        }

        [TestMethod]
        public void RoundDown_6()
        {

            Assert.AreEqual(456.4m, FormulaTest.Formula("rounddown(456.456 , 1)", null));
        }

        [TestMethod]
        public void RoundDown_7()
        {

            Assert.AreEqual(456.45m, FormulaTest.Formula("rounddown(456.456 , 2)", null));
        }

        [TestMethod]
        public void RoundDown_8()
        {

            Assert.AreEqual(456.456m, FormulaTest.Formula("rounddown(456.456 , 3)", null));
        }

        [TestMethod]
        public void RoundDown_9()
        {

            Assert.AreEqual(456.456m, FormulaTest.Formula("rounddown(456.456 , 4)", null));
        }

        [TestMethod]
        public void RoundDown_10()
        {

            Assert.AreEqual(0m, FormulaTest.Formula("rounddown(-456.456 , -4)", null));
        }

        [TestMethod]
        public void RoundDown_11()
        {

            Assert.AreEqual(0m, FormulaTest.Formula("rounddown(-456.456 , -3)", null));
        }

        [TestMethod]
        public void RoundDown_12()
        {

            Assert.AreEqual(-400m, FormulaTest.Formula("rounddown(-456.456 , -2)", null));
        }

        [TestMethod]
        public void RoundDown_13()
        {

            Assert.AreEqual(-450m, FormulaTest.Formula("rounddown(-456.456 , -1)", null));
        }

        [TestMethod]
        public void RoundDown_14()
        {

            Assert.AreEqual(-456m, FormulaTest.Formula("rounddown(-456.456 , 0)", null));
        }

        [TestMethod]
        public void RoundDown_15()
        {

            Assert.AreEqual(-456.4m, FormulaTest.Formula("rounddown(-456.456 , 1)", null));
        }

        [TestMethod]
        public void RoundDown_16()
        {

            Assert.AreEqual(-456.45m, FormulaTest.Formula("rounddown(-456.456 , 2)", null));
        }

        [TestMethod]
        public void RoundDown_17()
        {

            Assert.AreEqual(-456.456m, FormulaTest.Formula("rounddown(-456.456 , 3)", null));
        }

        [TestMethod]
        public void RoundDown_18()
        {

            Assert.AreEqual(-456.456m, FormulaTest.Formula("rounddown(-456.456 , 4)", null));
        }




        [TestMethod]
        public void RoundUp_1()
        {

            Assert.AreEqual(10000m, FormulaTest.Formula("roundup(456.456 , -4)", null));
        }

        [TestMethod]
        public void RoundUp_2()
        {

            Assert.AreEqual(1000m, FormulaTest.Formula("roundup(456.456 , -3)", null));
        }

        [TestMethod]
        public void RoundUp_3()
        {

            Assert.AreEqual(500m, FormulaTest.Formula("roundup(456.456 , -2)", null));
        }

        [TestMethod]
        public void RoundUp_4()
        {

            Assert.AreEqual(460m, FormulaTest.Formula("roundup(456.456 , -1)", null));
        }

        [TestMethod]
        public void RoundUp_5()
        {

            Assert.AreEqual(457m, FormulaTest.Formula("roundup(456.456 , 0)", null));
        }

        [TestMethod]
        public void RoundUp_6()
        {

            Assert.AreEqual(456.5m, FormulaTest.Formula("roundup(456.456 , 1)", null));
        }

        [TestMethod]
        public void RoundUp_7()
        {

            Assert.AreEqual(456.46m, FormulaTest.Formula("roundup(456.456 , 2)", null));
        }

        [TestMethod]
        public void RoundUp_8()
        {

            Assert.AreEqual(456.456m, FormulaTest.Formula("roundup(456.456 , 3)", null));
        }

        [TestMethod]
        public void RoundUp_9()
        {

            Assert.AreEqual(456.456m, FormulaTest.Formula("roundup(456.456 , 4)", null));
        }

        [TestMethod]
        public void RoundUp_10()
        {
            Assert.AreEqual(-10000m, FormulaTest.Formula("roundup(-456.456 , -4)", null));
        }

        [TestMethod]
        public void RoundUp_11()
        {

            Assert.AreEqual(-1000m, FormulaTest.Formula("roundup(-456.456 , -3)", null));
        }

        [TestMethod]
        public void RoundUp_12()
        {

            Assert.AreEqual(-500m, FormulaTest.Formula("roundup(-456.456 , -2)", null));
        }

        [TestMethod]
        public void RoundUp_13()
        {

            Assert.AreEqual(-460m, FormulaTest.Formula("roundup(-456.456 , -1)", null));
        }

        [TestMethod]
        public void RoundUp_14()
        {

            Assert.AreEqual(-457m, FormulaTest.Formula("roundup(-456.456 , 0)", null));
        }

        [TestMethod]
        public void RoundUp_15()
        {

            Assert.AreEqual(-456.5m, FormulaTest.Formula("roundup(-456.456 , 1)", null));
        }

        [TestMethod]
        public void RoundUp_16()
        {

            Assert.AreEqual(-456.46m, FormulaTest.Formula("roundup(-456.456 , 2)", null));
        }

        [TestMethod]
        public void RoundUp_17()
        {

            Assert.AreEqual(-456.456m, FormulaTest.Formula("roundup(-456.456 , 3)", null));
        }

        [TestMethod]
        public void RoundUp_18()
        {

            Assert.AreEqual(-456.456m, FormulaTest.Formula("roundup(-456.456 , 4)", null));
        }





        [TestMethod]
        public void Round1()
        {

            Assert.AreEqual(0m, FormulaTest.Formula("round(456.456 , -4)", null));
        }

        [TestMethod]
        public void Round2()
        {

            Assert.AreEqual(0m, FormulaTest.Formula("round(456.456 , -3)", null));
        }

        [TestMethod]
        public void Round3()
        {

            Assert.AreEqual(500m, FormulaTest.Formula("round(456.456 , -2)", null));
        }

        [TestMethod]
        public void Round4()
        {

            Assert.AreEqual(460m, FormulaTest.Formula("round(456.456 , -1)", null));
        }

        [TestMethod]
        public void Round5()
        {

            Assert.AreEqual(456m, FormulaTest.Formula("round(456.456 , 0)", null));
        }

        [TestMethod]
        public void Round6()
        {

            Assert.AreEqual(456.5m, FormulaTest.Formula("round(456.456 , 1)", null));
        }

        [TestMethod]
        public void Round7()
        {

            Assert.AreEqual(456.46m, FormulaTest.Formula("round(456.456 , 2)", null));
        }

        [TestMethod]
        public void Round8()
        {

            Assert.AreEqual(456.456m, FormulaTest.Formula("round(456.456 , 3)", null));
        }

        [TestMethod]
        public void Round9()
        {

            Assert.AreEqual(456.456m, FormulaTest.Formula("round(456.456 , 4)", null));
        }

        [TestMethod]
        public void Round10()
        {

            Assert.AreEqual(0m, FormulaTest.Formula("round(-456.456 , -4)", null));
        }

        [TestMethod]
        public void Round11()
        {

            Assert.AreEqual(0m, FormulaTest.Formula("round(-456.456 , -3)", null));
        }

        [TestMethod]
        public void Round12()
        {

            Assert.AreEqual(-500m, FormulaTest.Formula("round(-456.456 , -2)", null));
        }

        [TestMethod]
        public void Round13()
        {

            Assert.AreEqual(-460m, FormulaTest.Formula("round(-456.456 , -1)", null));
        }

        [TestMethod]
        public void Round14()
        {

            Assert.AreEqual(-456m, FormulaTest.Formula("round(-456.456 , 0)", null));
        }

        [TestMethod]
        public void Round15()
        {

            Assert.AreEqual(-456.5m, FormulaTest.Formula("round(-456.456 , 1)", null));
        }

        [TestMethod]
        public void Round16()
        {

            Assert.AreEqual(-456.46m, FormulaTest.Formula("round(-456.456 , 2)", null));
        }

        [TestMethod]
        public void Round17()
        {

            Assert.AreEqual(-456.456m, FormulaTest.Formula("round(-456.456 , 3)", null));
        }

        [TestMethod]
        public void Round18()
        {

            Assert.AreEqual(-456.456m, FormulaTest.Formula("round(-456.456 , 4)", null));
        }

        [TestMethod]
        public void Int_1()
        {
            Assert.AreEqual(456m, FormulaTest.Formula("inT(456.456 )", null));
        }

        [TestMethod]
        public void Int_2()
        {
            Assert.AreEqual(-457m, FormulaTest.Formula("INT(-456.456 )", null));
        }
        [TestMethod]
        public void Mod_1()
        {
            Assert.AreEqual(3m, FormulaTest.Formula("mod(3 ,10)", null));
        }
        [TestMethod]
        public void Mod_2()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("mod(31 ,10)", null));
        }
        [TestMethod]
        public void Mod_3()
        {
            Assert.AreEqual(0m, FormulaTest.Formula("mod(0 ,10)", null));
        }
        [TestMethod]
        public void Mod_4()
        {
            Assert.AreEqual(-2.1m, FormulaTest.Formula("mod(-12.1 ,10)", null));
        }
        [TestMethod]
        public void Abs_1()
        {
            Assert.AreEqual(12.1m, FormulaTest.Formula("abs(-12.1)", null));
        }
        [TestMethod]
        public void Abs_2()
        {
            Assert.AreEqual(12.1m, FormulaTest.Formula("abs(12.1)", null));
        }

        [TestMethod]
        public void Average_1()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("average(1)", null));
        }
        [TestMethod]
        public void Average_2()
        {
            Assert.AreEqual(1.5m, FormulaTest.Formula("average(1 , 2)", null));
        }
        [TestMethod]
        public void Average_3()
        {
            Assert.AreEqual(2m, FormulaTest.Formula("average(1 , 2 ,3)", null));
        }
        [TestMethod]
        public void Average_4()
        {
            Assert.AreEqual(2m, FormulaTest.Formula("average(1 , 2 ,3 , \"あ\")", null));
        }
        [TestMethod]
        public void Average_5()
        {
            Assert.AreEqual(2m, FormulaTest.Formula("average(1 , 2 ,3 )", null));
        }
        [TestMethod]
        public void Min_1()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("min(1 , 2 ,3 )", null));
        }
        [TestMethod]
        public void Min_2()
        {
            Assert.AreEqual(-2m, FormulaTest.Formula("min(1 , -2 ,3 )", null));
        }
        [TestMethod]
        public void Min_3()
        {
            Assert.AreEqual(-2m, FormulaTest.Formula("min(1 , \"-2\",3 )", null));
        }
        [TestMethod]
        public void Min_4()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("min(1 , \"あ\",3 )", null));
        }
        [TestMethod]
        public void Min_5()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("min(1 , ,3 )", null));
        }
        [TestMethod]
        public void Min_6()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("min( , 1,3 )", null));
        }
        [TestMethod]
        public void Min_7()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("min( 1, 2, )", null));
        }
        [TestMethod]
        public void Max_1()
        {
            Assert.AreEqual(3m, FormulaTest.Formula("max(1 , 2 ,3 )", null));
        }
        [TestMethod]
        public void Max_2()
        {
            Assert.AreEqual(3m, FormulaTest.Formula("max(1 , -2 ,3 )", null));
        }
        [TestMethod]
        public void Max_3()
        {
            Assert.AreEqual(3m, FormulaTest.Formula("max(1 , -2 ,\"3\" )", null));
        }
        [TestMethod]
        public void Max_4()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("max(1 , -2 ,\"あ\" )", null));
        }
        [TestMethod]
        public void IsError_1()
        {
            Assert.AreEqual(false, FormulaTest.Formula("iserror(1/1)", null));
        }
        [TestMethod]
        public void IsError_2()
        {
            Assert.AreEqual(true, FormulaTest.Formula("iserror(1/0)", null));
        }
    }
}
