﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Collections.Generic;
using Formula;
using Formula.Node;
using System.Text;
using System.Reflection;
using Formula.Node.Impl;


namespace UnitTestFormula
{
    [TestClass]
    public class UnitTest文法チェック
    {
        public UnitTest文法チェック()
        {
            //DllLoader loader = DllLoader.getInstance();
            //loader.Load();
        }
        

        [TestMethod]
        public void check_1()
        {
            Assert.AreEqual(false, FormulaTest.isError("1*1"));
        }
        [TestMethod]
        public void check_2()
        {
            Assert.AreEqual(true, FormulaTest.isError("1*\"1\""));
        }
        [TestMethod]
        public void check_3()
        {
            Assert.AreEqual(false, FormulaTest.isError("1+1"));
        }
        [TestMethod]
        public void check_4()
        {
            Assert.AreEqual(false, FormulaTest.isError("-1"));
        }
        [TestMethod]
        public void check_5()
        {
            Assert.AreEqual(false, FormulaTest.isError("sum(1 , 2 , 3 , 4)"));
        }
        [TestMethod]
        public void check_6()
        {
            Assert.AreEqual(true, FormulaTest.isError("sum(1 , 2 , 3 , \"4\")"));
        }

        [TestMethod]
        public void check_7()
        {
            Assert.AreEqual(true, FormulaTest.isError("sum(trim(3))"));
        }
        [TestMethod]
        public void check_8()
        {
            Assert.AreEqual(false, FormulaTest.isError("sum(1 , 2 , 3 , abs(3))"));
        }
        [TestMethod]
        public void check_9()
        {
            Assert.AreEqual(false, FormulaTest.isError("sum(int(3))"));
        }
        [TestMethod]
        public void check_10()
        {
            Assert.AreEqual(true, FormulaTest.isError("sum(,,,,)"));
        }
        [TestMethod]
        public void check_14()
        {
            Assert.AreEqual(true, FormulaTest.isError("sum(int(3),\"あ\")"));
        }
        [TestMethod]
        public void check_11()
        {
            Assert.AreEqual(false, FormulaTest.isError("-"));
        }
        [TestMethod]
        public void check_12()
        {
            Assert.AreEqual(false, FormulaTest.isError("(-1)"));
        }
        [TestMethod]
        public void check_13()
        {
            Assert.AreEqual(false, FormulaTest.isError("(1-1)"));
        }
        [TestMethod]
        public void check_15()
        {
            Assert.AreEqual(true, FormulaTest.isError("1 +2*"));
        }
        [TestMethod]
        public void check_16()
        {
            Assert.AreEqual(false, FormulaTest.isError("1+(2+3)*4)*"));
        }
        [TestMethod]
        public void check_特殊な式_1()
        {
            Assert.AreEqual(false, FormulaTest.isError(@"if(
find(""("",$1,1)>0
, mid($1, find(""("",$1, 1)+1, find("")"",$1, 1)-find(""("",$1, 1)-1)
, ""-""
)"));
        }
    }
}
