﻿/**
FormulaOperator.Variable.BoolNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;

namespace FormulaOperator.Variable
{
    public class BoolNode : AbstractValueNode
    {
        public override object Value
        {
            get { return this.getBoolean(); }
            set { base.Value = value; }
        }
        public override string Regex
        {
            get
            {
                return "^(TRUE|FALSE)$";
            }
        }
        public override string ToString()
        {
            return string.Format("{0}:[B:{1}-{2}] {3}", this.nodeId , this.startPosition , this.endPosition , this.Value);
        }
    }
}
