﻿/**
FormulaOperator.Operator.SeparatorNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using System;

namespace FormulaOperator.Operator
{
    /// <summary>
    /// メソッド引数を区別するための「,」
    /// </summary>
    public class SeparatorNode : AbstractOperatorNode , ISeparatorNode
    {
        private static string[] signature = { "," };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(IValueNode), typeof(IValueNode) }; } }
        public override Type ReturnNode { get { return typeof(IValueNode); } }
        public override bool IsPermitLeftNodeBlank { get { return false; } }
        public override string Note { get { return @"関数の引数を分けるための演算子です"; } }
        protected override INode execute()
        {
            throw new NotImplementedException();
        }
        public override int priority
        {
            get { return -2; }
        }
    }
}
