﻿/**
FormulaOperator.Operator.BracketNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using System;
using System.Collections.Generic;

namespace FormulaOperator.Operator
{
    /// <summary>
    /// 括弧を表現するノード。
    /// ほかのノードと違い、子供を一つしか持たない。
    /// </summary>
    public class BracketNode :
         AbstractOperatorNode , IBracketNode
    //AbstractFunctionNode, IBracketNode
    {
        private static string[] signature = { "(", ")" };
        public override string[] Signature { get { return signature; } }
        public string OpenBracket { get { return "("; } }
        public string CloseBracket { get { return ")"; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(INode)}; } }
        public override Type ReturnNode { get { return typeof(INode); } }
        public override bool IsPermitLeftNodeBlank { get { return false; } }
        protected override INode execute()
        {
            List<INode> arglist = this.Args;
            return arglist[0].eval();
        }

        public override int priority
        {
            get { return -2; }
        }


    }
}
