﻿/**
FormulaOperator.Logical.GreaterOrEqualNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using FormulaOperator.Variable;
using System;

namespace FormulaOperator.Logical
{
    public class GreaterOrEqualNode : AbstractOperatorNode
    {
        private static string[] signature = { ">=" };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(NumberNode), typeof(NumberNode) }; } }
        public override Type ReturnNode { get { return typeof(BoolNode); } }
        public override bool IsPermitLeftNodeBlank { get { return false; } }
        public override string Note { get { return @"右辺と左辺とそれぞれ数値として評価し、左辺≧右辺のときTRUEを返します。"; } }
        protected override INode execute()
        {
            bool ret = true;
            if (this.getLeftNode() == null || this.getLeftNode() is BlankNode) ret = false;
            else if (this.getRightNode() == null || this.getRightNode() is BlankNode) ret = false;
            else
                ret = (decimal?)((NumberNode)this.getLeftNode().eval()).Value
                    >= (decimal?)((NumberNode)this.getRightNode().eval()).Value;

            BoolNode v = new BoolNode();
            v.Value = ret;
            return v;
        }

        public override int priority
        {
            get { return -1; }
        }
    }
}
