﻿/**
FormulaOperator.Logical.EqualNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using FormulaOperator.Variable;
using System;

namespace FormulaOperator.Logical
{
    public class EqualNode : AbstractOperatorNode
    {
        private static string[] signature = { "=" };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(IValueNode), typeof(IValueNode) }; } }
        public override Type ReturnNode { get { return typeof(BoolNode); } }
        public override bool IsPermitLeftNodeBlank { get { return false; } }
        public override string Note { get { return @"右辺と左辺が等しいとき、TRUEを返します"; } }
        protected override INode execute()
        {
            bool ret = true;
            string before = null;
            foreach (INode a in this.Args)
            {
                string current = ((IValueNode)a.eval()).Value.ToString();
                if (before == null)
                {
                    before = current;
                    continue;
                }
                ret = current == before;
                if (!ret) break;
            }

            BoolNode v = new BoolNode();
            v.Value = ret;
            return v;
        }

        public override int priority
        {
            get { return -1; }
        }
    }
}
