﻿/**
FormulaDebugger.NodeSplitterVisitor

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;

namespace FormulaDebugger
{
    public class NodeSplitterVisitor
    {
        public INode Target { get; set; }
        public string Header { get; set; }
        public int Id { get; set; }
        public string idString { get; set; }

        public NodeSplitterVisitor()
        {
            this.Header = string.Empty;
        }

        public virtual string currentNodeString()
        {
            string ret;
            if (this.Target == null)
                ret = string.Format("{0}-null-", this.Header);
            else
                ret = string.Format("{0}{1}", this.Header, this.Target.ToString());
            if (this.Target != null && this.Id == this.Target.nodeId)
                this.idString = ret;
            return ret;
        }

        public string visit(INode target = null)
        {
            if (target != null) this.Target = target;
            string ret = this.currentNodeString();
            
            if(this.Target is IMethodNode)
            {
                for (int i = 0; i < ((IMethodNode)this.Target).FormatArgs.Count; i++)
                {
                    INode elem = ((IMethodNode)this.Target).FormatArgs[i];
                    string childHeader = this.Header.Replace("└", "　").Replace("├", "│");
                    if (i == 0) childHeader += "├";
                    else if (i == ((IMethodNode)this.Target).FormatArgs.Count - 1) childHeader += "└";
                    else childHeader += "├";

                    NodeSplitterVisitor v = new NodeSplitterVisitor();
                    v.Target = elem;
                    v.Id = this.Id;
                    v.Header = childHeader;
                    ret += "\r\n" + v.visit();
                    if (!string.IsNullOrWhiteSpace(v.idString)) this.idString = v.idString;
                }

            }
            else if (this.Target is IOperatorNode)
            {
                
                for(int i = 0 ; i < ((IFunctionNode)this.Target).Args.Count ; i++)
                {
                    INode elem = ((IFunctionNode)this.Target).Args[i];


                    if (elem is ISeparatorNode)
                    {
                        string childHeader = this.Header.Replace("└", "　").Replace("├", "│");
                        if (i == 0 && ((IFunctionNode)this.Target).Args.Count == 1) childHeader += "└";
                        else if (i == 0) childHeader += "├";
                        else if (i == ((IFunctionNode)this.Target).Args.Count - 1) childHeader += "└";
                        else childHeader += "│";

                        ArrayVisitor a = new ArrayVisitor();
                        a.target = elem;
                        foreach (INode aa in a.getArgs())
                        {
                            NodeSplitterVisitor v = new NodeSplitterVisitor();
                            v.Target = aa;
                            v.Id = this.Id;
                            v.Header = childHeader;
                            ret += "\r\n" + v.visit();
                            if (!string.IsNullOrWhiteSpace(v.idString)) this.idString = v.idString;
                        }
                    }
                    else
                    {
                        string childHeader = this.Header.Replace("└", "　").Replace("├", "│");
                        if (i == 0 && ((IFunctionNode)this.Target).Args.Count == 1) childHeader += "└";
                        else if (i == 0) childHeader += "├";
                        else if (i == ((IFunctionNode)this.Target).Args.Count - 1) childHeader += "└";
                        else childHeader += "│";

                        NodeSplitterVisitor v = new NodeSplitterVisitor();
                        v.Target = elem;
                        v.Id = this.Id;
                        v.Header = childHeader;
                        ret += "\r\n" + v.visit();
                        if (!string.IsNullOrWhiteSpace(v.idString)) this.idString = v.idString;
                    }
                }
            }
            return ret;
        }

    }
}
