﻿/**
FormulaDebugger.NodeSplitterOriginalVisitor

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;

namespace FormulaDebugger
{
    public class NodeSplitterOriginalVisitor
    {
        public INode Target { get; set; }
        public string Header { get; set; }
        public int Id { get; set; }
        public string idString { get; set; }

        public NodeSplitterOriginalVisitor()
        {
            this.Header = string.Empty;
        }

        public string visit(INode target = null)
        {
            if (target != null) this.Target = target;
            string ret = null;
            if (this.Target == null)
                ret = string.Format("{0}-null-", this.Header);
            else
                ret = string.Format("{0}{1}", this.Header, this.Target.ToString());
            if (this.Target != null && this.Id == this.Target.nodeId)
                this.idString = ret;

            if (this.Target is IFunctionNode)
            {
                for(int i = 0 ; i < ((IFunctionNode)this.Target).Args.Count ; i++)
                {
                    INode elem = ((IFunctionNode)this.Target).Args[i];
                    string childHeader = this.Header.Replace("└" , "　").Replace("├" , "│");
                    if (i == 0 && ((IFunctionNode)this.Target).Args.Count == 1) childHeader += "└"; 
                    else if (i == 0) childHeader += "├";
                    else if (i == ((IFunctionNode)this.Target).Args.Count - 1) childHeader += "└";
                    else childHeader += "│";

                    NodeSplitterOriginalVisitor v = new NodeSplitterOriginalVisitor();
                    v.Target = elem;
                    v.Id = this.Id;
                    v.Header = childHeader;
                    ret += "\r\n" + v.visit();
                    if (!string.IsNullOrWhiteSpace(v.idString)) this.idString = v.idString;
                }
            }
            return ret;
        }
    }
}
