﻿/**
FormulaDebugger.ColorSetVisitor

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula;
using Formula.Node;
using Formula.Node.Impl;
using FormulaDebugger.Utility;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FormulaDebugger
{
    public class ColorSetVisitor
    {
        /// <summary>
        /// ノードに従い、書式を設定します
        /// </summary>
        /// <param name="targetTextBox"></param>
        /// <param name="targetNode"></param>
        public static void visit(RichTextBox targetTextBox , INode targetNode)
        {
            if (targetNode == null || targetNode is BlankNode) return;
            Color color = Color.Black;
            bool itaric = false;
            bool bold = false;
            #region 変更する
            if (targetNode is IBracketNode)
            {
                color = ColorUtility.getInstance().getNextColor();
                bold = true;
                itaric = false;
            } else if (targetNode is ISeparatorNode)
            {
            }      
            else if (targetNode is IOperatorNode)
            {
                color = Color.Blue;
                itaric = false;
                bold = false;
            }
            else if (targetNode is IMethodNode)
            {
                color = Color.Blue;
                itaric = false;
                bold = true;
            }

            else if (targetNode is WordNode)
            {
                color = Color.Black;
                itaric = false;
                bold = true;
            }
            else if (targetNode is VariableNode)
            {
                itaric = true;
                bold = true;
                color = Color.Green;
            }
            else if (targetNode is IValueNode)
            {
                itaric = false;
                bold = false;
            }            
            targetTextBox.SelectionStart = targetNode.startPosition > 1 ? targetNode.startPosition - 1 : 0;
            targetTextBox.SelectionLength = targetNode.endPosition - targetNode.startPosition+1;
            Font baseFont = targetTextBox.SelectionFont;
            if (color != null)
                targetTextBox.SelectionColor = color;

            Font font = new Font(baseFont.FontFamily
                    , baseFont.Size
                    , FontStyle.Regular); ;

            if (itaric)
                font = new Font(baseFont.FontFamily
                    , baseFont.Size
                    , FontStyle.Italic);
            else if (bold)
                font = new Font(baseFont.FontFamily
                , baseFont.Size
                , FontStyle.Bold);
            else if (bold && itaric)
                font = new Font(baseFont.FontFamily
                    , baseFont.Size
                    , FontStyle.Bold | FontStyle.Italic);
            targetTextBox.SelectionFont = font;
            
            #endregion
            if(targetNode is IFunctionNode)
            {
                foreach(INode node in ((IFunctionNode)targetNode).Args)
                {
                    visit(targetTextBox, node);
                }
            }
        }
    }
}
