﻿/**
Formula.PositionSetVisitor

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;

namespace Formula
{
    /// <summary>
    /// 元の式における各ノードの出現位置をセットします。
    /// </summary>
    public class PositionSetVisitor
    {
        /// <summary>
        /// 元の式における各ノードの出現位置をセットします。
        /// (ノードの位置は自らの子供となるノードをすべて考慮した位置)
        /// </summary>
        /// <param name="currentNode">処理対象ノード</param>
        public static void updatePosition( INode currentNode )
        {
            if (currentNode == null) return;
            if (currentNode is IFunctionNode)
            {
                foreach (INode node in ((IFunctionNode)currentNode).Args)
                {
                    if (node == null || node is BlankNode) continue;
                    PositionSetVisitor visitor = new PositionSetVisitor();
                    PositionSetVisitor.updatePosition(node);
                    //visitor.updatePosition(node);
                    
                    if (node.startPosition < currentNode.startPosition)
                        currentNode.startPosition = node.startPosition;
                    if (currentNode.endPosition < node.endPosition)
                        currentNode.endPosition = node.endPosition;
                }
            }
        }
    }
}
