﻿/**
Formula.Node.NodeOriginalVisitor

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/


using Formula.Node;
namespace Formula
{
    /// <summary>
    /// 構文木を文字列化するためのクラス。
    /// </summary>
    public class NodeOriginalVisitor
    {
        public INode Target { get; set; }
        public string Header { get; set; }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public NodeOriginalVisitor()
        {
            this.Header = string.Empty;
        }

        /// <summary>
        /// ノードの文字列を組み立てます。
        /// 子供ノードがある場合は再帰します
        /// </summary>
        /// <param name="target"></param>
        /// <returns></returns>
        public string visit(INode target = null)
        {
            if (target != null) this.Target = target;
            string ret = null;
            if (this.Target == null)
                ret = string.Format("{0}-null-", this.Header);
            else
                ret = string.Format("{0}{1}", this.Header, this.Target.ToString());
            if (this.Target is IFunctionNode)
            {
                for(int i = 0 ; i < ((IFunctionNode)this.Target).Args.Count ; i++)
                {
                    INode elem = ((IFunctionNode)this.Target).Args[i];
                    string childHeader = this.Header.Replace("└" , "　").Replace("├" , "│");
                    if (i == 0 && ((IFunctionNode)this.Target).Args.Count == 1) childHeader += "└"; 
                    else if (i == 0) childHeader += "├";
                    else if (i == ((IFunctionNode)this.Target).Args.Count - 1) childHeader += "└";
                    else childHeader += "│";

                    NodeOriginalVisitor v = new NodeOriginalVisitor();
                    v.Target = elem;
                    v.Header = childHeader;
                    ret += "\r\n" + v.visit();
                }
            }
            return ret;
        }

    }
}
