﻿/**
Formula.Node.ObjectIdUtility

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

namespace Formula.Node
{
    /// <summary>
    /// ノードを区別するためのIDを採番するクラス
    /// </summary>
    class ObjectIdUtility
    {
        /// <summary>
        /// 次回振り出す番号
        /// </summary>
        int next = 0;
        static ObjectIdUtility instance = new ObjectIdUtility();

        /// <summary>
        /// コンストラクタ
        /// </summary>
        private ObjectIdUtility(){ }

        /// <summary>
        /// インスタンスを取得します
        /// </summary>
        /// <returns></returns>
        public static ObjectIdUtility getInstance()
        {
            return instance;
        }
        /// <summary>
        /// 採番する番号をリセットします
        /// </summary>
        public void reset()
        {
            this.next = 0;
        }
        /// <summary>
        /// 番号を振りだします
        /// </summary>
        /// <returns></returns>
        public int NextVal()
        {
            return next++;
        }

    }
}
