﻿/**
Formula.Node.Impl.VariableNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using System;
using System.Collections.Generic;

namespace Formula.Node
{
    /// <summary>
    /// 変数ノード
    /// </summary>
    public class VariableNode : AbstractValueNode
    {

        /// <summary>
        /// 変数テーブル
        /// </summary>
        public IDictionary<string, IValueNode> variableDictionary { get; set; }

        /// <summary>
        /// ノードを処理し、結果を返します
        /// </summary>
        /// <returns>結果を保持するノード</returns>
        public override INode eval()
        {
            if (!this.variableDictionary.ContainsKey(this.Value.ToString()))
            {
                throw new ArgumentException(string.Format("変数[{0}]が定義されていません。" , this.Value.ToString()));
            }
            return this.variableDictionary[this.Value.ToString()];
        }

        public override string ToString()
        {
            return string.Format("{0}:[V:{1}-{2}] {3}", this.nodeId , this.startPosition, this.endPosition, this.Value);
        }
    }
}
