﻿/**
Formula.Node.IValueNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

namespace Formula.Node
{
    /// <summary>
    /// 値を表現するノード
    /// </summary>
    public interface IValueNode : INode
    {
        /// <summary>
        /// ノードが保持する値
        /// </summary>
        object Value { get; set; }
        /// <summary>
        /// シグネチャ（正規表現）
        /// </summary>
        string Regex {  get; }
        /// <summary>
        /// ノードの値をdecimalで取得します
        /// </summary>
        /// <returns></returns>
        decimal? getDecimal();
        /// <summary>
        /// ノードの値をbooleanで取得します
        /// </summary>
        /// <returns></returns>
        bool getBoolean();
    }
}
