﻿/**
Formula.Node.IOperatorNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

namespace Formula.Node
{
    /// <summary>
    /// 演算子を示すインターフェイス
    /// </summary>
    public interface IOperatorNode : IFunctionNode
    {
        /// <summary>
        /// 優先度。高いほど演算子の優先順位が高い。
        /// </summary>
        int priority { get; }
        /// <summary>
        /// 演算子の左ノードを取得します
        /// </summary>
        /// <returns></returns>
        INode getLeftNode();
        /// <summary>
        /// 演算子の右ノードを取得します
        /// </summary>
        /// <returns></returns>
        INode getRightNode();
        /// <summary>
        /// 演算子の左ノードをセットします
        /// </summary>
        /// <param name="node"></param>
        void setLeftNode(INode node);
        /// <summary>
        /// 演算子の右ノードをセットします
        /// </summary>
        /// <param name="node"></param>
        void setRightNode(INode node);

        /// <summary>
        /// 演算子の左ノードが省略可能な場合TRUEを返します
        /// </summary>
        bool IsPermitLeftNodeBlank { get; }

        /// <summary>
        /// カレントノードを起点として置換すべきノードの親部分を取得します。
        /// </summary>
        /// <returns></returns>
        IOperatorNode getPriorityParentNode();
    }
}
