﻿
/**
Formula.Node.AbstractMethodNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

using System;
using System.Collections.Generic;

namespace Formula.Node
{
    /// <summary>
    /// メソッドの実装
    /// </summary>
    public abstract class AbstractMethodNode : AbstractFunctionNode, IMethodNode
    {
        /// <summary>
        /// 引数のリスト
        /// </summary>
        //protected List<INode> formatArgs;
        /// <summary>
        /// 引数のリスト
        /// </summary>
        public List<INode> FormatArgs
        {
            get {
                //if (this.formatArgs != null) return this.formatArgs;
                //this.formatArgs = new List<INode>();
                List<INode> formatArgs = new List<INode>();
                foreach (INode elem in this.Args)
                {
                    ArrayVisitor visitor = new ArrayVisitor();
                    visitor.target = elem;
                    formatArgs.AddRange(visitor.getArgs());
                }
                return formatArgs;
            }
        }
    }
}
