﻿/**
Formula.DllLoader

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using System;
using System.Collections.Generic;
using System.Reflection;
using System.IO;
using Formula.Node;
using System.Security.Permissions;
using System.Collections.Concurrent;

namespace Formula
{
    /// <summary>
    /// DLLを読みだすクラスです
    /// </summary>
    public class DllLoader 
    {
        /// <summary>
        /// 読み出し対象となるパス
        /// </summary>
        public string DllPath { get; set; }

        /// <summary>
        /// 読みだした情報
        /// </summary>
        public IDictionary<Type , Assembly> DllTable{get;set;}

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public DllLoader()
        {
            this.DllPath = Assembly.GetExecutingAssembly().Location;
            this.DllTable = new ConcurrentDictionary<Type, Assembly>();
        }

        /// <summary>
        /// 読み出しを行います
        /// </summary>
        public void Load()
        {
            if (string.IsNullOrWhiteSpace(this.DllPath)
                || !Directory.Exists(this.DllPath))
            {
                if (!File.Exists(this.DllPath)) return;
                FileInfo me = new FileInfo(this.DllPath);
                this.DllPath = me.Directory.FullName;
            }
                
            DirectoryInfo dir = new DirectoryInfo( this.DllPath);
            foreach(FileInfo f in dir.GetFiles("*.dll", SearchOption.TopDirectoryOnly))
            {
                Assembly asm = Assembly.LoadFrom(f.FullName);
                foreach (Type t in asm.GetTypes())
                {
                    if (!t.IsClass || !t.IsPublic || this.DllTable.ContainsKey(t)) continue;
                    if (t.GetInterface(typeof(INode).FullName) != null)
                        this.DllTable.Add(t, asm);

                }
            }
        }

    }
}
