!
! Copyright (C) 2017 Mitsuaki Kawamura
! This file is distributed under the terms of the
! GNU General Public License. See the file `License'
! in the root directory of the present distribution,
! or http://www.gnu.org/copyleft/gpl.txt .
!
MODULE sctk_dmuxc
  !
  IMPLICIT NONE
  !
CONTAINS
!
! Read dmxc(G)
!
SUBROUTINE read_dmxc()
  !
  USE io_global,  ONLY : ionode, ionode_id
  USE mp_world, ONLY : world_comm
  USE mp, ONLY : mp_bcast
  USE sctk_val, ONLY : dmxc, gmaxxc, gminxc
  !
  IMPLICIT NONE
  !
  INTEGER :: fi = 10
  !
  IF(ionode) THEN
     !
     open(fi, file = "dmuxc.dat")
     !
     READ(fi,*) gminxc(1:3), gmaxxc(1:3)
     WRITE(*,*) gminxc(1:3)
     WRITE(*,*) gmaxxc(1:3)
     ALLOCATE(dmxc(gminxc(1):gmaxxc(1), gminxc(2):gmaxxc(2), gminxc(3):gmaxxc(3)))
     !
     READ(fi,'(2e25.15)') dmxc(gminxc(1):gmaxxc(1), gminxc(2):gmaxxc(2), gminxc(3):gmaxxc(3))
     !
     close(fi)
     !
  END IF
  !
  CALL mp_bcast(gminxc,   ionode_id, world_comm )
  CALL mp_bcast(gmaxxc,   ionode_id, world_comm )
  IF(.NOT. ionode) &
  &  ALLOCATE(dmxc(gminxc(1):gmaxxc(1), gminxc(2):gmaxxc(2), gminxc(3):gmaxxc(3)))
  CALL mp_bcast(dmxc,   ionode_id, world_comm )
  !
END SUBROUTINE read_dmxc
!
! Apply XC term
!
SUBROUTINE apply_xc()
  !
  USE kinds, ONLY : DP
  USE sctk_val, ONLY : dmxc, gindx, gmaxxc, gminxc, gq2, igmin, laddxc, &
  &                     nf, nftot, ngv, nmf, wscr
  !
  USE sctk_cnt_dsp, ONLY : cnt_and_dsp
  !
  IMPLICIT NONE
  !
  INTEGER :: i1, i2, i3, ig, jg, imf, idg(3), igv0(3,nftot), cnt, dsp
  COMPLEX(dp) :: vec(ngv), one = CMPLX(1.0_dp, 0.0_dp, KIND=dp), &
  &              zero = CMPLX(0.0_dp, 0.0_dp, KIND=dp)
  COMPLEX(dp),ALLOCATABLE :: wscr0(:,:,:)
  !
  CALL cnt_and_dsp(ngv, cnt, dsp)
  ALLOCATE(wscr0(dsp + 1:dsp + cnt,0:nmf,ngv))
  !
  IF(laddxc == 1) THEN
     !
     ig = 0
     DO i3 = 1, nf(3)
        DO i2 = 1, nf(2)
           DO i1 = 1, nf(1)
              ig = ig + 1
              igv0(1:3,ig) = igmin(1:3) + (/i1, i2, i3/) - 1
           END DO ! i1
        END DO ! i2
     END DO ! i3
     !
     !$OMP PARALLEL DEFAULT(NONE) &
     !$OMP & SHARED(ngv,igv0,gminxc,gmaxxc,gq2,dmxc,cnt, &
     !$OMP &        dsp,one,zero,wscr,wscr0,nmf,gindx) &
     !$OMP & PRIVATE(ig,jg,idg,vec,imf)
     !
     !$OMP DO
     DO ig = 1, ngv
        !
        DO jg = 1, ngv
           !
           idg(1:3) = igv0(1:3,gindx(ig)) - igv0(1:3,gindx(jg))
           !
           IF(all(gminxc(1:3) <= idg(1:3)) .AND. all(idg(1:3) <= gmaxxc(1:3))) THEN
              vec(jg) = CMPLX(gq2(ig), 0.0_dp, KIND=dp) * dmxc(idg(1), idg(2), idg(3))
           ELSE
              vec(jg) = CMPLX(0.0_dp, 0.0_dp, KIND=dp)
           END IF
           !
        END DO
        vec(ig) = vec(ig) + CMPLX(1.0_dp, 0.0_dp, KIND=dp)
        !
        DO imf = 0, nmf
           CALL zgemv("T", ngv, cnt, one, wscr(1:ngv, dsp + 1:dsp + cnt, imf), &
           &          ngv, vec, 1, zero, wscr0(dsp+1:dsp+cnt,imf,ig), 1)
        END DO
        !
     END DO ! ig
     !$OMP END DO
     !$OMP END PARALLEL
     !
     DO ig = 1, ngv
        wscr(ig, dsp + 1:dsp + cnt, 0:nmf) = wscr0(dsp + 1:dsp + cnt, 0:nmf, ig)
     END DO
     !
  END IF
  !
  DO ig = dsp + 1, dsp + cnt
     wscr(ig, ig, 0:nmf) = wscr(ig, ig, 0:nmf) + CMPLX(gq2(ig), 0.0_dp, KIND=dp)
  END DO
  !
  DEALLOCATE(wscr0)
  !
END SUBROUTINE apply_xc
  !
END MODULE sctk_dmuxc
