package tm.tmdiagram.tmdeditor.model.command;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.gef.commands.Command;

import tm.tmdiagram.tmdeditor.model.AbstractConnectionModel;
import tm.tmdiagram.tmdeditor.model.ConnectableElement;
import tm.tmdiagram.tmdeditor.model.Diagram;
import tm.tmdiagram.tmdeditor.model.ModelElement;

public class ModelDeleteCommand extends Command {
	private Diagram diagram;
	private ModelElement model;
	private List<AbstractConnectionModel> sourceConnections = new ArrayList<AbstractConnectionModel>();
	private List<AbstractConnectionModel> targetConnections = new ArrayList<AbstractConnectionModel>();

	@Override
	public void execute() {
		System.out.println(getClass().toString() + "#execute()");
		diagram.removeChild(model);
		if (model instanceof ConnectableElement) {
			sourceConnections.addAll(((ConnectableElement)model).getModelSourceConnections());
			targetConnections.addAll(((ConnectableElement)model).getModelTargetConnections());
			detachConnections(sourceConnections);
			detachConnections(targetConnections);
		}

	}
	@Override
	public void undo() {
		diagram.addChild(model);
		if (model instanceof ConnectableElement) {
			attathConnections(sourceConnections);
			attathConnections(targetConnections);
			sourceConnections.clear();
			targetConnections.clear();
		}
	}
	public void setDiagram(Object diagram) {
		this.diagram = (Diagram) diagram;
	}
	public void setModel(Object model) {
		this.model = (ConnectableElement) model;
	}
	private void detachConnections(List<AbstractConnectionModel> connections) {
		for (AbstractConnectionModel model : connections) {
			model.detachSource();
			model.detachTarget();
		}
	}
	private void attathConnections(List<AbstractConnectionModel> connections) {
		for (AbstractConnectionModel model : connections) {
			model.attachSource();
			model.attachTarget();
		}
	}
}
