package tm.tmdiagram.tmdeditor.model.command;

import org.eclipse.gef.commands.Command;

import tm.tmdiagram.tmdeditor.model.AbstractConnectionModel;

public class ConnectionDeleteCommand extends Command {
	private AbstractConnectionModel connection;

	/* (non-Javadoc)
	 * @see org.eclipse.gef.commands.Command#execute()
	 */
	@Override
	public void execute() {
		System.out.println(getClass().toString() + "#execute()");
		connection.detachSource();
		connection.detachTarget();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.commands.Command#undo()
	 */
	@Override
	public void undo() {
		System.out.println(getClass().toString() + "#undo()");
		connection.attachSource();
		connection.attachTarget();
	}
	
	public void setConnection(Object connection) {
		this.connection = (AbstractConnectionModel) connection;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.commands.Command#chain(org.eclipse.gef.commands.Command)
	 */
	@Override
	public Command chain(Command command) {
		System.out.println(getClass().toString() + "#chain()");
		return super.chain(command);
	}
	
}
