package tm.tmdiagram.tmdeditor.model;


import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.geometry.Rectangle;

public abstract class AbstractEntityModel extends ConnectableElement {
	public enum EntityType {R, E, TS, TO, MO};

	public static final String P_CONSTRAINT = "p_constraint";
	public static final String P_ATTRIBUTE = "p_attribute";
	public static final String P_ATTRIBUTES = "p_attributes";
	protected Rectangle constraint;
	protected List<Identifier> reuseKeys = new ArrayList<Identifier>();
	private Attribute[] attributes = new Attribute[0];
	/**
	 * @return the constraint
	 */
	public Rectangle getConstraint() {
		return constraint;
	}

	/**
	 * @param constraint the constraint to set
	 */
	public void setConstraint(Rectangle constraint) {
		this.constraint = constraint;
		firePropertyChange(P_CONSTRAINT, null, constraint);
	}

	/**
	 * @return the reuseKeys
	 */
	public List<Identifier> getReuseKeys() {
		return reuseKeys;
	}

	/**
	 * @param reuseKeys the reuseKeys to set
	 */
	public void setReuseKeys(List<Identifier> reuseKeys) {
		this.reuseKeys = reuseKeys;
	}

	public void addReuseKey(Identifier reuseKey) {
		this.reuseKeys.add(reuseKey);
		firePropertyChange(P_ATTRIBUTE, null, reuseKey);
	}

	/**
	 * @return the attributes
	 */
	public Attribute[] getAttributes() {
		return attributes;
	}

	/**
	 * @param attributes the attributes to set
	 */
	public void setAttributes(Attribute[] attributes) {
		this.attributes = attributes;
		firePropertyChange(P_ATTRIBUTES, null, attributes);
	}
}
