/**
 * 
 */
package tm.tmdiagram.tmdeditor.model;


/**
 * @author hnakajima
 *
 */
public abstract class AbstractConnectionModel extends ConnectableElement {
	protected ConnectableElement source, target;

	public void attachSource() {
		if (!source.getModelSourceConnections().contains(this)){
			System.out.println("attachSource():source=" + source.getClass().toString());
			source.addSourceConnection(this);
		}
	}
	
	public void attachTarget() {
		if (!target.getModelTargetConnections().contains(this)){
			System.out.println("attachTarget():target=" + target.getClass().toString());
			target.addTargetConnection(this);
		}
	}
	
	public void detachSource() {
		if(source!=null){
			System.out.println("detachSource()");
			source.removeSourceConnection(this);
		}
	}
	
	public void detachTarget() {
		if(target!=null){
			System.out.println("detachTarget()");
			target.removeTargetConnection(this);
		}
	}

	public ConnectableElement getSource() {
		return source;
	}

	public void setSource(ConnectableElement source) {
		this.source = source;
	}

	public ConnectableElement getTarget() {
		return target;
	}

	public void setTarget(ConnectableElement target) {
		this.target = target;
	}
}
