package tm.tmdiagram.tmdeditor.editpart;

import java.util.List;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;

import tm.tmdiagram.tmdeditor.editpart.AbstractEntityEditPart.EntityComponentEditPolicy;
import tm.tmdiagram.tmdeditor.figure.EntityFigure;
import tm.tmdiagram.tmdeditor.model.AbstractEntityModel;
import tm.tmdiagram.tmdeditor.model.Attribute;
import tm.tmdiagram.tmdeditor.model.Identifier;
import tm.tmdiagram.tmdeditor.model.MappingList;

public class MappingListEditPart extends AbstractEntityEditPart {

	@Override
	protected IFigure createFigure() {
		EntityFigure figure = new EntityFigure();
		updateFigure(figure);

		return figure;
	}
	private void updateFigure(EntityFigure figure) {
		MappingList table = (MappingList)getModel();
		List<Identifier> ids = table.getReuseKeys();
		Attribute[] atts = table.getAttributes();
		figure.removeAllRelationship();
		figure.removeAllAttributes();

		figure.setEntityName(table.getName());
		for (Identifier i : ids) {
			figure.addRelationship(i.getName());
		}
		for (Attribute a : atts) {
			figure.addAttribute(a.getName());
		}
	}

	@Override
	protected void createEditPolicies() {
//		installEditPolicy(EditPolicy.COMPONENT_ROLE, new EntityComponentEditPolicy());
	}
	/* (non-Javadoc)
	 * @see org.eclipse.gef.editparts.AbstractEditPart#refreshVisuals()
	 */
	@Override
	protected void refreshVisuals() {
		System.out.println(getClass().toString() + "#refreshVisuals()");
		super.refreshVisuals();
		Object model = getModel();
		Rectangle bounds = new Rectangle(((AbstractEntityModel) model).getConstraint());
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(), bounds);

		updateFigure((EntityFigure) getFigure());
		refreshChildren();
	}

	
}
