/**
 * 
 */
package ter.diagram.editor.model.command;

import org.eclipse.gef.commands.Command;

import ter.diagram.editor.model.EntityBase;
import ter.diagram.editor.model.Identifier;

/**
 * @author ctc
 *
 */
public class EntityBaseIdentifierDirectEditCommand extends Command {
	private EntityBase entity;
	private Identifier identifier,newIdentifier;
	private String oldIdName, newIdName;
	
	public EntityBaseIdentifierDirectEditCommand(EntityBase entity, Identifier id, String newIdName) {
		this.entity = entity;
		this.identifier = id;
		this.oldIdName = id.getName();
		this.newIdName = newIdName;
	}
	/**
	 * @param entity 設定する entity
	 */
	public void setEntity(EntityBase entity) {
		this.entity = entity;
	}
	/**
	 * @param newIdentifier 設定する newIdentifier
	 */
	public void setNewIdentifier(Identifier newIdentifier) {
		this.newIdentifier = newIdentifier;
	}
	/**
	 * @param oldIdentifier 設定する oldIdentifier
	 */
	public void setOldIdentifier(Identifier oldIdentifier) {
		this.identifier = oldIdentifier;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.gef.commands.Command#execute()
	 */
	@Override
	public void execute() {
		
//		entity.setIdentifier(newIdentifier);
		identifier.setName(newIdName);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.gef.commands.Command#undo()
	 */
	@Override
	public void undo() {
		identifier.setName(oldIdName);
//		this.entity.setIdentifier(identifier);
	}
	
	
}
